/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.config.service;

import java.io.File;
import java.util.Objects;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.service.ArtifactResolverService;

class JKubeArtifactResolverService
implements ArtifactResolverService {
    private JavaProject project;

    JKubeArtifactResolverService(JavaProject project) {
        this.project = Objects.requireNonNull(project, "project");
    }

    public File resolveArtifact(String groupId, String artifactId, String version, String type) {
        String canonicalString = String.join((CharSequence)File.separator, groupId.split("\\.")) + File.separator + artifactId + File.separator + version + File.separator + artifactId + "-" + version + "." + type;
        if (this.project.getLocalRepositoryBaseDirectory() != null) {
            return new File(this.project.getLocalRepositoryBaseDirectory(), canonicalString);
        }
        throw new IllegalStateException("Cannot find artifact " + canonicalString + " within the resolved resources");
    }
}

