/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common.util;

import org.apache.commons.lang3.StringUtils;

public class SemanticVersionUtil {
    private SemanticVersionUtil() {
    }

    public static boolean isVersionAtLeast(int majorVersion, int minorVersion, String version) {
        if (StringUtils.isNotBlank((CharSequence)version) && version.contains(".")) {
            String[] versionParts = version.split("\\.");
            int parsedMajorVersion = SemanticVersionUtil.parseInt(versionParts[0]);
            if (parsedMajorVersion > majorVersion) {
                return true;
            }
            if (parsedMajorVersion == majorVersion) {
                return SemanticVersionUtil.parseInt(versionParts[1]) >= minorVersion;
            }
        }
        return false;
    }

    private static int parseInt(String toParse) {
        try {
            return Integer.parseInt(toParse);
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }
}

