/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common.util;

import java.util.HashMap;
import java.util.Map;
import org.fusesource.jansi.Ansi;

public class AnsiUtil {
    private static final Map<String, Ansi.Color> COLOR_MAP = new HashMap<String, Ansi.Color>();

    private AnsiUtil() {
    }

    public static String colored(String message, Color color, Object ... params) {
        Ansi ansi = Ansi.ansi().fg(color.ansiColor);
        return ansi.a(AnsiUtil.format(AnsiUtil.evaluateEmphasis(message, color), params)).reset().toString();
    }

    public static String format(String message, Object[] params) {
        if (params.length == 0) {
            return message;
        }
        if (params.length == 1 && params[0] instanceof Throwable) {
            return message + ": " + params[0];
        }
        return String.format(message, params);
    }

    private static String evaluateEmphasis(String message, Color color) {
        String[] parts = message.split("(\\[\\[(?=.]])|(?<=\\[\\[.)]])");
        if (parts.length == 1) {
            return message;
        }
        String msgColorS = Ansi.ansi().fg(color.ansiColor).toString();
        StringBuilder ret = new StringBuilder(parts[0]);
        for (int i = 1; i < parts.length; i += 4) {
            boolean plainPart;
            boolean colorPart = i + 1 < parts.length && parts[i + 1].length() > 0;
            boolean bl = plainPart = i + 3 < parts.length && parts[i + 3].length() > 0;
            if (colorPart) {
                ret.append(AnsiUtil.computeEmphasisColor(parts[i]));
                ret.append(parts[i + 1]);
                if (plainPart) {
                    ret.append(msgColorS);
                }
            }
            if (!plainPart) continue;
            ret.append(parts[i + 3]);
        }
        return ret.toString();
    }

    private static String computeEmphasisColor(String id) {
        Ansi.Color color = COLOR_MAP.get(id.toUpperCase());
        if (color != null) {
            return id.equals(id.toLowerCase()) ? Ansi.ansi().fgBright(color).toString() : Ansi.ansi().fg(color).toString();
        }
        return "";
    }

    static {
        COLOR_MAP.put("*", Color.EMPHASIS.ansiColor);
        COLOR_MAP.put("B", Ansi.Color.BLUE);
        COLOR_MAP.put("C", Ansi.Color.CYAN);
        COLOR_MAP.put("Y", Ansi.Color.YELLOW);
        COLOR_MAP.put("G", Ansi.Color.GREEN);
        COLOR_MAP.put("M", Ansi.Color.MAGENTA);
        COLOR_MAP.put("R", Ansi.Color.RED);
        COLOR_MAP.put("W", Ansi.Color.WHITE);
        COLOR_MAP.put("S", Ansi.Color.BLACK);
        COLOR_MAP.put("D", Ansi.Color.DEFAULT);
    }

    public static enum Color {
        ERROR(Ansi.Color.RED),
        INFO(Ansi.Color.GREEN),
        WARNING(Ansi.Color.YELLOW),
        PROGRESS_ID(Ansi.Color.YELLOW),
        PROGRESS_STATUS(Ansi.Color.GREEN),
        PROGRESS_BAR(Ansi.Color.CYAN),
        EMPHASIS(Ansi.Color.BLUE);

        final Ansi.Color ansiColor;

        private Color(Ansi.Color ansiColor) {
            this.ansiColor = ansiColor;
        }
    }
}

