/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.service.docker.config.handler.property;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.jkube.kit.build.service.docker.config.handler.property.ConfigKey;
import org.eclipse.jkube.kit.build.service.docker.config.handler.property.PropertyMode;
import org.eclipse.jkube.kit.build.service.docker.config.handler.property.ValueCombinePolicy;
import org.eclipse.jkube.kit.common.util.EnvUtil;

public class ValueProvider {
    private String prefix;
    private Properties properties;
    private PropertyMode propertyMode;
    private StringListValueExtractor stringListValueExtractor;
    private IntListValueExtractor intListValueExtractor;
    private MapValueExtractor mapValueExtractor;
    private StringValueExtractor stringValueExtractor;
    private IntValueExtractor intValueExtractor;
    private LongValueExtractor longValueExtractor;
    private BooleanValueExtractor booleanValueExtractor;
    private DoubleValueExtractor doubleValueExtractor;

    public ValueProvider(String prefix, Properties properties, PropertyMode propertyMode) {
        this.prefix = prefix;
        this.properties = properties;
        this.propertyMode = propertyMode;
        this.stringListValueExtractor = new StringListValueExtractor();
        this.intListValueExtractor = new IntListValueExtractor();
        this.mapValueExtractor = new MapValueExtractor();
        this.stringValueExtractor = new StringValueExtractor();
        this.intValueExtractor = new IntValueExtractor();
        this.longValueExtractor = new LongValueExtractor();
        this.booleanValueExtractor = new BooleanValueExtractor();
        this.doubleValueExtractor = new DoubleValueExtractor();
    }

    public String getString(ConfigKey key, String fromConfig) {
        return this.stringValueExtractor.getFromPreferredSource(this.prefix, key, fromConfig);
    }

    public Integer getInteger(ConfigKey key, Integer fromConfig) {
        return this.intValueExtractor.getFromPreferredSource(this.prefix, key, fromConfig);
    }

    public int getInt(ConfigKey key, Integer fromConfig) {
        Integer integer = this.getInteger(key, fromConfig);
        if (integer == null) {
            return 0;
        }
        return integer;
    }

    public Long getLong(ConfigKey key, Long fromConfig) {
        return this.longValueExtractor.getFromPreferredSource(this.prefix, key, fromConfig);
    }

    public Boolean getBoolean(ConfigKey key, Boolean fromConfig) {
        return this.booleanValueExtractor.getFromPreferredSource(this.prefix, key, fromConfig);
    }

    public List<String> getList(ConfigKey key, List<String> fromConfig) {
        return this.stringListValueExtractor.getFromPreferredSource(this.prefix, key, fromConfig);
    }

    public List<Integer> getIntList(ConfigKey key, List<Integer> fromConfig) {
        return this.intListValueExtractor.getFromPreferredSource(this.prefix, key, fromConfig);
    }

    public Map<String, String> getMap(ConfigKey key, Map<String, String> fromConfig) {
        return this.mapValueExtractor.getFromPreferredSource(this.prefix, key, fromConfig);
    }

    public Double getDouble(ConfigKey key, Double fromConfig) {
        return this.doubleValueExtractor.getFromPreferredSource(this.prefix, key, fromConfig);
    }

    public <T> T getObject(ConfigKey key, T fromConfig, final Function<String, T> converter) {
        ValueExtractor arbitraryExtractor = new ValueExtractor<T>(){

            @Override
            protected T withPrefix(String prefix, ConfigKey key, Properties properties) {
                return converter.apply((Object)properties.getProperty(key.asPropertyKey(prefix)));
            }
        };
        return arbitraryExtractor.getFromPreferredSource(this.prefix, key, fromConfig);
    }

    private class MapValueExtractor
    extends ValueExtractor<Map<String, String>> {
        private MapValueExtractor() {
        }

        @Override
        protected Map<String, String> withPrefix(String prefix, ConfigKey key, Properties properties) {
            return EnvUtil.extractFromPropertiesAsMap((String)key.asPropertyKey(prefix), (Properties)properties);
        }

        @Override
        protected Map<String, String> merge(ConfigKey key, List<Map<String, String>> values) {
            Map<String, String> merged = null;
            for (int i = values.size() - 1; i >= 0; --i) {
                Map<String, String> value = values.get(i);
                if (merged == null) {
                    merged = value;
                    continue;
                }
                merged.putAll(value);
            }
            return merged;
        }
    }

    private class IntListValueExtractor
    extends ListValueExtractor<Integer> {
        private IntListValueExtractor() {
        }

        @Override
        protected List<Integer> process(List<String> strings) {
            ArrayList<Integer> ints = new ArrayList<Integer>();
            for (String s : strings) {
                ints.add(s != null ? Integer.parseInt(s) : 0);
            }
            return ints;
        }
    }

    private class StringListValueExtractor
    extends ListValueExtractor<String> {
        private StringListValueExtractor() {
        }

        @Override
        protected List<String> process(List<String> strings) {
            return strings;
        }
    }

    private abstract class ListValueExtractor<T>
    extends ValueExtractor<List<T>> {
        private ListValueExtractor() {
        }

        @Override
        protected List<T> withPrefix(String prefix, ConfigKey key, Properties properties) {
            List strings = EnvUtil.extractFromPropertiesAsList((String)key.asPropertyKey(prefix), (Properties)properties);
            if (strings == null) {
                return null;
            }
            return this.process(strings);
        }

        protected abstract List<T> process(List<String> var1);

        @Override
        protected List<T> merge(ConfigKey key, List<List<T>> values) {
            ArrayList<T> merged = new ArrayList<T>();
            for (List<T> value : values) {
                merged.addAll(value);
            }
            return merged;
        }
    }

    private class DoubleValueExtractor
    extends ValueExtractor<Double> {
        private DoubleValueExtractor() {
        }

        @Override
        protected Double withPrefix(String prefix, ConfigKey key, Properties properties) {
            String prop = properties.getProperty(key.asPropertyKey(prefix));
            return prop == null ? null : Double.valueOf(prop);
        }
    }

    private class BooleanValueExtractor
    extends ValueExtractor<Boolean> {
        private BooleanValueExtractor() {
        }

        @Override
        protected Boolean withPrefix(String prefix, ConfigKey key, Properties properties) {
            String prop = properties.getProperty(key.asPropertyKey(prefix));
            return prop == null ? null : Boolean.valueOf(prop);
        }
    }

    private class LongValueExtractor
    extends ValueExtractor<Long> {
        private LongValueExtractor() {
        }

        @Override
        protected Long withPrefix(String prefix, ConfigKey key, Properties properties) {
            String prop = properties.getProperty(key.asPropertyKey(prefix));
            return prop == null ? null : Long.valueOf(prop);
        }
    }

    private class IntValueExtractor
    extends ValueExtractor<Integer> {
        private IntValueExtractor() {
        }

        @Override
        protected Integer withPrefix(String prefix, ConfigKey key, Properties properties) {
            String prop = properties.getProperty(key.asPropertyKey(prefix));
            return prop == null ? null : Integer.valueOf(prop);
        }
    }

    private class StringValueExtractor
    extends ValueExtractor<String> {
        private StringValueExtractor() {
        }

        @Override
        protected String withPrefix(String prefix, ConfigKey key, Properties properties) {
            return properties.getProperty(key.asPropertyKey(prefix));
        }
    }

    private abstract class ValueExtractor<T> {
        private ValueExtractor() {
        }

        T getFromPreferredSource(String prefix, ConfigKey key, T fromConfig) {
            if (ValueProvider.this.propertyMode == PropertyMode.Skip) {
                return fromConfig;
            }
            ArrayList<T> values = new ArrayList<T>();
            T fromProperty = this.withPrefix(prefix, key, ValueProvider.this.properties);
            if (fromProperty == null && fromConfig == null) {
                return null;
            }
            switch (ValueProvider.this.propertyMode) {
                case Only: {
                    return fromProperty;
                }
                case Override: {
                    if (fromProperty != null) {
                        values.add(fromProperty);
                    }
                    if (fromConfig == null) break;
                    values.add(fromConfig);
                    break;
                }
                case Fallback: {
                    if (fromConfig != null) {
                        values.add(fromConfig);
                    }
                    if (fromProperty == null) break;
                    values.add(fromProperty);
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Invalid PropertyMode");
                }
            }
            if (values.size() == 1) {
                return (T)values.get(0);
            }
            ValueCombinePolicy combinePolicy = key.getValueCombinePolicy();
            String overrideCombinePolicy = ValueProvider.this.properties.getProperty(key.asPropertyKey(prefix) + "." + "_combine");
            if (overrideCombinePolicy != null) {
                combinePolicy = ValueCombinePolicy.fromString(overrideCombinePolicy);
            }
            switch (combinePolicy) {
                case Replace: {
                    return (T)values.get(0);
                }
                case Merge: {
                    return (T)this.merge(key, values);
                }
            }
            return null;
        }

        protected abstract T withPrefix(String var1, ConfigKey var2, Properties var3);

        protected T merge(ConfigKey key, List<T> values) {
            throw new IllegalArgumentException("Combine policy Merge is not available for " + key.asPropertyKey(ValueProvider.this.prefix));
        }
    }
}

