/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.api.errors.DetachedHeadException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRefNameException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.TooLargeObjectInPackException;
import org.eclipse.jgit.api.errors.TooLargePackException;
import org.eclipse.jgit.api.errors.TransportException;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.BranchConfig;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.PushConfig;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RefLeaseSpec;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.Transport;

public class PushCommand
extends TransportCommand<PushCommand, Iterable<PushResult>> {
    private String remote;
    private final List<RefSpec> refSpecs;
    private final Map<String, RefLeaseSpec> refLeaseSpecs;
    private ProgressMonitor monitor = NullProgressMonitor.INSTANCE;
    private String receivePack = "git-receive-pack";
    private boolean dryRun;
    private boolean atomic;
    private boolean force;
    private boolean thin = false;
    private OutputStream out;
    private List<String> pushOptions;
    private PushConfig.PushDefault pushDefault = PushConfig.PushDefault.CURRENT;

    protected PushCommand(Repository repo) {
        super(repo);
        this.refSpecs = new ArrayList<RefSpec>(3);
        this.refLeaseSpecs = new HashMap<String, RefLeaseSpec>();
    }

    @Override
    public Iterable<PushResult> call() throws GitAPIException, InvalidRemoteException, TransportException {
        this.checkCallable();
        this.setCallable(false);
        ArrayList<PushResult> pushResults = new ArrayList<PushResult>(3);
        try {
            StoredConfig config = this.repo.getConfig();
            this.remote = this.determineRemote(config, this.remote);
            if (this.refSpecs.isEmpty()) {
                RemoteConfig rc = new RemoteConfig(config, this.getRemote());
                this.refSpecs.addAll(rc.getPushRefSpecs());
                if (this.refSpecs.isEmpty()) {
                    this.determineDefaultRefSpecs(config);
                }
            }
            if (this.force) {
                int i = 0;
                while (i < this.refSpecs.size()) {
                    this.refSpecs.set(i, this.refSpecs.get(i).setForceUpdate(true));
                    ++i;
                }
            }
            List<Transport> transports = Transport.openAll(this.repo, this.remote, Transport.Operation.PUSH);
            for (Transport transport : transports) {
                transport.setPushThin(this.thin);
                transport.setPushAtomic(this.atomic);
                if (this.receivePack != null) {
                    transport.setOptionReceivePack(this.receivePack);
                }
                transport.setDryRun(this.dryRun);
                transport.setPushOptions(this.pushOptions);
                this.configure(transport);
                Collection<RemoteRefUpdate> toPush = transport.findRemoteRefUpdatesFor(this.refSpecs, this.refLeaseSpecs);
                try {
                    try {
                        PushResult result = transport.push(this.monitor, toPush, this.out);
                        pushResults.add(result);
                    }
                    catch (org.eclipse.jgit.errors.TooLargePackException e) {
                        throw new TooLargePackException(e.getMessage(), e);
                    }
                    catch (org.eclipse.jgit.errors.TooLargeObjectInPackException e) {
                        throw new TooLargeObjectInPackException(e.getMessage(), e);
                    }
                    catch (org.eclipse.jgit.errors.TransportException e) {
                        throw new TransportException(e.getMessage(), e);
                    }
                }
                finally {
                    transport.close();
                }
            }
        }
        catch (URISyntaxException e) {
            throw new InvalidRemoteException(MessageFormat.format(JGitText.get().invalidRemote, this.remote), e);
        }
        catch (org.eclipse.jgit.errors.TransportException e) {
            throw new TransportException(e.getMessage(), e);
        }
        catch (NotSupportedException e) {
            throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfPushCommand, e);
        }
        catch (IOException e) {
            throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfPushCommand, e);
        }
        return pushResults;
    }

    private String determineRemote(Config config, String remoteName) throws IOException {
        if (remoteName != null) {
            return remoteName;
        }
        Ref head = this.repo.exactRef("HEAD");
        String effectiveRemote = null;
        BranchConfig branchCfg = null;
        if (head != null && head.isSymbolic()) {
            String currentBranch = head.getLeaf().getName();
            branchCfg = new BranchConfig(config, Repository.shortenRefName(currentBranch));
            effectiveRemote = branchCfg.getPushRemote();
        }
        if (effectiveRemote == null && (effectiveRemote = config.getString("remote", null, "pushDefault")) == null && branchCfg != null) {
            effectiveRemote = branchCfg.getRemote();
        }
        if (effectiveRemote == null) {
            effectiveRemote = "origin";
        }
        return effectiveRemote;
    }

    private String getCurrentBranch() throws IOException, DetachedHeadException {
        Ref head = this.repo.exactRef("HEAD");
        if (head != null && head.isSymbolic()) {
            return head.getLeaf().getName();
        }
        throw new DetachedHeadException();
    }

    private void determineDefaultRefSpecs(Config config) throws IOException, GitAPIException {
        if (this.pushDefault == null) {
            this.pushDefault = config.get(PushConfig::new).getPushDefault();
        }
        switch (this.pushDefault) {
            case CURRENT: {
                this.refSpecs.add(new RefSpec(this.getCurrentBranch()));
                break;
            }
            case MATCHING: {
                this.refSpecs.add(new RefSpec(":"));
                break;
            }
            case NOTHING: {
                throw new InvalidRefNameException(JGitText.get().pushDefaultNothing);
            }
            case UPSTREAM: 
            case SIMPLE: {
                boolean isTriangular;
                String currentBranch = this.getCurrentBranch();
                BranchConfig branchCfg = new BranchConfig(config, Repository.shortenRefName(currentBranch));
                String fetchRemote = branchCfg.getRemote();
                if (fetchRemote == null) {
                    fetchRemote = "origin";
                }
                boolean bl = isTriangular = !fetchRemote.equals(this.remote);
                if (isTriangular) {
                    if (PushConfig.PushDefault.UPSTREAM.equals(this.pushDefault)) {
                        throw new InvalidRefNameException(MessageFormat.format(JGitText.get().pushDefaultTriangularUpstream, this.remote, fetchRemote));
                    }
                    this.refSpecs.add(new RefSpec(currentBranch));
                    break;
                }
                String trackedBranch = branchCfg.getMerge();
                if (branchCfg.isRemoteLocal() || trackedBranch == null || !trackedBranch.startsWith("refs/heads/")) {
                    throw new InvalidRefNameException(MessageFormat.format(JGitText.get().pushDefaultNoUpstream, currentBranch));
                }
                if (PushConfig.PushDefault.SIMPLE.equals(this.pushDefault) && !trackedBranch.equals(currentBranch)) {
                    throw new InvalidRefNameException(MessageFormat.format(JGitText.get().pushDefaultSimple, currentBranch, trackedBranch));
                }
                this.refSpecs.add(new RefSpec(String.valueOf(currentBranch) + ':' + trackedBranch));
                break;
            }
            default: {
                throw new InvalidRefNameException(MessageFormat.format(JGitText.get().pushDefaultUnknown, this.pushDefault));
            }
        }
    }

    public PushCommand setRemote(String remote) {
        this.checkCallable();
        this.remote = remote;
        return this;
    }

    public String getRemote() {
        return this.remote;
    }

    public PushCommand setReceivePack(String receivePack) {
        this.checkCallable();
        this.receivePack = receivePack;
        return this;
    }

    public String getReceivePack() {
        return this.receivePack;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public ProgressMonitor getProgressMonitor() {
        return this.monitor;
    }

    public PushCommand setProgressMonitor(ProgressMonitor monitor) {
        this.checkCallable();
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        this.monitor = monitor;
        return this;
    }

    public List<RefLeaseSpec> getRefLeaseSpecs() {
        return new ArrayList<RefLeaseSpec>(this.refLeaseSpecs.values());
    }

    public PushCommand setRefLeaseSpecs(RefLeaseSpec ... specs) {
        return this.setRefLeaseSpecs(Arrays.asList(specs));
    }

    public PushCommand setRefLeaseSpecs(List<RefLeaseSpec> specs) {
        this.checkCallable();
        this.refLeaseSpecs.clear();
        for (RefLeaseSpec spec : specs) {
            this.refLeaseSpecs.put(spec.getRef(), spec);
        }
        return this;
    }

    public List<RefSpec> getRefSpecs() {
        return this.refSpecs;
    }

    public PushCommand setRefSpecs(RefSpec ... specs) {
        this.checkCallable();
        this.refSpecs.clear();
        Collections.addAll(this.refSpecs, specs);
        return this;
    }

    public PushCommand setRefSpecs(List<RefSpec> specs) {
        this.checkCallable();
        this.refSpecs.clear();
        this.refSpecs.addAll(specs);
        return this;
    }

    public PushConfig.PushDefault getPushDefault() {
        return this.pushDefault;
    }

    public PushCommand setPushDefault(PushConfig.PushDefault pushDefault) {
        this.checkCallable();
        this.pushDefault = pushDefault;
        return this;
    }

    public PushCommand setPushAll() {
        this.refSpecs.add(Transport.REFSPEC_PUSH_ALL);
        return this;
    }

    public PushCommand setPushTags() {
        this.refSpecs.add(Transport.REFSPEC_TAGS);
        return this;
    }

    public PushCommand add(Ref ref) {
        this.refSpecs.add(new RefSpec(ref.getLeaf().getName()));
        return this;
    }

    public PushCommand add(String nameOrSpec) {
        if (nameOrSpec.indexOf(58) >= 0) {
            this.refSpecs.add(new RefSpec(nameOrSpec));
        } else {
            Ref src;
            try {
                src = this.repo.findRef(nameOrSpec);
            }
            catch (IOException e) {
                throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfPushCommand, e);
            }
            if (src != null) {
                this.add(src);
            }
        }
        return this;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public PushCommand setDryRun(boolean dryRun) {
        this.checkCallable();
        this.dryRun = dryRun;
        return this;
    }

    public boolean isThin() {
        return this.thin;
    }

    public PushCommand setThin(boolean thin) {
        this.checkCallable();
        this.thin = thin;
        return this;
    }

    public boolean isAtomic() {
        return this.atomic;
    }

    public PushCommand setAtomic(boolean atomic) {
        this.checkCallable();
        this.atomic = atomic;
        return this;
    }

    public boolean isForce() {
        return this.force;
    }

    public PushCommand setForce(boolean force) {
        this.checkCallable();
        this.force = force;
        return this;
    }

    public PushCommand setOutputStream(OutputStream out) {
        this.out = out;
        return this;
    }

    public List<String> getPushOptions() {
        return this.pushOptions;
    }

    public PushCommand setPushOptions(List<String> pushOptions) {
        this.pushOptions = pushOptions;
        return this;
    }
}

