/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.io.IOException;
import java.util.Objects;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.revwalk.AddToBitmapFilter;
import org.eclipse.jgit.lib.BitmapIndex;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;

class BitmapCalculator {
    private final RevWalk walk;
    private final BitmapIndex bitmapIndex;

    BitmapCalculator(RevWalk walk) throws IOException {
        this.walk = walk;
        this.bitmapIndex = Objects.requireNonNull(walk.getObjectReader().getBitmapIndex());
    }

    BitmapIndex.BitmapBuilder getBitmap(RevCommit start, ProgressMonitor pm) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        BitmapIndex.Bitmap precalculatedBitmap = this.bitmapIndex.getBitmap(start);
        if (precalculatedBitmap != null) {
            return this.asBitmapBuilder(precalculatedBitmap);
        }
        this.walk.reset();
        this.walk.sort(RevSort.TOPO);
        this.walk.markStart(start);
        BitmapIndex.BitmapBuilder bitmapResult = this.bitmapIndex.newBitmapBuilder();
        this.walk.setRevFilter(new AddToBitmapFilter(bitmapResult));
        while (this.walk.next() != null) {
            pm.update(1);
        }
        return bitmapResult;
    }

    private BitmapIndex.BitmapBuilder asBitmapBuilder(BitmapIndex.Bitmap bitmap) {
        return this.bitmapIndex.newBitmapBuilder().or(bitmap);
    }
}

