/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.errors.MissingBundlePrerequisiteException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.PackProtocolException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.PackLock;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.BaseFetchConnection;
import org.eclipse.jgit.transport.PackParser;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.RawParseUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BundleFetchConnection
extends BaseFetchConnection {
    private final Transport transport;
    InputStream bin;
    final Map<ObjectId, String> prereqs = new HashMap<ObjectId, String>();
    private String lockMessage;
    private PackLock packLock;

    BundleFetchConnection(Transport transportBundle, InputStream src) throws TransportException {
        this.transport = transportBundle;
        this.bin = new BufferedInputStream(src);
        try {
            switch (this.readSignature()) {
                case 2: {
                    this.readBundleV2();
                    break;
                }
                default: {
                    throw new TransportException(this.transport.uri, JGitText.get().notABundle);
                }
            }
        }
        catch (TransportException err) {
            this.close();
            throw err;
        }
        catch (IOException err) {
            this.close();
            throw new TransportException(this.transport.uri, err.getMessage(), err);
        }
        catch (RuntimeException err) {
            this.close();
            throw new TransportException(this.transport.uri, err.getMessage(), err);
        }
    }

    private int readSignature() throws IOException {
        String rev = this.readLine(new byte[1024]);
        if ("# v2 git bundle".equals(rev)) {
            return 2;
        }
        throw new TransportException(this.transport.uri, JGitText.get().notABundle);
    }

    private void readBundleV2() throws IOException {
        String line;
        byte[] hdrbuf = new byte[1024];
        LinkedHashMap<String, Ref> avail = new LinkedHashMap<String, Ref>();
        while ((line = this.readLine(hdrbuf)).length() != 0) {
            ObjectId id;
            if (line.charAt(0) == '-') {
                ObjectId id2 = ObjectId.fromString(line.substring(1, 41));
                String shortDesc = null;
                if (line.length() > 42) {
                    shortDesc = line.substring(42);
                }
                this.prereqs.put(id2, shortDesc);
                continue;
            }
            String name = line.substring(41, line.length());
            Ref prior = avail.put(name, new ObjectIdRef.Unpeeled(Ref.Storage.NETWORK, name, id = ObjectId.fromString(line.substring(0, 40))));
            if (prior == null) continue;
            throw this.duplicateAdvertisement(name);
        }
        this.available(avail);
    }

    private PackProtocolException duplicateAdvertisement(String name) {
        return new PackProtocolException(this.transport.uri, MessageFormat.format(JGitText.get().duplicateAdvertisementsOf, name));
    }

    private String readLine(byte[] hdrbuf) throws IOException {
        int lf;
        this.bin.mark(hdrbuf.length);
        int cnt = this.bin.read(hdrbuf);
        for (lf = 0; lf < cnt && hdrbuf[lf] != 10; ++lf) {
        }
        this.bin.reset();
        IO.skipFully(this.bin, lf);
        if (lf < cnt && hdrbuf[lf] == 10) {
            IO.skipFully(this.bin, 1L);
        }
        return RawParseUtils.decode(Constants.CHARSET, hdrbuf, 0, lf);
    }

    @Override
    public boolean didFetchTestConnectivity() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doFetch(ProgressMonitor monitor, Collection<Ref> want, Set<ObjectId> have) throws TransportException {
        this.verifyPrerequisites();
        try {
            ObjectInserter ins = this.transport.local.newObjectInserter();
            try {
                PackParser parser = ins.newPackParser(this.bin);
                parser.setAllowThin(true);
                parser.setObjectChecking(this.transport.isCheckFetchedObjects());
                parser.setLockMessage(this.lockMessage);
                this.packLock = parser.parse(NullProgressMonitor.INSTANCE);
                ins.flush();
                Object var7_8 = null;
                ins.release();
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                ins.release();
                throw throwable;
            }
        }
        catch (IOException err) {
            this.close();
            throw new TransportException(this.transport.uri, err.getMessage(), err);
        }
        catch (RuntimeException err) {
            this.close();
            throw new TransportException(this.transport.uri, err.getMessage(), err);
        }
    }

    @Override
    public void setPackLockMessage(String message) {
        this.lockMessage = message;
    }

    @Override
    public Collection<PackLock> getPackLocks() {
        if (this.packLock != null) {
            return Collections.singleton(this.packLock);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyPrerequisites() throws TransportException {
        if (this.prereqs.isEmpty()) {
            return;
        }
        RevWalk rw = new RevWalk(this.transport.local);
        try {
            RevFlag PREREQ = rw.newFlag("PREREQ");
            RevFlag SEEN = rw.newFlag("SEEN");
            HashMap<ObjectId, String> missing = new HashMap<ObjectId, String>();
            ArrayList<RevCommit> commits = new ArrayList<RevCommit>();
            for (Map.Entry<ObjectId, String> e : this.prereqs.entrySet()) {
                ObjectId objectId = e.getKey();
                try {
                    RevCommit c = rw.parseCommit(objectId);
                    if (c.has(PREREQ)) continue;
                    c.add(PREREQ);
                    commits.add(c);
                }
                catch (MissingObjectException notFound) {
                    missing.put(objectId, e.getValue());
                }
                catch (IOException err) {
                    throw new TransportException(this.transport.uri, MessageFormat.format(JGitText.get().cannotReadCommit, objectId.name()), err);
                }
            }
            if (!missing.isEmpty()) {
                throw new MissingBundlePrerequisiteException(this.transport.uri, missing);
            }
            for (Ref r : this.transport.local.getAllRefs().values()) {
                try {
                    rw.markStart(rw.parseCommit(r.getObjectId()));
                }
                catch (IOException iOException) {}
            }
            int remaining = commits.size();
            try {
                RevCommit c;
                while ((c = rw.next()) != null) {
                    if (!c.has(PREREQ)) continue;
                    c.add(SEEN);
                    if (--remaining != 0) continue;
                    break;
                }
            }
            catch (IOException err) {
                throw new TransportException(this.transport.uri, JGitText.get().cannotReadObject, err);
            }
            if (remaining > 0) {
                for (RevObject revObject : commits) {
                    if (revObject.has(SEEN)) continue;
                    missing.put(revObject, this.prereqs.get(revObject));
                }
                throw new MissingBundlePrerequisiteException(this.transport.uri, missing);
            }
            Object var11_18 = null;
            rw.release();
        }
        catch (Throwable throwable) {
            Object var11_19 = null;
            rw.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.bin != null) {
            try {
                try {
                    this.bin.close();
                }
                catch (IOException iOException) {
                    Object var3_2 = null;
                    this.bin = null;
                }
                Object var3_1 = null;
                this.bin = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.bin = null;
                throw throwable;
            }
        }
    }
}

