/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.merge;

import java.io.IOException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.Merger;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;

public abstract class ThreeWayMerger
extends Merger {
    private RevTree baseTree;

    protected ThreeWayMerger(Repository local) {
        super(local);
    }

    protected ThreeWayMerger(Repository local, boolean inCore) {
        this(local);
    }

    public void setBase(AnyObjectId id) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        this.baseTree = id != null ? this.walk.parseTree(id) : null;
    }

    public boolean merge(AnyObjectId ... tips) throws IOException {
        if (tips.length != 2) {
            return false;
        }
        return super.merge(tips);
    }

    protected AbstractTreeIterator mergeBase() throws IOException {
        if (this.baseTree != null) {
            return this.openTree(this.baseTree);
        }
        return this.mergeBase(this.sourceCommits[0], this.sourceCommits[1]);
    }
}

