/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.test;

import java.nio.ByteBuffer;
import org.eclipse.jetty.toolchain.test.ByteBufferUtils;

public final class Hex {
    private static final char[] hexcodes = "0123456789ABCDEF".toCharArray();

    public static byte[] asByteArray(String hexString) {
        if (hexString.length() < 0 || hexString.length() % 2 != 0) {
            throw new IllegalArgumentException(String.format("Invalid string length of <%d>", hexString.length()));
        }
        int size = hexString.length() / 2;
        byte[] buf = new byte[size];
        int len = hexString.length();
        int idx = (int)Math.floor(((double)(size * 2) - (double)len) / 2.0);
        for (int i = 0; i < len; ++i) {
            byte hex = 0;
            if (i >= 0) {
                hex = (byte)(Character.digit(hexString.charAt(i), 16) << 4);
            }
            buf[idx] = hex = (byte)(hex + (byte)Character.digit(hexString.charAt(++i), 16));
            ++idx;
        }
        return buf;
    }

    public static ByteBuffer asByteBuffer(String hexString) {
        return ByteBuffer.wrap(Hex.asByteArray(hexString));
    }

    public static String asHex(byte[] buffer) {
        int len = buffer.length;
        char[] out = new char[len * 2];
        for (int i = 0; i < len; ++i) {
            out[i * 2] = hexcodes[(buffer[i] & 0xF0) >> 4];
            out[i * 2 + 1] = hexcodes[buffer[i] & 0xF];
        }
        return String.valueOf(out);
    }

    public static String asHex(ByteBuffer buffer) {
        return Hex.asHex(ByteBufferUtils.toArray(buffer));
    }
}

