/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.RuntimeIOException;
import org.eclipse.jetty.quic.client.ClientQuicSession;
import org.eclipse.jetty.quic.client.QuicClientConnectorConfigurator;
import org.eclipse.jetty.quic.common.QuicConfiguration;
import org.eclipse.jetty.quic.common.QuicConnection;
import org.eclipse.jetty.quic.common.QuicSession;
import org.eclipse.jetty.quic.quiche.QuicheConfig;
import org.eclipse.jetty.quic.quiche.QuicheConnection;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.thread.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientQuicConnection
extends QuicConnection {
    private static final Logger LOG = LoggerFactory.getLogger(ClientQuicConnection.class);
    private final Map<SocketAddress, ClientQuicSession> pendingSessions = new ConcurrentHashMap<SocketAddress, ClientQuicSession>();
    private final ClientConnector connector;
    private final Map<String, Object> context;
    private Scheduler.Task connectTask;

    public ClientQuicConnection(ClientConnector connector, EndPoint endPoint, Map<String, Object> context) {
        super(connector.getExecutor(), connector.getScheduler(), connector.getByteBufferPool(), endPoint);
        this.connector = connector;
        this.context = context;
    }

    public void onOpen() {
        try {
            super.onOpen();
            QuicConfiguration quicConfiguration = (QuicConfiguration)this.context.get(QuicConfiguration.CONTEXT_KEY);
            List protocols = quicConfiguration.getProtocols();
            if ((protocols == null || protocols.isEmpty()) && ((protocols = (List)this.context.get("org.eclipse.jetty.client.connector.applicationProtocols")) == null || protocols.isEmpty())) {
                throw new IllegalStateException("Missing ALPN protocols");
            }
            QuicheConfig quicheConfig = new QuicheConfig();
            quicheConfig.setApplicationProtos((String[])protocols.toArray(String[]::new));
            quicheConfig.setDisableActiveMigration(Boolean.valueOf(quicConfiguration.isDisableActiveMigration()));
            quicheConfig.setVerifyPeer(Boolean.valueOf(!this.connector.getSslContextFactory().isTrustAll()));
            Map implCtx = quicConfiguration.getImplementationConfiguration();
            quicheConfig.setTrustedCertsPemPath((String)implCtx.get(QuicClientConnectorConfigurator.TRUSTED_CERTIFICATES_PEM_PATH_KEY));
            quicheConfig.setPrivKeyPemPath((String)implCtx.get(QuicClientConnectorConfigurator.PRIVATE_KEY_PEM_PATH_KEY));
            quicheConfig.setCertChainPemPath((String)implCtx.get(QuicClientConnectorConfigurator.CERTIFICATE_CHAIN_PEM_PATH_KEY));
            quicheConfig.setMaxIdleTimeout(Long.valueOf(0L));
            quicheConfig.setInitialMaxData(Long.valueOf(quicConfiguration.getSessionRecvWindow()));
            quicheConfig.setInitialMaxStreamDataBidiLocal(Long.valueOf(quicConfiguration.getBidirectionalStreamRecvWindow()));
            quicheConfig.setInitialMaxStreamDataBidiRemote(Long.valueOf(quicConfiguration.getBidirectionalStreamRecvWindow()));
            quicheConfig.setInitialMaxStreamDataUni(Long.valueOf(quicConfiguration.getUnidirectionalStreamRecvWindow()));
            quicheConfig.setInitialMaxStreamsUni(Long.valueOf(quicConfiguration.getMaxUnidirectionalRemoteStreams()));
            quicheConfig.setInitialMaxStreamsBidi(Long.valueOf(quicConfiguration.getMaxBidirectionalRemoteStreams()));
            quicheConfig.setCongestionControl(QuicheConfig.CongestionControl.CUBIC);
            InetSocketAddress remoteAddress = (InetSocketAddress)this.context.get("org.eclipse.jetty.client.connector.remoteSocketAddress");
            if (LOG.isDebugEnabled()) {
                LOG.debug("connecting to {} with protocols {}", (Object)remoteAddress, (Object)protocols);
            }
            QuicheConnection quicheConnection = QuicheConnection.connect((QuicheConfig)quicheConfig, (InetSocketAddress)this.getEndPoint().getLocalAddress(), (InetSocketAddress)remoteAddress);
            ClientQuicSession session = new ClientQuicSession(this.getExecutor(), this.getScheduler(), this.getByteBufferPool(), quicheConnection, this, remoteAddress, this.context);
            this.pendingSessions.put(remoteAddress, session);
            if (LOG.isDebugEnabled()) {
                LOG.debug("created {}", (Object)session);
            }
            this.connectTask = this.getScheduler().schedule(() -> this.connectTimeout(remoteAddress), this.connector.getConnectTimeout().toMillis(), TimeUnit.MILLISECONDS);
            session.flush();
            this.fillInterested();
        }
        catch (IOException x) {
            throw new RuntimeIOException((Throwable)x);
        }
    }

    public void onFillable() {
        this.connectTask.cancel();
        super.onFillable();
    }

    private void connectTimeout(SocketAddress remoteAddress) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("connect timeout {} ms to {} on {}", new Object[]{this.connector.getConnectTimeout(), remoteAddress, this});
        }
        this.close();
        this.outwardClose(remoteAddress, (Throwable)new SocketTimeoutException("connect timeout"));
    }

    protected QuicSession createSession(SocketAddress remoteAddress, ByteBuffer cipherBuffer) throws IOException {
        ClientQuicSession session = this.pendingSessions.get(remoteAddress);
        if (session != null) {
            Runnable task = session.process(remoteAddress, cipherBuffer);
            session.offerTask(task);
            if (session.isConnectionEstablished()) {
                this.pendingSessions.remove(remoteAddress);
                return session;
            }
        }
        return null;
    }

    protected void onFailure(Throwable failure) {
        this.pendingSessions.values().forEach(session -> this.outwardClose((QuicSession)session, failure));
        super.onFailure(failure);
    }

    public boolean onIdleExpired(TimeoutException timeoutException) {
        boolean idle = this.isFillInterested();
        long idleTimeout = this.getEndPoint().getIdleTimeout();
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} elapsed idle timeout {} ms", (Object)(idle ? "processing" : "ignoring"), (Object)idleTimeout);
        }
        if (idle) {
            Collection sessions = this.getQuicSessions();
            sessions.forEach(QuicSession::onIdleTimeout);
        }
        return false;
    }

    public void outwardClose(QuicSession session, Throwable failure) {
        super.outwardClose(session, failure);
        SocketAddress remoteAddress = session.getRemoteAddress();
        this.outwardClose(remoteAddress, failure);
    }

    private void outwardClose(SocketAddress remoteAddress, Throwable failure) {
        Promise promise;
        if (remoteAddress != null && this.pendingSessions.remove(remoteAddress) != null && (promise = (Promise)this.context.get("org.eclipse.jetty.client.connector.connectionPromise")) != null) {
            promise.failed(failure);
        }
        this.getEndPoint().close(failure);
    }
}

