/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.client;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.Transport;
import org.eclipse.jetty.quic.client.ClientQuicConfiguration;
import org.eclipse.jetty.quic.client.ClientQuicConnection;
import org.eclipse.jetty.quic.common.QuicConfiguration;

public class QuicTransport
extends Transport.Wrapper {
    private final ClientQuicConfiguration quicConfiguration;

    public QuicTransport(ClientQuicConfiguration quicConfiguration) {
        this(UDP_IP, quicConfiguration);
    }

    public QuicTransport(Transport wrapped, ClientQuicConfiguration quicConfiguration) {
        super(wrapped);
        this.quicConfiguration = quicConfiguration;
    }

    public boolean isIntrinsicallySecure() {
        return true;
    }

    public Connection newConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
        context.put(QuicConfiguration.CONTEXT_KEY, (Object)this.quicConfiguration);
        ClientConnector clientConnector = (ClientConnector)context.get("org.eclipse.jetty.client.connector");
        ClientQuicConnection connection = new ClientQuicConnection(clientConnector, endPoint, context);
        connection.setInputBufferSize(this.quicConfiguration.getInputBufferSize());
        connection.setOutputBufferSize(this.quicConfiguration.getOutputBufferSize());
        connection.setUseInputDirectByteBuffers(this.quicConfiguration.isUseInputDirectByteBuffers());
        connection.setUseOutputDirectByteBuffers(this.quicConfiguration.isUseOutputDirectByteBuffers());
        this.quicConfiguration.getEventListeners().forEach(arg_0 -> ((ClientQuicConnection)connection).addEventListener(arg_0));
        return connection;
    }

    public int hashCode() {
        return this.getWrapped().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof QuicTransport) {
            QuicTransport that = (QuicTransport)((Object)obj);
            return Objects.equals(this.getWrapped(), that.getWrapped());
        }
        return false;
    }
}

