/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpTester;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.StatisticsServlet;
import org.eclipse.jetty.util.ajax.JSON;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class StatisticsServletTest {
    private Server _server;
    private LocalConnector _connector;

    @BeforeEach
    public void createServer() {
        this._server = new Server();
        this._connector = new LocalConnector(this._server);
        this._server.addConnector((Connector)this._connector);
    }

    @AfterEach
    public void destroyServer() throws Exception {
        this._server.stop();
        this._server.join();
    }

    private void addStatisticsHandler() {
        StatisticsHandler statsHandler = new StatisticsHandler();
        this._server.setHandler((Handler)statsHandler);
        ServletContextHandler statsContext = new ServletContextHandler((HandlerContainer)statsHandler, "/");
        statsContext.addServlet(new ServletHolder((Servlet)new TestServlet()), "/test1");
        ServletHolder servletHolder = new ServletHolder((Servlet)new StatisticsServlet());
        servletHolder.setInitParameter("restrictToLocalhost", "false");
        statsContext.addServlet(servletHolder, "/stats");
        statsContext.setSessionHandler(new SessionHandler());
    }

    @Test
    public void testGetStats() throws Exception {
        this.addStatisticsHandler();
        this._server.start();
        HttpTester.Response response = this.getResponse("/test1");
        Assertions.assertEquals((int)response.getStatus(), (int)200);
        response = this.getResponse("/stats");
        Assertions.assertEquals((int)response.getStatus(), (int)200);
        Stats stats = this.parseStats(response.getContent());
        Assertions.assertEquals((int)1, (int)stats.responses2xx);
        response = this.getResponse("/stats?statsReset=true");
        Assertions.assertEquals((int)response.getStatus(), (int)200);
        response = this.getResponse("/stats");
        Assertions.assertEquals((int)response.getStatus(), (int)200);
        stats = this.parseStats(response.getContent());
        Assertions.assertEquals((int)1, (int)stats.responses2xx);
        response = this.getResponse("/test1");
        Assertions.assertEquals((int)response.getStatus(), (int)200);
        response = this.getResponse("/nothing");
        Assertions.assertEquals((int)response.getStatus(), (int)404);
        response = this.getResponse("/stats");
        Assertions.assertEquals((int)response.getStatus(), (int)200);
        stats = this.parseStats(response.getContent());
        MatcherAssert.assertThat((String)("2XX Response Count" + response), (Object)stats.responses2xx, (Matcher)Matchers.is((Object)3));
        MatcherAssert.assertThat((String)("4XX Response Count" + response), (Object)stats.responses4xx, (Matcher)Matchers.is((Object)1));
    }

    public static Stream<Arguments> typeVariations(final String mimeType) {
        return Stream.of(Arguments.of((Object[])new Object[]{new Consumer<HttpTester.Request>(){

            @Override
            public void accept(HttpTester.Request request) {
                request.setURI("/stats");
                request.setHeader("Accept", mimeType);
            }

            public String toString() {
                return "Header[Accept: " + mimeType + "]";
            }
        }}), Arguments.of((Object[])new Object[]{new Consumer<HttpTester.Request>(){

            @Override
            public void accept(HttpTester.Request request) {
                request.setURI("/stats?accept=" + mimeType);
            }

            public String toString() {
                return "query[accept=" + mimeType + "]";
            }
        }}));
    }

    public static Stream<Arguments> xmlVariations() {
        return StatisticsServletTest.typeVariations("text/xml");
    }

    @ParameterizedTest(name="[{index}] {0}")
    @MethodSource(value={"xmlVariations"})
    public void testGetXmlResponse(Consumer<HttpTester.Request> requestCustomizer) throws Exception {
        this.addStatisticsHandler();
        this._server.start();
        HttpTester.Request request = new HttpTester.Request();
        request.setMethod("GET");
        request.setVersion(HttpVersion.HTTP_1_1);
        request.setHeader("Host", "test");
        requestCustomizer.accept(request);
        ByteBuffer responseBuffer = this._connector.getResponse(request.generate());
        HttpTester.Response response = HttpTester.parseResponse((ByteBuffer)responseBuffer);
        MatcherAssert.assertThat((String)"Response.contentType", (Object)response.get(HttpHeader.CONTENT_TYPE), (Matcher)Matchers.containsString((String)"text/xml"));
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setValidating(false);
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        try (ByteArrayInputStream input = new ByteArrayInputStream(response.getContentBytes());){
            Document doc = docBuilder.parse(input);
            Assertions.assertNotNull((Object)doc);
            Assertions.assertEquals((Object)"statistics", (Object)doc.getDocumentElement().getNodeName());
        }
    }

    public static Stream<Arguments> jsonVariations() {
        return StatisticsServletTest.typeVariations("application/json");
    }

    @ParameterizedTest(name="[{index}] {0}")
    @MethodSource(value={"jsonVariations"})
    public void testGetJsonResponse(Consumer<HttpTester.Request> requestCustomizer) throws Exception {
        this.addStatisticsHandler();
        this._server.start();
        HttpTester.Request request = new HttpTester.Request();
        request.setMethod("GET");
        requestCustomizer.accept(request);
        request.setVersion(HttpVersion.HTTP_1_1);
        request.setHeader("Host", "test");
        ByteBuffer responseBuffer = this._connector.getResponse(request.generate());
        HttpTester.Response response = HttpTester.parseResponse((ByteBuffer)responseBuffer);
        MatcherAssert.assertThat((String)"Response.contentType", (Object)response.get(HttpHeader.CONTENT_TYPE), (Matcher)Matchers.is((Object)"application/json"));
        MatcherAssert.assertThat((String)"Response.contentType for json should never contain a charset", (Object)response.get(HttpHeader.CONTENT_TYPE), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"charset")));
        Object doc = JSON.parse((String)response.getContent());
        Assertions.assertNotNull((Object)doc);
        MatcherAssert.assertThat((Object)doc, (Matcher)Matchers.instanceOf(Map.class));
        Map docMap = (Map)doc;
        Assertions.assertEquals((int)4, (int)docMap.size());
        Assertions.assertNotNull(docMap.get("requests"));
        Assertions.assertNotNull(docMap.get("responses"));
        Assertions.assertNotNull(docMap.get("connections"));
        Assertions.assertNotNull(docMap.get("memory"));
    }

    public static Stream<Arguments> plaintextVariations() {
        return StatisticsServletTest.typeVariations("text/plain");
    }

    @ParameterizedTest(name="[{index}] {0}")
    @MethodSource(value={"plaintextVariations"})
    public void testGetTextResponse(Consumer<HttpTester.Request> requestCustomizer) throws Exception {
        this.addStatisticsHandler();
        this._server.start();
        HttpTester.Request request = new HttpTester.Request();
        request.setMethod("GET");
        requestCustomizer.accept(request);
        request.setVersion(HttpVersion.HTTP_1_1);
        request.setHeader("Host", "test");
        ByteBuffer responseBuffer = this._connector.getResponse(request.generate());
        HttpTester.Response response = HttpTester.parseResponse((ByteBuffer)responseBuffer);
        MatcherAssert.assertThat((String)"Response.contentType", (Object)response.get(HttpHeader.CONTENT_TYPE), (Matcher)Matchers.containsString((String)"text/plain"));
        MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.containsString((String)"requests: "));
        MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.containsString((String)"responses: "));
        MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.containsString((String)"connections: "));
        MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.containsString((String)"memory: "));
    }

    public static Stream<Arguments> htmlVariations() {
        return StatisticsServletTest.typeVariations("text/html");
    }

    @ParameterizedTest(name="[{index}] {0}")
    @MethodSource(value={"htmlVariations"})
    public void testGetHtmlResponse(Consumer<HttpTester.Request> requestCustomizer) throws Exception {
        this.addStatisticsHandler();
        this._server.start();
        HttpTester.Request request = new HttpTester.Request();
        request.setMethod("GET");
        requestCustomizer.accept(request);
        request.setVersion(HttpVersion.HTTP_1_1);
        request.setHeader("Host", "test");
        ByteBuffer responseBuffer = this._connector.getResponse(request.generate());
        HttpTester.Response response = HttpTester.parseResponse((ByteBuffer)responseBuffer);
        MatcherAssert.assertThat((String)"Response.contentType", (Object)response.get(HttpHeader.CONTENT_TYPE), (Matcher)Matchers.containsString((String)"text/html"));
        MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.containsString((String)"<html>"));
        MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.containsString((String)"<body>"));
        MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.containsString((String)"<em>requests</em>: "));
        MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.containsString((String)"<em>responses</em>: "));
        MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.containsString((String)"<em>connections</em>: "));
        MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.containsString((String)"<em>memory</em>: "));
        MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.containsString((String)"</body>"));
        MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.containsString((String)"</html>"));
    }

    public HttpTester.Response getResponse(String path) throws Exception {
        HttpTester.Request request = new HttpTester.Request();
        request.setMethod("GET");
        request.setHeader("Accept", "text/xml");
        request.setURI(path);
        request.setVersion(HttpVersion.HTTP_1_1);
        request.setHeader("Host", "test");
        ByteBuffer responseBuffer = this._connector.getResponse(request.generate());
        return HttpTester.parseResponse((ByteBuffer)responseBuffer);
    }

    public Stats parseStats(String xml) throws Exception {
        XPath xPath = XPathFactory.newInstance().newXPath();
        String responses4xx = xPath.evaluate("//responses4xx", new InputSource(new StringReader(xml)));
        String responses2xx = xPath.evaluate("//responses2xx", new InputSource(new StringReader(xml)));
        return new Stats(Integer.parseInt(responses2xx), Integer.parseInt(responses4xx));
    }

    public static class TestServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            resp.setStatus(200);
            PrintWriter writer = resp.getWriter();
            writer.write("Yup!!");
        }
    }

    public static class Stats {
        int responses2xx;
        int responses4xx;

        public Stats(int responses2xx, int responses4xx) {
            this.responses2xx = responses2xx;
            this.responses4xx = responses4xx;
        }
    }
}

