/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.util.Collections;
import java.util.Set;
import javax.servlet.ServletRegistration;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.servlet.BaseHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.Source;
import org.eclipse.jetty.util.MultiException;
import org.eclipse.jetty.util.log.StacklessLogging;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ServletHolderTest {
    @Test
    public void testInitParams() throws Exception {
        ServletHolder holder = new ServletHolder(Source.JAVAX_API);
        ServletRegistration.Dynamic reg = holder.getRegistration();
        Assertions.assertThrows(IllegalArgumentException.class, () -> ServletHolderTest.lambda$testInitParams$0((ServletRegistration)reg));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ServletHolderTest.lambda$testInitParams$1((ServletRegistration)reg));
        reg.setInitParameter("foo", "bar");
        Assertions.assertFalse((boolean)reg.setInitParameter("foo", "foo"));
        Set clash = reg.setInitParameters(Collections.singletonMap("foo", "bax"));
        Assertions.assertTrue((clash != null && clash.size() == 1 ? 1 : 0) != 0, (String)"should be one clash");
        Assertions.assertThrows(IllegalArgumentException.class, () -> ServletHolderTest.lambda$testInitParams$2((ServletRegistration)reg));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ServletHolderTest.lambda$testInitParams$3((ServletRegistration)reg));
        Set clash2 = reg.setInitParameters(Collections.singletonMap("FOO", "bax"));
        Assertions.assertTrue((boolean)clash2.isEmpty(), (String)"should be no clash");
        Assertions.assertEquals((int)2, (int)reg.getInitParameters().size(), (String)"setInitParameters should not replace existing non-clashing init parameters");
    }

    @Test
    public void testTransitiveCompareTo() throws Exception {
        ServletHolder one = new ServletHolder();
        one.setInitOrder(-1);
        one.setName("Login");
        one.setClassName(null);
        ServletHolder two = new ServletHolder();
        two.setInitOrder(-1);
        two.setName("org.my.package.jsp.WEB_002dINF.pages.precompiled_002dpage_jsp");
        two.setClassName("org.my.package.jsp.WEB_002dINF.pages.precompiled_002dpage_jsp");
        ServletHolder three = new ServletHolder();
        three.setInitOrder(-1);
        three.setName("Download");
        three.setClassName("org.my.package.web.DownloadServlet");
        Assertions.assertTrue((one.compareTo(two) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((two.compareTo(three) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((one.compareTo(three) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testJspFileNameToClassName() throws Exception {
        ServletHolder h = new ServletHolder();
        h.setName("test");
        Assertions.assertNull((Object)h.getClassNameForJsp(null));
        Assertions.assertNull((Object)h.getClassNameForJsp(""));
        Assertions.assertNull((Object)h.getClassNameForJsp("/blah/"));
        Assertions.assertNull((Object)h.getClassNameForJsp("//blah///"));
        Assertions.assertNull((Object)h.getClassNameForJsp("/a/b/c/blah/"));
        Assertions.assertEquals((Object)"org.apache.jsp.a.b.c.blah", (Object)h.getClassNameForJsp("/a/b/c/blah"));
        Assertions.assertEquals((Object)"org.apache.jsp.blah_jsp", (Object)h.getClassNameForJsp("/blah.jsp"));
        Assertions.assertEquals((Object)"org.apache.jsp.blah_jsp", (Object)h.getClassNameForJsp("//blah.jsp"));
        Assertions.assertEquals((Object)"org.apache.jsp.blah_jsp", (Object)h.getClassNameForJsp("blah.jsp"));
        Assertions.assertEquals((Object)"org.apache.jsp.a.b.c.blah_jsp", (Object)h.getClassNameForJsp("/a/b/c/blah.jsp"));
        Assertions.assertEquals((Object)"org.apache.jsp.a.b.c.blah_jsp", (Object)h.getClassNameForJsp("a/b/c/blah.jsp"));
    }

    @Test
    public void testNoClassName() throws Exception {
        try (StacklessLogging ignore = new StacklessLogging(new Class[]{ServletHandler.class, ContextHandler.class, ServletContextHandler.class});){
            ServletContextHandler context = new ServletContextHandler();
            ServletHandler handler = context.getServletHandler();
            ServletHolder holder = new ServletHolder();
            holder.setName("foo");
            holder.setForcedPath("/blah/");
            handler.addServlet(holder);
            handler.start();
            Assertions.fail((String)"No class in ServletHolder");
        }
        catch (UnavailableException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"foo"));
        }
        catch (MultiException e) {
            MatcherAssert.assertThat((Object)e.getCause().getMessage(), (Matcher)Matchers.containsString((String)"foo"));
        }
    }

    @Test
    public void testWithClass() throws Exception {
        try (StacklessLogging stackless = new StacklessLogging(new Class[]{BaseHolder.class, ServletHandler.class, ContextHandler.class, ServletContextHandler.class});){
            ServletContextHandler context = new ServletContextHandler();
            ServletHandler handler = context.getServletHandler();
            ServletHolder holder = new ServletHolder();
            holder.setName("foo");
            holder.setHeldClass(FakeServlet.class);
            handler.addServlet(holder);
            handler.start();
            Assertions.assertTrue((boolean)holder.isAvailable());
            Assertions.assertTrue((boolean)holder.isStarted());
        }
    }

    @Test
    public void testWithClassName() throws Exception {
        try (StacklessLogging stackless = new StacklessLogging(new Class[]{BaseHolder.class, ServletHandler.class, ContextHandler.class, ServletContextHandler.class});){
            ServletContextHandler context = new ServletContextHandler();
            ServletHandler handler = context.getServletHandler();
            ServletHolder holder = new ServletHolder();
            holder.setName("foo");
            holder.setClassName("org.eclipse.jetty.servlet.ServletHolderTest$FakeServlet");
            handler.addServlet(holder);
            handler.start();
            Assertions.assertTrue((boolean)holder.isAvailable());
            Assertions.assertTrue((boolean)holder.isStarted());
        }
    }

    @Test
    public void testUnloadableClassName() throws Exception {
        try (StacklessLogging stackless = new StacklessLogging(new Class[]{BaseHolder.class, ServletHandler.class, ContextHandler.class, ServletContextHandler.class});){
            ServletContextHandler context = new ServletContextHandler();
            ServletHandler handler = context.getServletHandler();
            ServletHolder holder = new ServletHolder();
            holder.setName("foo");
            holder.setClassName("a.b.c.class");
            handler.addServlet(holder);
            handler.start();
            Assertions.fail((String)"Unloadable class");
        }
        catch (UnavailableException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"foo"));
        }
        catch (MultiException e) {
            MatcherAssert.assertThat((Object)e.getCause().getMessage(), (Matcher)Matchers.containsString((String)"foo"));
        }
    }

    private static /* synthetic */ void lambda$testInitParams$3(ServletRegistration reg) throws Throwable {
        reg.setInitParameters(Collections.singletonMap("foo", null));
    }

    private static /* synthetic */ void lambda$testInitParams$2(ServletRegistration reg) throws Throwable {
        reg.setInitParameters(Collections.singletonMap(null, "bax"));
    }

    private static /* synthetic */ void lambda$testInitParams$1(ServletRegistration reg) throws Throwable {
        reg.setInitParameter("foo", null);
    }

    private static /* synthetic */ void lambda$testInitParams$0(ServletRegistration reg) throws Throwable {
        reg.setInitParameter(null, "foo");
    }

    public static class FakeServlet
    extends HttpServlet {
    }
}

