/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.util.Collections;
import java.util.Set;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.server.session.DefaultSessionIdManager;
import org.eclipse.jetty.server.session.HouseKeeper;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.util.thread.Scheduler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class HouseKeeperTest {
    @Test
    public void testHouseKeeper() throws Exception {
        TestHouseKeeper t = new TestHouseKeeper();
        Assertions.assertThrows(IllegalStateException.class, () -> t.start());
        TestHouseKeeper hk = new TestHouseKeeper();
        hk.setSessionIdManager((SessionIdManager)new TestSessionIdManager(new Server()));
        hk.setIntervalSec(-1L);
        hk.start();
        Assertions.assertNull((Object)hk.getRunner());
        Assertions.assertNull((Object)hk.getTask());
        Assertions.assertNull((Object)hk.getScheduler());
        Assertions.assertFalse((boolean)hk.isOwnScheduler());
        hk.stop();
        Assertions.assertNull((Object)hk.getRunner());
        Assertions.assertNull((Object)hk.getTask());
        Assertions.assertNull((Object)hk.getScheduler());
        Assertions.assertFalse((boolean)hk.isOwnScheduler());
        hk.setIntervalSec(10000L);
        Assertions.assertNull((Object)hk.getRunner());
        Assertions.assertNull((Object)hk.getTask());
        Assertions.assertNull((Object)hk.getScheduler());
        Assertions.assertFalse((boolean)hk.isOwnScheduler());
        hk.start();
        Assertions.assertNotNull((Object)hk.getRunner());
        Assertions.assertNotNull((Object)hk.getTask());
        Assertions.assertNotNull((Object)hk.getScheduler());
        Assertions.assertTrue((boolean)hk.isOwnScheduler());
        hk.stop();
        Assertions.assertNull((Object)hk.getRunner());
        Assertions.assertNull((Object)hk.getTask());
        Assertions.assertNull((Object)hk.getScheduler());
        Assertions.assertFalse((boolean)hk.isOwnScheduler());
        hk.start();
        Scheduler.Task oldTask = hk.getTask();
        hk.setIntervalSec(50000L);
        Assertions.assertTrue((hk.getIntervalSec() >= 50000L ? 1 : 0) != 0);
        Assertions.assertNotNull((Object)hk.getRunner());
        Assertions.assertNotNull((Object)hk.getTask());
        Assertions.assertNotSame((Object)oldTask, (Object)hk.getTask());
        Assertions.assertNotNull((Object)hk.getScheduler());
        Assertions.assertTrue((boolean)hk.isOwnScheduler());
    }

    public class TestSessionIdManager
    extends DefaultSessionIdManager {
        public TestSessionIdManager(Server server) {
            super(server);
        }

        public Set<SessionHandler> getSessionHandlers() {
            return Collections.singleton(new SessionHandler());
        }
    }

    public class TestHouseKeeper
    extends HouseKeeper {
        public Scheduler getScheduler() {
            return this._scheduler;
        }

        public Scheduler.Task getTask() {
            return this._task;
        }

        public HouseKeeper.Runner getRunner() {
            return this._runner;
        }

        public boolean isOwnScheduler() {
            return this._ownScheduler;
        }
    }
}

