/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class HandlerTest {
    @Test
    public void testWrapperSetServer() {
        Server s = new Server();
        HandlerWrapper a = new HandlerWrapper();
        HandlerWrapper b = new HandlerWrapper();
        HandlerWrapper c = new HandlerWrapper();
        a.setHandler((Handler)b);
        b.setHandler((Handler)c);
        a.setServer(s);
        MatcherAssert.assertThat((Object)b.getServer(), (Matcher)Matchers.equalTo((Object)s));
        MatcherAssert.assertThat((Object)c.getServer(), (Matcher)Matchers.equalTo((Object)s));
    }

    @Test
    public void testWrapperServerSet() {
        Server s = new Server();
        HandlerWrapper a = new HandlerWrapper();
        HandlerWrapper b = new HandlerWrapper();
        HandlerWrapper c = new HandlerWrapper();
        a.setServer(s);
        b.setHandler((Handler)c);
        a.setHandler((Handler)b);
        MatcherAssert.assertThat((Object)b.getServer(), (Matcher)Matchers.equalTo((Object)s));
        MatcherAssert.assertThat((Object)c.getServer(), (Matcher)Matchers.equalTo((Object)s));
    }

    @Test
    public void testWrapperThisLoop() {
        HandlerWrapper a = new HandlerWrapper();
        IllegalStateException e = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> a.setHandler((Handler)a));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"loop"));
    }

    @Test
    public void testWrapperSimpleLoop() {
        HandlerWrapper a = new HandlerWrapper();
        HandlerWrapper b = new HandlerWrapper();
        a.setHandler((Handler)b);
        IllegalStateException e = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> b.setHandler((Handler)a));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"loop"));
    }

    @Test
    public void testWrapperDeepLoop() {
        HandlerWrapper a = new HandlerWrapper();
        HandlerWrapper b = new HandlerWrapper();
        HandlerWrapper c = new HandlerWrapper();
        a.setHandler((Handler)b);
        b.setHandler((Handler)c);
        IllegalStateException e = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> c.setHandler((Handler)a));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"loop"));
    }

    @Test
    public void testWrapperChainLoop() {
        HandlerWrapper a = new HandlerWrapper();
        HandlerWrapper b = new HandlerWrapper();
        HandlerWrapper c = new HandlerWrapper();
        a.setHandler((Handler)b);
        c.setHandler((Handler)a);
        IllegalStateException e = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> b.setHandler((Handler)c));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"loop"));
    }

    @Test
    public void testCollectionSetServer() {
        Server s = new Server();
        HandlerCollection a = new HandlerCollection();
        HandlerCollection b = new HandlerCollection();
        HandlerCollection b1 = new HandlerCollection();
        HandlerCollection b2 = new HandlerCollection();
        HandlerCollection c = new HandlerCollection();
        HandlerCollection c1 = new HandlerCollection();
        HandlerCollection c2 = new HandlerCollection();
        a.addHandler((Handler)b);
        a.addHandler((Handler)c);
        b.setHandlers(new Handler[]{b1, b2});
        c.setHandlers(new Handler[]{c1, c2});
        a.setServer(s);
        MatcherAssert.assertThat((Object)b.getServer(), (Matcher)Matchers.equalTo((Object)s));
        MatcherAssert.assertThat((Object)c.getServer(), (Matcher)Matchers.equalTo((Object)s));
        MatcherAssert.assertThat((Object)b1.getServer(), (Matcher)Matchers.equalTo((Object)s));
        MatcherAssert.assertThat((Object)b2.getServer(), (Matcher)Matchers.equalTo((Object)s));
        MatcherAssert.assertThat((Object)c1.getServer(), (Matcher)Matchers.equalTo((Object)s));
        MatcherAssert.assertThat((Object)c2.getServer(), (Matcher)Matchers.equalTo((Object)s));
    }

    @Test
    public void testCollectionServerSet() {
        Server s = new Server();
        HandlerCollection a = new HandlerCollection();
        HandlerCollection b = new HandlerCollection();
        HandlerCollection b1 = new HandlerCollection();
        HandlerCollection b2 = new HandlerCollection();
        HandlerCollection c = new HandlerCollection();
        HandlerCollection c1 = new HandlerCollection();
        HandlerCollection c2 = new HandlerCollection();
        a.setServer(s);
        a.addHandler((Handler)b);
        a.addHandler((Handler)c);
        b.setHandlers(new Handler[]{b1, b2});
        c.setHandlers(new Handler[]{c1, c2});
        MatcherAssert.assertThat((Object)b.getServer(), (Matcher)Matchers.equalTo((Object)s));
        MatcherAssert.assertThat((Object)c.getServer(), (Matcher)Matchers.equalTo((Object)s));
        MatcherAssert.assertThat((Object)b1.getServer(), (Matcher)Matchers.equalTo((Object)s));
        MatcherAssert.assertThat((Object)b2.getServer(), (Matcher)Matchers.equalTo((Object)s));
        MatcherAssert.assertThat((Object)c1.getServer(), (Matcher)Matchers.equalTo((Object)s));
        MatcherAssert.assertThat((Object)c2.getServer(), (Matcher)Matchers.equalTo((Object)s));
    }

    @Test
    public void testCollectionThisLoop() {
        HandlerCollection a = new HandlerCollection();
        IllegalStateException e = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> a.addHandler((Handler)a));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"loop"));
    }

    @Test
    public void testCollectionDeepLoop() {
        HandlerCollection a = new HandlerCollection();
        HandlerCollection b = new HandlerCollection();
        HandlerCollection b1 = new HandlerCollection();
        HandlerCollection b2 = new HandlerCollection();
        HandlerCollection c = new HandlerCollection();
        HandlerCollection c1 = new HandlerCollection();
        HandlerCollection c2 = new HandlerCollection();
        a.addHandler((Handler)b);
        a.addHandler((Handler)c);
        b.setHandlers(new Handler[]{b1, b2});
        c.setHandlers(new Handler[]{c1, c2});
        IllegalStateException e = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> b2.addHandler((Handler)a));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"loop"));
    }

    @Test
    public void testCollectionChainLoop() {
        HandlerCollection a = new HandlerCollection();
        HandlerCollection b = new HandlerCollection();
        HandlerCollection b1 = new HandlerCollection();
        HandlerCollection b2 = new HandlerCollection();
        HandlerCollection c = new HandlerCollection();
        HandlerCollection c1 = new HandlerCollection();
        HandlerCollection c2 = new HandlerCollection();
        a.addHandler((Handler)c);
        b.setHandlers(new Handler[]{b1, b2});
        c.setHandlers(new Handler[]{c1, c2});
        b2.addHandler((Handler)a);
        IllegalStateException e = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> a.addHandler((Handler)b));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"loop"));
    }

    @Test
    public void testInsertWrapperTail() {
        HandlerWrapper a = new HandlerWrapper();
        HandlerWrapper b = new HandlerWrapper();
        a.insertHandler(b);
        MatcherAssert.assertThat((Object)a.getHandler(), (Matcher)Matchers.equalTo((Object)b));
        MatcherAssert.assertThat((Object)b.getHandler(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testInsertWrapper() {
        HandlerWrapper a = new HandlerWrapper();
        HandlerWrapper b = new HandlerWrapper();
        HandlerWrapper c = new HandlerWrapper();
        a.insertHandler(c);
        a.insertHandler(b);
        MatcherAssert.assertThat((Object)a.getHandler(), (Matcher)Matchers.equalTo((Object)b));
        MatcherAssert.assertThat((Object)b.getHandler(), (Matcher)Matchers.equalTo((Object)c));
        MatcherAssert.assertThat((Object)c.getHandler(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testInsertWrapperChain() {
        HandlerWrapper a = new HandlerWrapper();
        HandlerWrapper b = new HandlerWrapper();
        HandlerWrapper c = new HandlerWrapper();
        HandlerWrapper d = new HandlerWrapper();
        a.insertHandler(d);
        b.insertHandler(c);
        a.insertHandler(b);
        MatcherAssert.assertThat((Object)a.getHandler(), (Matcher)Matchers.equalTo((Object)b));
        MatcherAssert.assertThat((Object)b.getHandler(), (Matcher)Matchers.equalTo((Object)c));
        MatcherAssert.assertThat((Object)c.getHandler(), (Matcher)Matchers.equalTo((Object)d));
        MatcherAssert.assertThat((Object)d.getHandler(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testInsertWrapperBadChain() {
        HandlerWrapper a = new HandlerWrapper();
        HandlerWrapper b = new HandlerWrapper();
        HandlerWrapper c = new HandlerWrapper();
        HandlerWrapper d = new HandlerWrapper();
        a.insertHandler(d);
        b.insertHandler(c);
        c.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            }
        });
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> a.insertHandler(b));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"bad tail"));
    }
}

