/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.ProxyConnectionFactory;
import org.eclipse.jetty.server.ProxyCustomizer;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.util.TypeUtil;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ProxyCustomizerTest {
    private Server server;

    private ProxyResponse sendProxyRequest(String proxyAsHexString, String rawHttp) throws IOException {
        try (Socket socket = new Socket(this.server.getURI().getHost(), this.server.getURI().getPort());){
            String line;
            OutputStream output = socket.getOutputStream();
            output.write(TypeUtil.fromHexString((String)proxyAsHexString));
            output.write(rawHttp.getBytes(StandardCharsets.UTF_8));
            output.flush();
            socket.shutdownOutput();
            StringBuilder sb = new StringBuilder();
            InputStream input = socket.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\r\n");
            }
            ProxyResponse proxyResponse = new ProxyResponse((InetSocketAddress)socket.getLocalSocketAddress(), (InetSocketAddress)socket.getRemoteSocketAddress(), sb.toString());
            return proxyResponse;
        }
    }

    @BeforeEach
    void setUp() throws Exception {
        AbstractHandler handler = new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) {
                Object remoteAddress;
                response.addHeader("preexisting.attribute", request.getAttribute("some.attribute").toString());
                ArrayList attributeNames = Collections.list(request.getAttributeNames());
                Collections.sort(attributeNames);
                response.addHeader("attributeNames", String.join((CharSequence)",", attributeNames));
                response.addHeader("localAddress", request.getLocalAddr() + ":" + request.getLocalPort());
                response.addHeader("remoteAddress", request.getRemoteAddr() + ":" + request.getRemotePort());
                Object localAddress = request.getAttribute("org.eclipse.jetty.proxy.local.address");
                if (localAddress != null) {
                    response.addHeader("proxyLocalAddress", localAddress.toString() + ":" + request.getAttribute("org.eclipse.jetty.proxy.local.port"));
                }
                if ((remoteAddress = request.getAttribute("org.eclipse.jetty.proxy.remote.address")) != null) {
                    response.addHeader("proxyRemoteAddress", remoteAddress.toString() + ":" + request.getAttribute("org.eclipse.jetty.proxy.remote.port"));
                }
                baseRequest.setHandled(true);
            }
        };
        this.server = new Server();
        HttpConfiguration httpConfiguration = new HttpConfiguration();
        httpConfiguration.addCustomizer((connector, channelConfig, request) -> request.setAttribute("some.attribute", (Object)"some value"));
        httpConfiguration.addCustomizer((HttpConfiguration.Customizer)new ProxyCustomizer());
        ServerConnector connector2 = new ServerConnector(this.server, new ConnectionFactory[]{new ProxyConnectionFactory(), new HttpConnectionFactory(httpConfiguration)});
        this.server.addConnector((Connector)connector2);
        this.server.setHandler((Handler)handler);
        this.server.start();
    }

    @AfterEach
    void tearDown() throws Exception {
        this.server.stop();
        this.server = null;
    }

    @Test
    public void testProxyCustomizerWithProxyData() throws Exception {
        String proxy = "0D0A0D0A000D0A515549540A2111000C01010001010100FE30391F90";
        String http = "GET /1 HTTP/1.1\r\nHost: localhost\r\n\r\n";
        ProxyResponse response = this.sendProxyRequest(proxy, http);
        MatcherAssert.assertThat((Object)response.httpResponse, (Matcher)Matchers.containsString((String)"localAddress: 1.1.0.254:8080"));
        MatcherAssert.assertThat((Object)response.httpResponse, (Matcher)Matchers.containsString((String)"remoteAddress: 1.1.0.1:12345"));
        MatcherAssert.assertThat((Object)response.httpResponse, (Matcher)Matchers.containsString((String)("proxyLocalAddress: " + response.remoteSocketAddress.getAddress().getHostAddress() + ":" + response.remoteSocketAddress.getPort())));
        MatcherAssert.assertThat((Object)response.httpResponse, (Matcher)Matchers.containsString((String)("proxyRemoteAddress: " + response.localSocketAddress.getAddress().getHostAddress() + ":" + response.localSocketAddress.getPort())));
        MatcherAssert.assertThat((Object)response.httpResponse, (Matcher)Matchers.containsString((String)"preexisting.attribute: some value"));
        MatcherAssert.assertThat((Object)response.httpResponse, (Matcher)Matchers.containsString((String)"attributeNames: org.eclipse.jetty.proxy.local.address,org.eclipse.jetty.proxy.local.port,org.eclipse.jetty.proxy.remote.address,org.eclipse.jetty.proxy.remote.port,some.attribute"));
    }

    @Test
    public void testProxyCustomizerWithoutProxyData() throws Exception {
        String proxy = "";
        String http = "GET /1 HTTP/1.1\r\nHost: localhost\r\n\r\n";
        ProxyResponse response = this.sendProxyRequest(proxy, http);
        MatcherAssert.assertThat((Object)response.httpResponse, (Matcher)Matchers.containsString((String)("localAddress: " + response.remoteSocketAddress.getAddress().getHostAddress() + ":" + response.remoteSocketAddress.getPort())));
        MatcherAssert.assertThat((Object)response.httpResponse, (Matcher)Matchers.containsString((String)("remoteAddress: " + response.localSocketAddress.getAddress().getHostAddress() + ":" + response.localSocketAddress.getPort())));
        MatcherAssert.assertThat((Object)response.httpResponse, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"proxyLocalAddress: ")));
        MatcherAssert.assertThat((Object)response.httpResponse, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"proxyRemoteAddress: ")));
        MatcherAssert.assertThat((Object)response.httpResponse, (Matcher)Matchers.containsString((String)"preexisting.attribute: some value"));
        MatcherAssert.assertThat((Object)response.httpResponse, (Matcher)Matchers.containsString((String)"attributeNames: some.attribute"));
    }

    private static class ProxyResponse {
        private final InetSocketAddress localSocketAddress;
        private final InetSocketAddress remoteSocketAddress;
        private final String httpResponse;

        public ProxyResponse(InetSocketAddress localSocketAddress, InetSocketAddress remoteSocketAddress, String httpResponse) {
            this.localSocketAddress = localSocketAddress;
            this.remoteSocketAddress = remoteSocketAddress;
            this.httpResponse = httpResponse;
        }
    }
}

