/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.DumpHandler;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.util.log.StacklessLogging;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class PartialRFC2616Test {
    private Server server;
    private LocalConnector connector;

    @BeforeEach
    public void init() throws Exception {
        this.server = new Server();
        this.connector = new LocalConnector(this.server);
        this.connector.setIdleTimeout(10000L);
        this.server.addConnector((Connector)this.connector);
        ContextHandler vcontext = new ContextHandler();
        vcontext.setContextPath("/");
        vcontext.setVirtualHosts(new String[]{"VirtualHost"});
        vcontext.setHandler((Handler)new DumpHandler("Virtual Dump"));
        ContextHandler context = new ContextHandler();
        context.setContextPath("/");
        context.setHandler((Handler)new DumpHandler());
        HandlerCollection collection = new HandlerCollection();
        collection.setHandlers(new Handler[]{vcontext, context});
        this.server.setHandler((Handler)collection);
        this.server.start();
    }

    @AfterEach
    public void destroy() throws Exception {
        this.server.stop();
        this.server.join();
    }

    @Test
    public void test33() {
        try {
            HttpFields fields = new HttpFields();
            fields.put("D1", "Sun, 6 Nov 1994 08:49:37 GMT");
            fields.put("D2", "Sunday, 6-Nov-94 08:49:37 GMT");
            fields.put("D3", "Sun Nov  6 08:49:37 1994");
            Date d1 = new Date(fields.getDateField("D1"));
            Date d2 = new Date(fields.getDateField("D2"));
            Date d3 = new Date(fields.getDateField("D3"));
            Assertions.assertEquals((Object)d2, (Object)d1, (String)"3.3.1 RFC 822 RFC 850");
            Assertions.assertEquals((Object)d3, (Object)d2, (String)"3.3.1 RFC 850 ANSI C");
            fields.putDateField("Date", d1.getTime());
            Assertions.assertEquals((Object)"Sun, 06 Nov 1994 08:49:37 GMT", (Object)fields.get("Date"), (String)"3.3.1 RFC 822 preferred");
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.assertTrue((boolean)false);
        }
    }

    @Test
    public void test332() {
        try {
            String get = this.connector.getResponse("GET /R1 HTTP/1.0\nHost: localhost\n\n");
            this.checkContains(get, 0, "HTTP/1.1 200", "GET");
            this.checkContains(get, 0, "Content-Type: text/html", "GET _content");
            this.checkContains(get, 0, "<html>", "GET body");
            int cli = get.indexOf("Content-Length");
            String contentLength = get.substring(cli, get.indexOf("\r", cli));
            String head = this.connector.getResponse("HEAD /R1 HTTP/1.0\nHost: localhost\n\n");
            this.checkContains(head, 0, "HTTP/1.1 200", "HEAD");
            this.checkContains(head, 0, "Content-Type: text/html", "HEAD _content");
            Assertions.assertEquals((int)-1, (int)head.indexOf("<html>"), (String)"HEAD no body");
            this.checkContains(head, 0, contentLength, "3.3.2 HEAD");
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.assertTrue((boolean)false);
        }
    }

    @Test
    public void test36a() throws Exception {
        int offset = 0;
        String response = this.connector.getResponse("GET /R1 HTTP/1.1\nHost: localhost\nTransfer-Encoding: chunked,identity\nContent-Type: text/plain\n\r\n5;\r\n123\r\n\r\n0;\r\n\r\n");
        this.checkContains(response, offset, "HTTP/1.1 400 Bad", "Chunked last");
    }

    @Test
    public void test36b() throws Exception {
        int offset = 0;
        LocalConnector.LocalEndPoint endp = this.connector.executeRequest("GET /R1 HTTP/1.1\nHost: localhost\nTransfer-Encoding: chunked\nContent-Type: text/plain\n\n2;\n12\n3;\n345\n0;\n\nGET /R2 HTTP/1.1\nHost: localhost\nTransfer-Encoding: chunked\nContent-Type: text/plain\n\n4;\n6789\n5;\nabcde\n0;\n\nGET /R3 HTTP/1.1\nHost: localhost\nConnection: close\n\n");
        offset = 0;
        String response = endp.getResponse();
        offset = this.checkContains(response, offset, "HTTP/1.1 200", "3.6.1 Chunking");
        offset = this.checkContains(response, offset, "12345", "3.6.1 Chunking");
        offset = 0;
        response = endp.getResponse();
        offset = this.checkContains(response, offset, "HTTP/1.1 200", "3.6.1 Chunking");
        offset = this.checkContains(response, offset, "6789abcde", "3.6.1 Chunking");
        offset = 0;
        response = endp.getResponse();
        offset = this.checkContains(response, offset, "/R3", "3.6.1 Chunking");
    }

    @Test
    public void test36c() throws Exception {
        int offset = 0;
        LocalConnector.LocalEndPoint endp = this.connector.executeRequest("POST /R1 HTTP/1.1\nHost: localhost\nTransfer-Encoding: chunked\nContent-Type: text/plain\n\n3;\nfgh\n3;\nIjk\n0;\n\nPOST /R2 HTTP/1.1\nHost: localhost\nTransfer-Encoding: chunked\nContent-Type: text/plain\n\n4;\nlmno\n5;\nPqrst\n0;\n\nGET /R3 HTTP/1.1\nHost: localhost\nConnection: close\n\n");
        offset = 0;
        String response = endp.getResponse();
        this.checkNotContained(response, "HTTP/1.1 100", "3.6.1 Chunking");
        offset = this.checkContains(response, offset, "HTTP/1.1 200", "3.6.1 Chunking");
        offset = this.checkContains(response, offset, "fghIjk", "3.6.1 Chunking");
        offset = 0;
        response = endp.getResponse();
        this.checkNotContained(response, "HTTP/1.1 100", "3.6.1 Chunking");
        offset = this.checkContains(response, offset, "HTTP/1.1 200", "3.6.1 Chunking");
        offset = this.checkContains(response, offset, "lmnoPqrst", "3.6.1 Chunking");
        offset = 0;
        response = endp.getResponse();
        this.checkNotContained(response, "HTTP/1.1 100", "3.6.1 Chunking");
        offset = this.checkContains(response, offset, "/R3", "3.6.1 Chunking");
    }

    @Test
    public void test36d() throws Exception {
        int offset = 0;
        LocalConnector.LocalEndPoint endp = this.connector.executeRequest("GET /R1 HTTP/1.1\nHost: localhost\nTransfer-Encoding: chunked\nContent-Type: text/plain\nConnection: keep-alive\n\n3;\n123\n3;\n456\n0;\n\nGET /R2 HTTP/1.1\nHost: localhost\nConnection: close\n\n");
        offset = 0;
        String response = endp.getResponse();
        offset = this.checkContains(response, offset, "HTTP/1.1 200", "3.6.1 Chunking") + 10;
        offset = this.checkContains(response, offset, "123456", "3.6.1 Chunking");
        offset = 0;
        response = endp.getResponse();
        offset = this.checkContains(response, offset, "/R2", "3.6.1 Chunking") + 10;
    }

    @Test
    public void test39() throws Exception {
        HttpFields fields = new HttpFields();
        fields.put("Q", "bbb;q=0.5,aaa,ccc;q=0.002,d;q=0,e;q=0.0001,ddd;q=0.001,aa2,abb;q=0.7");
        Enumeration qualities = fields.getValues("Q", ", \t");
        List list = HttpFields.qualityList((Enumeration)qualities);
        Assertions.assertEquals((Object)"aaa", (Object)HttpFields.valueParameters((String)((String)list.get(0)), null), (String)"Quality parameters");
        Assertions.assertEquals((Object)"aa2", (Object)HttpFields.valueParameters((String)((String)list.get(1)), null), (String)"Quality parameters");
        Assertions.assertEquals((Object)"abb", (Object)HttpFields.valueParameters((String)((String)list.get(2)), null), (String)"Quality parameters");
        Assertions.assertEquals((Object)"bbb", (Object)HttpFields.valueParameters((String)((String)list.get(3)), null), (String)"Quality parameters");
        Assertions.assertEquals((Object)"ccc", (Object)HttpFields.valueParameters((String)((String)list.get(4)), null), (String)"Quality parameters");
        Assertions.assertEquals((Object)"ddd", (Object)HttpFields.valueParameters((String)((String)list.get(5)), null), (String)"Quality parameters");
    }

    @Test
    public void test41() throws Exception {
        int offset = 0;
        String response = this.connector.getResponses("\r\nGET /R1 HTTP/1.1\r\nHost: localhost\r\n\r\n\r\n\r\n\r\nGET /R2 HTTP/1.1\r\nHost: localhost\r\n\r\n \r\nGET /R3 HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\n\r\n");
        offset = this.checkContains(response, offset, "HTTP/1.1 200 OK", "2. identity") + 10;
        offset = this.checkContains(response, offset, "/R1", "2. identity") + 3;
        offset = this.checkContains(response, offset, "HTTP/1.1 200 OK", "2. identity") + 10;
        offset = this.checkContains(response, offset, "/R2", "2. identity") + 3;
        this.checkNotContained(response, offset, "HTTP/1.1 200 OK", "2. identity");
        this.checkNotContained(response, offset, "/R3", "2. identity");
    }

    @Test
    public void test442() throws Exception {
        int offset = 0;
        LocalConnector.LocalEndPoint endp = this.connector.executeRequest("GET /R1 HTTP/1.1\nHost: localhost\nTransfer-Encoding: identity\nContent-Type: text/plain\nContent-Length: 5\n\n123\r\nGET /R2 HTTP/1.1\nHost: localhost\nTransfer-Encoding: other\nConnection: close\n\n");
        offset = 0;
        String response = endp.getResponse();
        offset = this.checkContains(response, offset, "HTTP/1.1 400 ", "2. identity") + 10;
        offset = 0;
        response = endp.getResponse();
        MatcherAssert.assertThat((String)"There should be no next response as first one closed connection", (Object)response, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void test443() throws Exception {
        int offset = 0;
        LocalConnector.LocalEndPoint endp = this.connector.executeRequest("GET /R1 HTTP/1.1\nHost: localhost\nTransfer-Encoding: chunked\nContent-Type: text/plain\nContent-Length: 100\n\n3;\n123\n3;\n456\n0;\n\nGET /R2 HTTP/1.1\nHost: localhost\nConnection: close\nContent-Type: text/plain\nContent-Length: 6\n\nabcdef");
        String response = endp.getResponse();
        offset = this.checkContains(response, offset, "HTTP/1.1 400 ", "3. ignore c-l") + 1;
        this.checkNotContained(response, offset, "/R2", "3. _content-length");
    }

    @Test
    public void test444() throws Exception {
        Assertions.assertTrue((boolean)true, (String)"Skip 411 checks as IE breaks this rule");
    }

    @Test
    public void test521() throws Exception {
        int offset = 0;
        String response = this.connector.getResponse("GET http://VirtualHost:8888/path/R1 HTTP/1.1\nHost: wronghost\nConnection: close\n\n");
        offset = this.checkContains(response, offset, "HTTP/1.1 200", "Virtual host") + 1;
        offset = this.checkContains(response, offset, "Virtual Dump", "Virtual host") + 1;
        offset = this.checkContains(response, offset, "pathInfo=/path/R1", "Virtual host") + 1;
        offset = this.checkContains(response, offset, "servername=VirtualHost", "Virtual host") + 1;
    }

    @Test
    public void test522() throws Exception {
        int offset = 0;
        String response = this.connector.getResponse("GET /path/R1 HTTP/1.1\nHost: localhost\nConnection: close\n\n");
        offset = this.checkContains(response, offset, "HTTP/1.1 200", "Default host") + 1;
        offset = this.checkContains(response, offset, "Dump HttpHandler", "Default host") + 1;
        offset = this.checkContains(response, offset, "pathInfo=/path/R1", "Default host") + 1;
        offset = 0;
        response = this.connector.getResponse("GET /path/R2 HTTP/1.1\nHost: VirtualHost\nConnection: close\n\n");
        offset = this.checkContains(response, offset, "HTTP/1.1 200", "Default host") + 1;
        offset = this.checkContains(response, offset, "Virtual Dump", "virtual host") + 1;
        offset = this.checkContains(response, offset, "pathInfo=/path/R2", "Default host") + 1;
    }

    @Test
    public void test52() throws Exception {
        int offset = 0;
        String response = this.connector.getResponse("GET /path/R1 HTTP/1.1\nHost: VirtualHost\nConnection: close\n\n");
        offset = this.checkContains(response, offset, "HTTP/1.1 200", "2. virtual host field") + 1;
        offset = this.checkContains(response, offset, "Virtual Dump", "2. virtual host field") + 1;
        offset = this.checkContains(response, offset, "pathInfo=/path/R1", "2. virtual host field") + 1;
        offset = 0;
        response = this.connector.getResponse("GET /path/R1 HTTP/1.1\nHost: ViRtUalhOst\nConnection: close\n\n");
        offset = this.checkContains(response, offset, "HTTP/1.1 200", "2. virtual host field") + 1;
        offset = this.checkContains(response, offset, "Virtual Dump", "2. virtual host field") + 1;
        offset = this.checkContains(response, offset, "pathInfo=/path/R1", "2. virtual host field") + 1;
        offset = 0;
        response = this.connector.getResponse("GET /path/R1 HTTP/1.1\n\n");
        offset = this.checkContains(response, offset, "HTTP/1.1 400", "3. no host") + 1;
    }

    @Test
    public void test81() throws Exception {
        int offset = 0;
        String response = this.connector.getResponse("GET /R1 HTTP/1.1\nHost: localhost\n\n", 250L, TimeUnit.MILLISECONDS);
        offset = this.checkContains(response, offset, "HTTP/1.1 200 OK\r\n", "8.1.2 default") + 10;
        this.checkContains(response, offset, "Content-Length: ", "8.1.2 default");
        LocalConnector.LocalEndPoint endp = this.connector.executeRequest("GET /R1 HTTP/1.1\nHost: localhost\n\nGET /R2 HTTP/1.1\nHost: localhost\nConnection: close\n\nGET /R3 HTTP/1.1\nHost: localhost\nConnection: close\n\n");
        offset = 0;
        response = endp.getResponse();
        offset = this.checkContains(response, offset, "HTTP/1.1 200 OK\r\n", "8.1.2 default") + 1;
        offset = this.checkContains(response, offset, "/R1", "8.1.2 default") + 1;
        offset = 0;
        response = endp.getResponse();
        offset = this.checkContains(response, offset, "HTTP/1.1 200 OK\r\n", "8.1.2.2 pipeline") + 11;
        offset = this.checkContains(response, offset, "Connection: close", "8.1.2.2 pipeline") + 1;
        offset = this.checkContains(response, offset, "/R2", "8.1.2.1 close") + 3;
        offset = 0;
        response = endp.getResponse();
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.nullValue());
    }

    @Test
    public void test10418() throws Exception {
        int offset = 0;
        String response = this.connector.getResponse("GET /R1 HTTP/1.1\nHost: localhost\nExpect: unknown\nContent-Type: text/plain\nContent-Length: 8\n\n");
        offset = this.checkContains(response, offset, "HTTP/1.1 417", "8.2.3 expect failure") + 1;
    }

    @Test
    public void test823Dash5() throws Exception {
        int offset = 0;
        String response = this.connector.getResponse("GET /R1 HTTP/1.1\nHost: localhost\nExpect: 100-continue\nContent-Type: text/plain\nContent-Length: 8\nConnection: close\n\n123456\r\n");
        this.checkNotContained(response, offset, "HTTP/1.1 100 ", "8.2.3 expect 100");
        offset = this.checkContains(response, offset, "HTTP/1.1 200 OK", "8.2.3 expect with body") + 1;
    }

    @Test
    public void test823() throws Exception {
        int offset = 0;
        LocalConnector.LocalEndPoint endp = this.connector.executeRequest("GET /R1 HTTP/1.1\nHost: localhost\nConnection: close\nExpect: 100-continue\nContent-Type: text/plain\nContent-Length: 8\n\n");
        String infomational = endp.getResponse();
        offset = this.checkContains(infomational, offset, "HTTP/1.1 100 ", "8.2.3 expect 100") + 1;
        this.checkNotContained(infomational, offset, "HTTP/1.1 200", "8.2.3 expect 100");
        endp.addInput("654321\r\n");
        String response = endp.getResponse();
        offset = 0;
        offset = this.checkContains(response, offset, "HTTP/1.1 200", "8.2.3 expect 100") + 1;
        offset = this.checkContains(response, offset, "654321", "8.2.3 expect 100") + 1;
    }

    @Test
    public void test824() throws Exception {
        int offset = 0;
        String response = this.connector.getResponse("GET /R1?error=401 HTTP/1.1\nHost: localhost\nExpect: 100-continue\nContent-Type: text/plain\nContent-Length: 8\n\n");
        this.checkNotContained(response, offset, "HTTP/1.1 100", "8.2.3 expect 100");
        offset = this.checkContains(response, offset, "HTTP/1.1 401 ", "8.2.3 expect 100") + 1;
        offset = this.checkContains(response, offset, "Connection: close", "8.2.3 expect 100") + 1;
    }

    @Test
    public void test92() throws Exception {
        int offset = 0;
        String response = this.connector.getResponse("OPTIONS * HTTP/1.1\nConnection: close\nHost: localhost\n\n");
        offset = this.checkContains(response, offset, "HTTP/1.1 200", "200") + 1;
        offset = 0;
        response = this.connector.getResponse("GET * HTTP/1.1\nConnection: close\nHost: localhost\n\n");
        offset = this.checkContains(response, offset, "HTTP/1.1 400", "400") + 1;
    }

    @Test
    public void test94() {
        try {
            String get = this.connector.getResponse("GET /R1 HTTP/1.0\nHost: localhost\n\n");
            this.checkContains(get, 0, "HTTP/1.1 200", "GET");
            this.checkContains(get, 0, "Content-Type: text/html", "GET _content");
            this.checkContains(get, 0, "<html>", "GET body");
            String head = this.connector.getResponse("HEAD /R1 HTTP/1.0\nHost: localhost\n\n");
            this.checkContains(head, 0, "HTTP/1.1 200", "HEAD");
            this.checkContains(head, 0, "Content-Type: text/html", "HEAD _content");
            Assertions.assertEquals((int)-1, (int)head.indexOf("<html>"), (String)"HEAD no body");
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.assertTrue((boolean)false);
        }
    }

    @Test
    public void test1423() throws Exception {
        try (StacklessLogging stackless = new StacklessLogging(new Class[]{HttpParser.class});){
            int offset = 0;
            String response = this.connector.getResponse("GET /R1 HTTP/1.0\nConnection: close\n\n");
            offset = this.checkContains(response, offset, "HTTP/1.1 200", "200") + 1;
            offset = 0;
            response = this.connector.getResponse("GET /R1 HTTP/1.1\nConnection: close\n\n");
            offset = this.checkContains(response, offset, "HTTP/1.1 400", "400") + 1;
            offset = 0;
            response = this.connector.getResponse("GET /R1 HTTP/1.1\nHost: localhost\nConnection: close\n\n");
            offset = this.checkContains(response, offset, "HTTP/1.1 200", "200") + 1;
            offset = 0;
            response = this.connector.getResponse("GET /R1 HTTP/1.1\nHost:\nConnection: close\n\n");
            int n = this.checkContains(response, offset, "HTTP/1.1 200", "200") + 1;
        }
    }

    @Test
    public void test196() {
        try {
            int offset = 0;
            String response = this.connector.getResponse("GET /R1 HTTP/1.0\n\n");
            offset = this.checkContains(response, offset, "HTTP/1.1 200 OK\r\n", "19.6.2 default close") + 10;
            this.checkNotContained(response, offset, "Connection: close", "19.6.2 not assumed");
            LocalConnector.LocalEndPoint endp = this.connector.executeRequest("GET /R1 HTTP/1.0\nHost: localhost\nConnection: keep-alive\n\nGET /R2 HTTP/1.0\nHost: localhost\nConnection: close\n\nGET /R3 HTTP/1.0\nHost: localhost\nConnection: close\n\n");
            offset = 0;
            response = endp.getResponse();
            offset = this.checkContains(response, offset, "HTTP/1.1 200 OK\r\n", "19.6.2 Keep-alive 1") + 1;
            offset = this.checkContains(response, offset, "Connection: keep-alive", "19.6.2 Keep-alive 1") + 1;
            offset = this.checkContains(response, offset, "<html>", "19.6.2 Keep-alive 1") + 1;
            offset = this.checkContains(response, offset, "/R1", "19.6.2 Keep-alive 1") + 1;
            offset = 0;
            response = endp.getResponse();
            offset = this.checkContains(response, offset, "HTTP/1.1 200 OK\r\n", "19.6.2 Keep-alive 2") + 11;
            offset = this.checkContains(response, offset, "/R2", "19.6.2 Keep-alive close") + 3;
            offset = 0;
            response = endp.getResponse();
            MatcherAssert.assertThat((String)"19.6.2 closed", (Object)response, (Matcher)Matchers.nullValue());
            offset = 0;
            endp = this.connector.executeRequest("GET /R1 HTTP/1.0\nHost: localhost\nConnection: keep-alive\nContent-Length: 10\n\n1234567890\nGET /RA HTTP/1.0\nHost: localhost\nConnection: keep-alive\nContent-Length: 10\n\nABCDEFGHIJ\nGET /R2 HTTP/1.0\nHost: localhost\nConnection: close\n\nGET /R3 HTTP/1.0\nHost: localhost\nConnection: close\n\n");
            offset = 0;
            response = endp.getResponse();
            offset = this.checkContains(response, offset, "HTTP/1.1 200 OK\r\n", "19.6.2 Keep-alive 1") + 1;
            offset = this.checkContains(response, offset, "Connection: keep-alive", "19.6.2 Keep-alive 1") + 1;
            offset = this.checkContains(response, offset, "<html>", "19.6.2 Keep-alive 1") + 1;
            offset = this.checkContains(response, offset, "1234567890", "19.6.2 Keep-alive 1") + 1;
            offset = 0;
            response = endp.getResponse();
            offset = this.checkContains(response, offset, "HTTP/1.1 200 OK\r\n", "19.6.2 Keep-alive 1") + 1;
            offset = this.checkContains(response, offset, "Connection: keep-alive", "19.6.2 Keep-alive 1") + 1;
            offset = this.checkContains(response, offset, "<html>", "19.6.2 Keep-alive 1") + 1;
            offset = this.checkContains(response, offset, "ABCDEFGHIJ", "19.6.2 Keep-alive 1") + 1;
            offset = 0;
            response = endp.getResponse();
            offset = this.checkContains(response, offset, "HTTP/1.1 200 OK\r\n", "19.6.2 Keep-alive 2") + 11;
            offset = this.checkContains(response, offset, "/R2", "19.6.2 Keep-alive close") + 3;
            offset = 0;
            response = endp.getResponse();
            MatcherAssert.assertThat((String)"19.6.2 closed", (Object)response, (Matcher)Matchers.nullValue());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    private int checkContains(String s, int offset, String c, String test) {
        MatcherAssert.assertThat((String)test, (Object)s.substring(offset), (Matcher)Matchers.containsString((String)c));
        return s.indexOf(c, offset);
    }

    private void checkNotContained(String s, int offset, String c, String test) {
        MatcherAssert.assertThat((String)test, (Object)s.substring(offset), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)c)));
    }

    private void checkNotContained(String s, String c, String test) {
        this.checkNotContained(s, 0, c, test);
    }
}

