/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.DumpHandler;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.BufferUtil;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class LocalConnectorTest {
    private Server _server;
    private LocalConnector _connector;

    @BeforeEach
    public void prepare() throws Exception {
        this._server = new Server();
        this._connector = new LocalConnector(this._server);
        this._connector.setIdleTimeout(60000L);
        this._server.addConnector((Connector)this._connector);
        this._server.setHandler((Handler)new DumpHandler());
        this._server.start();
    }

    @AfterEach
    public void dispose() throws Exception {
        this._server.stop();
        this._server = null;
        this._connector = null;
    }

    @Test
    public void testOpenClose() throws Exception {
        final CountDownLatch openLatch = new CountDownLatch(1);
        final CountDownLatch closeLatch = new CountDownLatch(1);
        this._connector.addBean((Object)new Connection.Listener.Adapter(){

            public void onOpened(Connection connection) {
                openLatch.countDown();
            }

            public void onClosed(Connection connection) {
                closeLatch.countDown();
            }
        });
        this._connector.getResponse("GET / HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\n\r\n");
        Assertions.assertTrue((boolean)openLatch.await(5L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)closeLatch.await(5L, TimeUnit.SECONDS));
    }

    @Test
    public void testOneGET() throws Exception {
        String response = this._connector.getResponse("GET /R1 HTTP/1.0\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"pathInfo=/R1"));
    }

    @Test
    public void testOneResponse10() throws Exception {
        String response = this._connector.getResponse("GET /R1 HTTP/1.0\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"pathInfo=/R1"));
    }

    @Test
    public void testOneResponse10KeepAlive() throws Exception {
        String response = this._connector.getResponse("GET /R1 HTTP/1.0\r\nConnection: keep-alive\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"pathInfo=/R1"));
    }

    @Test
    public void testOneResponse10KeepAliveEmpty() throws Exception {
        String response = this._connector.getResponse("GET /R1?empty=true HTTP/1.0\r\nConnection: keep-alive\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"pathInfo=/R1")));
    }

    @Test
    public void testOneResponse11() throws Exception {
        String response = this._connector.getResponse("GET /R1 HTTP/1.1\r\nHost: localhost\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"pathInfo=/R1"));
    }

    @Test
    public void testOneResponse11close() throws Exception {
        String response = this._connector.getResponse("GET /R1 HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"pathInfo=/R1"));
    }

    @Test
    public void testOneResponse11empty() throws Exception {
        String response = this._connector.getResponse("GET /R1?empty=true HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"pathInfo=/R1")));
    }

    @Test
    public void testOneResponse11chunked() throws Exception {
        String response = this._connector.getResponse("GET /R1?flush=true HTTP/1.1\r\nHost: localhost\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"pathInfo=/R1"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"\r\n0\r\n"));
    }

    @Test
    public void testThreeResponsePipeline11() throws Exception {
        LocalConnector.LocalEndPoint endp = this._connector.connect();
        endp.addInput("GET /R1 HTTP/1.1\r\nHost: localhost\r\n\r\nGET /R2 HTTP/1.1\r\nHost: localhost\r\n\r\nGET /R3 HTTP/1.1\r\nHost: localhost\r\n\r\n");
        String response = endp.getResponse();
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"pathInfo=/R1"));
        response = endp.getResponse();
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"pathInfo=/R2"));
        response = endp.getResponse();
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"pathInfo=/R3"));
    }

    @Test
    public void testThreeResponse11() throws Exception {
        LocalConnector.LocalEndPoint endp = this._connector.connect();
        endp.addInput("GET /R1 HTTP/1.1\r\nHost: localhost\r\n\r\n");
        String response = endp.getResponse();
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"pathInfo=/R1"));
        endp.addInput("GET /R2 HTTP/1.1\r\nHost: localhost\r\n\r\n");
        response = endp.getResponse();
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"pathInfo=/R2"));
        endp.addInput("GET /R3 HTTP/1.1\r\nHost: localhost\r\n\r\n");
        response = endp.getResponse();
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"pathInfo=/R3"));
    }

    @Test
    public void testThreeResponseClosed11() throws Exception {
        LocalConnector.LocalEndPoint endp = this._connector.connect();
        endp.addInput("GET /R1 HTTP/1.1\r\nHost: localhost\r\n\r\nGET /R2 HTTP/1.1\r\nConnection: close\r\nHost: localhost\r\n\r\nGET /R3 HTTP/1.1\r\nHost: localhost\r\n\r\n");
        String response = endp.getResponse();
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"pathInfo=/R1"));
        response = endp.getResponse();
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"pathInfo=/R2"));
        response = endp.getResponse();
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.nullValue());
    }

    @Test
    public void testExpectContinuesAvailable() throws Exception {
        LocalConnector.LocalEndPoint endp = this._connector.connect();
        endp.addInput("GET /R1 HTTP/1.1\r\nHost: localhost\r\nContent-Type: text/plain; charset=UTF-8\r\nExpect: 100-Continue\r\nContent-Length: 10\r\n\r\n01234567890\r\n");
        String response = endp.getResponse();
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"pathInfo=/R1"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"0123456789"));
    }

    @Test
    public void testExpectContinues() throws Exception {
        LocalConnector.LocalEndPoint endp = this._connector.executeRequest("GET /R1 HTTP/1.1\r\nHost: localhost\r\nContent-Type: text/plain; charset=UTF-8\r\nExpect: 100-Continue\r\nContent-Length: 10\r\n\r\n");
        String response = endp.getResponse();
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 100 Continue"));
        endp.addInput("01234567890\r\n");
        response = endp.getResponse();
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"pathInfo=/R1"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"0123456789"));
    }

    @Test
    public void testStopStart() throws Exception {
        String response = this._connector.getResponse("GET /R1 HTTP/1.0\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"pathInfo=/R1"));
        this._server.stop();
        this._server.start();
        response = this._connector.getResponse("GET /R2 HTTP/1.0\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"pathInfo=/R2"));
    }

    @Test
    public void testTwoGETs() throws Exception {
        LocalConnector.LocalEndPoint endp = this._connector.connect();
        endp.addInput("GET /R1 HTTP/1.1\r\nHost: localhost\r\n\r\nGET /R2 HTTP/1.0\r\n\r\n");
        String response = endp.getResponse() + endp.getResponse();
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"pathInfo=/R1"));
        response = response.substring(response.indexOf("</html>") + 8);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"pathInfo=/R2"));
    }

    @Test
    public void testTwoGETsParsed() throws Exception {
        LocalConnector.LocalEndPoint endp = this._connector.executeRequest("GET /R1 HTTP/1.1\r\nHost: localhost\r\n\r\nGET /R2 HTTP/1.1\r\nHost: localhost\r\n\r\n");
        String response = BufferUtil.toString((ByteBuffer)endp.waitForResponse(false, 10L, TimeUnit.SECONDS), (Charset)StandardCharsets.ISO_8859_1);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"pathInfo=/R1"));
        response = BufferUtil.toString((ByteBuffer)endp.waitForResponse(false, 10L, TimeUnit.SECONDS), (Charset)StandardCharsets.ISO_8859_1);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"pathInfo=/R2"));
    }

    @Test
    public void testManyGETs() throws Exception {
        LocalConnector.LocalEndPoint endp = this._connector.connect();
        endp.addInput("GET /R1 HTTP/1.1\r\nHost: localhost\r\n\r\nGET /R2 HTTP/1.1\r\nHost: localhost\r\n\r\nGET /R3 HTTP/1.1\r\nHost: localhost\r\n\r\nGET /R4 HTTP/1.1\r\nHost: localhost\r\n\r\nGET /R5 HTTP/1.1\r\nHost: localhost\r\n\r\nGET /R6 HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\n\r\n");
        String r = "";
        String response = endp.getResponse();
        while (response != null) {
            r = r + response;
            response = endp.getResponse();
        }
        for (int i = 1; i <= 6; ++i) {
            MatcherAssert.assertThat((Object)r, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
            MatcherAssert.assertThat((Object)r, (Matcher)Matchers.containsString((String)("pathInfo=/R" + i)));
            r = r.substring(r.indexOf("</html>") + 8);
        }
    }

    @Test
    public void testGETandGET() throws Exception {
        String response = this._connector.getResponse("GET /R1 HTTP/1.0\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"pathInfo=/R1"));
        response = this._connector.getResponse("GET /R2 HTTP/1.0\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"pathInfo=/R2"));
    }
}

