/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpTester;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class LargeHeaderTest {
    private Server server;

    @BeforeEach
    public void setup() throws Exception {
        this.server = new Server();
        HttpConfiguration config = new HttpConfiguration();
        HttpConnectionFactory http = new HttpConnectionFactory(config);
        ServerConnector connector = new ServerConnector(this.server, new ConnectionFactory[]{http});
        connector.setPort(0);
        connector.setIdleTimeout(5000L);
        this.server.addConnector((Connector)connector);
        this.server.setErrorHandler(new ErrorHandler());
        this.server.setHandler((Handler)new AbstractHandler(){
            final String largeHeaderValue;
            {
                byte[] bytes = new byte[8192];
                Arrays.fill(bytes, (byte)88);
                this.largeHeaderValue = "LargeHeaderOver8k-" + new String(bytes, StandardCharsets.UTF_8) + "_Z_";
            }

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
                response.setHeader(HttpHeader.CONTENT_TYPE.toString(), MimeTypes.Type.TEXT_HTML.toString());
                response.setHeader("LongStr", this.largeHeaderValue);
                PrintWriter writer = response.getWriter();
                writer.write("<html><h1>FOO</h1></html>");
                writer.flush();
                response.flushBuffer();
                baseRequest.setHandled(true);
            }
        });
        this.server.start();
    }

    @AfterEach
    public void teardown() {
        LifeCycle.stop((Object)this.server);
    }

    @Test
    public void testLargeHeader() throws Throwable {
        Logger CLIENTLOG = Log.getLogger(LargeHeaderTest.class).getLogger(".client");
        ExecutorService executorService = Executors.newFixedThreadPool(8);
        int localPort = this.server.getURI().getPort();
        String rawRequest = "GET / HTTP/1.1\r\nHost: localhost:" + localPort + "\r\n\r\n";
        Throwable issues = new Throwable();
        for (int i = 0; i < 500; ++i) {
            executorService.submit(() -> {
                try (Socket client = new Socket("localhost", localPort);
                     OutputStream output = client.getOutputStream();
                     InputStream input = client.getInputStream();){
                    output.write(rawRequest.getBytes(StandardCharsets.UTF_8));
                    output.flush();
                    String rawResponse = IO.toString((InputStream)input, (Charset)StandardCharsets.UTF_8);
                    HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
                    MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)500));
                }
                catch (Throwable t) {
                    CLIENTLOG.warn("Client Issue", t);
                    issues.addSuppressed(t);
                }
            });
        }
        executorService.awaitTermination(5L, TimeUnit.SECONDS);
        if (issues.getSuppressed().length > 0) {
            throw issues;
        }
    }
}

