/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.HotSwapHandler;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;

public class HttpServerTestFixture {
    protected static final long PAUSE = 10L;
    protected static final int LOOPS = 50;
    protected QueuedThreadPool _threadPool;
    protected Server _server;
    protected URI _serverURI;
    protected HttpConfiguration _httpConfiguration;
    protected ServerConnector _connector;
    protected String _scheme = "http";

    protected Socket newSocket(String host, int port) throws Exception {
        Socket socket = new Socket(host, port);
        socket.setSoTimeout(10000);
        socket.setTcpNoDelay(true);
        return socket;
    }

    @BeforeEach
    public void before() {
        this._threadPool = new QueuedThreadPool();
        this._server = new Server((ThreadPool)this._threadPool);
    }

    protected void startServer(ServerConnector connector) throws Exception {
        this.startServer(connector, (Handler)new HotSwapHandler());
    }

    protected void startServer(ServerConnector connector, Handler handler) throws Exception {
        this._connector = connector;
        this._httpConfiguration = ((HttpConnectionFactory)this._connector.getConnectionFactory(HttpConnectionFactory.class)).getHttpConfiguration();
        this._httpConfiguration.setBlockingTimeout(-1L);
        this._httpConfiguration.setSendDateHeader(false);
        this._server.addConnector((Connector)this._connector);
        this._server.setHandler(handler);
        this._server.start();
        this._serverURI = this._server.getURI();
    }

    @AfterEach
    public void stopServer() throws Exception {
        this._server.stop();
        this._server.join();
        this._server.setConnectors(new Connector[0]);
    }

    protected void configureServer(Handler handler) throws Exception {
        HotSwapHandler swapper = (HotSwapHandler)this._server.getHandler();
        swapper.setHandler(handler);
        handler.start();
    }

    protected static class DataHandler
    extends AbstractHandler {
        protected DataHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            response.setStatus(200);
            ServletInputStream in = request.getInputStream();
            String input = IO.toString((InputStream)in);
            String tmp = request.getParameter("writes");
            int writes = Integer.parseInt(tmp == null ? "10" : tmp);
            tmp = request.getParameter("block");
            int block = Integer.parseInt(tmp == null ? "10" : tmp);
            String encoding = request.getParameter("encoding");
            String chars = request.getParameter("chars");
            String data = "\u0a870123456789A\u0a87CDEFGHIJKLMNOPQRSTUVWXYZ\u0250bcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
            while (data.length() < block) {
                data = data + data;
            }
            String chunk = (input + data).substring(0, block);
            response.setContentType("text/plain");
            if (encoding == null) {
                byte[] bytes = chunk.getBytes(StandardCharsets.ISO_8859_1);
                ServletOutputStream out = response.getOutputStream();
                for (int i = 0; i < writes; ++i) {
                    out.write(bytes);
                }
            } else if ("true".equals(chars)) {
                response.setCharacterEncoding(encoding);
                PrintWriter out = response.getWriter();
                char[] c = chunk.toCharArray();
                for (int i = 0; i < writes; ++i) {
                    out.write(c);
                    if (!out.checkError()) {
                        continue;
                    }
                    break;
                }
            } else {
                response.setCharacterEncoding(encoding);
                PrintWriter out = response.getWriter();
                for (int i = 0; i < writes; ++i) {
                    out.write(chunk);
                    if (!out.checkError()) {
                        continue;
                    }
                    break;
                }
            }
        }
    }

    protected static class ReadHandler
    extends AbstractHandler {
        protected ReadHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            response.setStatus(200);
            try {
                ServletInputStream in = request.getInputStream();
                String input = IO.toString((InputStream)in);
                response.getWriter().printf("read %d%n", input.length());
            }
            catch (Exception e) {
                response.getWriter().printf("caught %s%n", e);
            }
        }
    }

    protected static class ReadExactHandler
    extends AbstractHandler {
        private int expected;

        public ReadExactHandler() {
            this(-1);
        }

        public ReadExactHandler(int expected) {
            this.expected = expected;
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            int offset;
            int read;
            int len;
            baseRequest.setHandled(true);
            int n = len = this.expected < 0 ? request.getContentLength() : this.expected;
            if (len < 0) {
                throw new IllegalStateException();
            }
            byte[] content = new byte[len];
            for (offset = 0; offset < len && (read = request.getInputStream().read(content, offset, len - offset)) >= 0; offset += read) {
            }
            response.setStatus(200);
            String reply = "Read " + offset + "\r\n";
            response.setContentLength(reply.length());
            response.getOutputStream().write(reply.getBytes(StandardCharsets.ISO_8859_1));
        }
    }

    protected static class SendErrorHandler
    extends AbstractHandler {
        private final int code;
        private final String message;

        public SendErrorHandler() {
            this(500, null);
        }

        public SendErrorHandler(int code, String message) {
            this.code = code;
            this.message = message;
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            response.sendError(this.code, this.message);
        }
    }

    protected static class HelloWorldHandler
    extends AbstractHandler {
        protected HelloWorldHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            response.setStatus(200);
            response.getOutputStream().print("Hello world\r\n");
        }
    }

    protected static class OptionsHandler
    extends AbstractHandler {
        protected OptionsHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            if (request.getMethod().equals("OPTIONS")) {
                response.setStatus(200);
            } else {
                response.setStatus(500);
            }
            response.setHeader("Allow", "GET");
        }
    }

    protected static class EchoHandler
    extends AbstractHandler {
        boolean _musthavecontent = true;

        public EchoHandler() {
        }

        public EchoHandler(boolean content) {
            this._musthavecontent = false;
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            Log.getRootLogger().debug("handle " + target, new Object[0]);
            baseRequest.setHandled(true);
            if (request.getContentType() != null) {
                response.setContentType(request.getContentType());
            }
            if (request.getParameter("charset") != null) {
                response.setCharacterEncoding(request.getParameter("charset"));
            } else if (request.getCharacterEncoding() != null) {
                response.setCharacterEncoding(request.getCharacterEncoding());
            }
            PrintWriter writer = response.getWriter();
            int count = 0;
            BufferedReader reader = request.getReader();
            if (request.getContentLength() != 0) {
                String line = reader.readLine();
                while (line != null) {
                    writer.print(line);
                    writer.print("\n");
                    count += line.length();
                    line = reader.readLine();
                }
            }
            if (count == 0) {
                if (this._musthavecontent) {
                    throw new IllegalStateException("no input received");
                }
                writer.println("No content");
            }
            reader.close();
            writer.close();
            if (reader.read() >= 0) {
                throw new IllegalStateException("Not closed");
            }
            Log.getRootLogger().debug("handled " + target, new Object[0]);
        }
    }
}

