/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Stream;
import javax.servlet.AsyncContext;
import javax.servlet.ServletException;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpFieldsMatchers;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpTester;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.AbstractHttpTest;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpChannelState;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.log.StacklessLogging;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class HttpManyWaysToAsyncCommitTest
extends AbstractHttpTest {
    private final String contextAttribute = this.getClass().getName() + ".asyncContext";

    public static Stream<Arguments> httpVersion() {
        boolean DISPATCH = true;
        boolean COMPLETE = false;
        boolean IN_WAIT = true;
        boolean WHILE_DISPATCHED = false;
        ArrayList<Arguments> ret = new ArrayList<Arguments>();
        ret.add(Arguments.of((Object[])new Object[]{HttpVersion.HTTP_1_0, true, true}));
        ret.add(Arguments.of((Object[])new Object[]{HttpVersion.HTTP_1_1, true, true}));
        ret.add(Arguments.of((Object[])new Object[]{HttpVersion.HTTP_1_0, false, true}));
        ret.add(Arguments.of((Object[])new Object[]{HttpVersion.HTTP_1_1, false, true}));
        ret.add(Arguments.of((Object[])new Object[]{HttpVersion.HTTP_1_0, true, false}));
        ret.add(Arguments.of((Object[])new Object[]{HttpVersion.HTTP_1_1, true, false}));
        ret.add(Arguments.of((Object[])new Object[]{HttpVersion.HTTP_1_0, false, false}));
        ret.add(Arguments.of((Object[])new Object[]{HttpVersion.HTTP_1_1, false, false}));
        return ret.stream();
    }

    @ParameterizedTest
    @MethodSource(value={"httpVersion"})
    public void testHandlerDoesNotSetHandled(HttpVersion httpVersion, boolean dispatch, boolean inWait) throws Exception {
        DoesNotSetHandledHandler handler = new DoesNotSetHandledHandler(false, dispatch, inWait);
        server.setHandler((Handler)handler);
        server.start();
        HttpTester.Response response = this.executeRequest(httpVersion);
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)404));
        MatcherAssert.assertThat((Object)handler.failure(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @ParameterizedTest
    @MethodSource(value={"httpVersion"})
    public void testHandlerDoesNotSetHandledAndThrow(HttpVersion httpVersion, boolean dispatch, boolean inWait) throws Exception {
        HttpTester.Response response;
        DoesNotSetHandledHandler handler = new DoesNotSetHandledHandler(true, dispatch, inWait);
        server.setHandler((Handler)handler);
        server.start();
        if (inWait) {
            response = this.executeRequest(httpVersion);
        } else {
            try (StacklessLogging log = new StacklessLogging(new Class[]{HttpChannelState.class});){
                response = this.executeRequest(httpVersion);
            }
        }
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)500));
        MatcherAssert.assertThat((Object)handler.failure(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @ParameterizedTest
    @MethodSource(value={"httpVersion"})
    public void testHandlerSetsHandledTrueOnly(HttpVersion httpVersion, boolean dispatch, boolean inWait) throws Exception {
        OnlySetHandledHandler handler = new OnlySetHandledHandler(false, dispatch, inWait);
        server.setHandler((Handler)handler);
        server.start();
        HttpTester.Response response = this.executeRequest(httpVersion);
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        if (httpVersion.is("HTTP/1.1")) {
            MatcherAssert.assertThat((Object)response, (Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_LENGTH, (String)"0"));
        }
        MatcherAssert.assertThat((Object)handler.failure(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @ParameterizedTest
    @MethodSource(value={"httpVersion"})
    public void testHandlerSetsHandledTrueOnlyAndThrow(HttpVersion httpVersion, boolean dispatch, boolean inWait) throws Exception {
        HttpTester.Response response;
        OnlySetHandledHandler handler = new OnlySetHandledHandler(true, dispatch, inWait);
        server.setHandler((Handler)handler);
        server.start();
        if (inWait) {
            response = this.executeRequest(httpVersion);
        } else {
            try (StacklessLogging log = new StacklessLogging(new Class[]{HttpChannelState.class});){
                response = this.executeRequest(httpVersion);
            }
        }
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)500));
        MatcherAssert.assertThat((Object)handler.failure(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @ParameterizedTest
    @MethodSource(value={"httpVersion"})
    public void testHandlerSetsHandledAndWritesSomeContent(HttpVersion httpVersion, boolean dispatch, boolean inWait) throws Exception {
        SetHandledWriteSomeDataHandler handler = new SetHandledWriteSomeDataHandler(false, dispatch, inWait);
        server.setHandler((Handler)handler);
        server.start();
        HttpTester.Response response = this.executeRequest(httpVersion);
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response, (Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_LENGTH, (String)"6"));
        MatcherAssert.assertThat((Object)handler.failure(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @ParameterizedTest
    @MethodSource(value={"httpVersion"})
    public void testHandlerSetsHandledAndWritesSomeContentAndThrow(HttpVersion httpVersion, boolean dispatch, boolean inWait) throws Exception {
        HttpTester.Response response;
        SetHandledWriteSomeDataHandler handler = new SetHandledWriteSomeDataHandler(true, dispatch, inWait);
        server.setHandler((Handler)handler);
        server.start();
        if (inWait) {
            response = this.executeRequest(httpVersion);
        } else {
            try (StacklessLogging log = new StacklessLogging(new Class[]{HttpChannelState.class});){
                response = this.executeRequest(httpVersion);
            }
        }
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)500));
        MatcherAssert.assertThat((Object)handler.failure(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @ParameterizedTest
    @MethodSource(value={"httpVersion"})
    public void testHandlerExplicitFlush(HttpVersion httpVersion, boolean dispatch, boolean inWait) throws Exception {
        ExplicitFlushHandler handler = new ExplicitFlushHandler(false, dispatch, inWait);
        server.setHandler((Handler)handler);
        server.start();
        HttpTester.Response response = this.executeRequest(httpVersion);
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)handler.failure(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        if (httpVersion.is("HTTP/1.1")) {
            MatcherAssert.assertThat((Object)response, (Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.TRANSFER_ENCODING, (String)"chunked"));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"httpVersion"})
    public void testHandlerExplicitFlushAndThrow(HttpVersion httpVersion, boolean dispatch, boolean inWait) throws Exception {
        ExplicitFlushHandler handler = new ExplicitFlushHandler(true, dispatch, inWait);
        server.setHandler((Handler)handler);
        server.start();
        HttpTester.Response response = this.executeRequest(httpVersion);
        if (inWait) {
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)500));
        } else {
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
            if (httpVersion.is("HTTP/1.1")) {
                MatcherAssert.assertThat((Object)response, (Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.TRANSFER_ENCODING, (String)"chunked"));
            }
        }
        MatcherAssert.assertThat((Object)handler.failure(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @ParameterizedTest
    @MethodSource(value={"httpVersion"})
    public void testHandledAndFlushWithoutContent(HttpVersion httpVersion, boolean dispatch, boolean inWait) throws Exception {
        SetHandledAndFlushWithoutContentHandler handler = new SetHandledAndFlushWithoutContentHandler(false, dispatch, inWait);
        server.setHandler((Handler)handler);
        server.start();
        HttpTester.Response response = this.executeRequest(httpVersion);
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)handler.failure(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        if (httpVersion.is("HTTP/1.1")) {
            MatcherAssert.assertThat((Object)response, (Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.TRANSFER_ENCODING, (String)"chunked"));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"httpVersion"})
    public void testHandledAndFlushWithoutContentAndThrow(HttpVersion httpVersion, boolean dispatch, boolean inWait) throws Exception {
        SetHandledAndFlushWithoutContentHandler handler = new SetHandledAndFlushWithoutContentHandler(true, dispatch, inWait);
        server.setHandler((Handler)handler);
        server.start();
        HttpTester.Response response = this.executeRequest(httpVersion);
        if (inWait) {
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)500));
        } else {
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
            if (httpVersion.is("HTTP/1.1")) {
                MatcherAssert.assertThat((Object)response, (Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.TRANSFER_ENCODING, (String)"chunked"));
            }
        }
        MatcherAssert.assertThat((Object)handler.failure(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @ParameterizedTest
    @MethodSource(value={"httpVersion"})
    public void testWriteFlushWriteMore(HttpVersion httpVersion, boolean dispatch, boolean inWait) throws Exception {
        WriteFlushWriteMoreHandler handler = new WriteFlushWriteMoreHandler(false, dispatch, inWait);
        server.setHandler((Handler)handler);
        server.start();
        HttpTester.Response response = this.executeRequest(httpVersion);
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)handler.failure(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        if (httpVersion.is("HTTP/1.1")) {
            MatcherAssert.assertThat((Object)response, (Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.TRANSFER_ENCODING, (String)"chunked"));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"httpVersion"})
    public void testWriteFlushWriteMoreAndThrow(HttpVersion httpVersion, boolean dispatch, boolean inWait) throws Exception {
        WriteFlushWriteMoreHandler handler = new WriteFlushWriteMoreHandler(true, dispatch, inWait);
        server.setHandler((Handler)handler);
        server.start();
        HttpTester.Response response = this.executeRequest(httpVersion);
        if (inWait) {
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)500));
        } else {
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
            if (httpVersion.is("HTTP/1.1")) {
                MatcherAssert.assertThat((Object)response, (Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.TRANSFER_ENCODING, (String)"chunked"));
            }
        }
        MatcherAssert.assertThat((Object)handler.failure(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @ParameterizedTest
    @MethodSource(value={"httpVersion"})
    public void testBufferOverflow(HttpVersion httpVersion, boolean dispatch, boolean inWait) throws Exception {
        OverflowHandler handler = new OverflowHandler(false, dispatch, inWait);
        server.setHandler((Handler)handler);
        server.start();
        HttpTester.Response response = this.executeRequest(httpVersion);
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.is((Object)"foobar"));
        if (httpVersion.is("HTTP/1.1")) {
            MatcherAssert.assertThat((Object)response, (Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.TRANSFER_ENCODING, (String)"chunked"));
        }
        MatcherAssert.assertThat((Object)handler.failure(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @ParameterizedTest
    @MethodSource(value={"httpVersion"})
    public void testBufferOverflowAndThrow(HttpVersion httpVersion, boolean dispatch, boolean inWait) throws Exception {
        OverflowHandler handler = new OverflowHandler(true, dispatch, inWait);
        server.setHandler((Handler)handler);
        server.start();
        HttpTester.Response response = this.executeRequest(httpVersion);
        if (inWait) {
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)500));
            MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.containsString((String)"TestCommitException: Thrown by test"));
        } else {
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
            MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.is((Object)"foobar"));
            if (httpVersion.is("HTTP/1.1")) {
                MatcherAssert.assertThat((Object)response, (Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.TRANSFER_ENCODING, (String)"chunked"));
            }
            MatcherAssert.assertThat((Object)handler.failure(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"httpVersion"})
    public void testSetContentLengthAndWriteExactlyThatAmountOfBytes(HttpVersion httpVersion, boolean dispatch, boolean inWait) throws Exception {
        SetContentLengthAndWriteThatAmountOfBytesHandler handler = new SetContentLengthAndWriteThatAmountOfBytesHandler(false, dispatch, inWait);
        server.setHandler((Handler)handler);
        server.start();
        HttpTester.Response response = this.executeRequest(httpVersion);
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.is((Object)"foo"));
        MatcherAssert.assertThat((Object)response, (Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_LENGTH, (String)"3"));
        MatcherAssert.assertThat((Object)handler.failure(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @ParameterizedTest
    @MethodSource(value={"httpVersion"})
    public void testSetContentLengthAndWriteExactlyThatAmountOfBytesAndThrow(HttpVersion httpVersion, boolean dispatch, boolean inWait) throws Exception {
        SetContentLengthAndWriteThatAmountOfBytesHandler handler = new SetContentLengthAndWriteThatAmountOfBytesHandler(true, dispatch, inWait);
        server.setHandler((Handler)handler);
        server.start();
        HttpTester.Response response = this.executeRequest(httpVersion);
        if (inWait) {
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)500));
        } else {
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
            MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.is((Object)"foo"));
            MatcherAssert.assertThat((Object)response, (Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_LENGTH, (String)"3"));
        }
        MatcherAssert.assertThat((Object)handler.failure(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @ParameterizedTest
    @MethodSource(value={"httpVersion"})
    public void testSetContentLengthAndWriteMoreBytes(HttpVersion httpVersion, boolean dispatch, boolean inWait) throws Exception {
        SetContentLengthAndWriteMoreBytesHandler handler = new SetContentLengthAndWriteMoreBytesHandler(false, dispatch, inWait);
        server.setHandler((Handler)handler);
        server.start();
        HttpTester.Response response = this.executeRequest(httpVersion);
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.is((Object)"foo"));
        MatcherAssert.assertThat((Object)response, (Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_LENGTH, (String)"3"));
        MatcherAssert.assertThat((Object)handler.failure(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @ParameterizedTest
    @MethodSource(value={"httpVersion"})
    public void testSetContentLengthAndWriteMoreAndThrow(HttpVersion httpVersion, boolean dispatch, boolean inWait) throws Exception {
        SetContentLengthAndWriteMoreBytesHandler handler = new SetContentLengthAndWriteMoreBytesHandler(true, dispatch, inWait);
        server.setHandler((Handler)handler);
        server.start();
        HttpTester.Response response = this.executeRequest(httpVersion);
        if (inWait) {
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)500));
        } else {
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
            MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.is((Object)"foo"));
            MatcherAssert.assertThat((Object)response, (Matcher)HttpFieldsMatchers.containsHeaderValue((HttpHeader)HttpHeader.CONTENT_LENGTH, (String)"3"));
        }
        MatcherAssert.assertThat((Object)handler.failure(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @ParameterizedTest
    @MethodSource(value={"httpVersion"})
    public void testWriteAndSetContentLength(HttpVersion httpVersion, boolean dispatch, boolean inWait) throws Exception {
        WriteAndSetContentLengthHandler handler = new WriteAndSetContentLengthHandler(false, dispatch, inWait);
        server.setHandler((Handler)handler);
        server.start();
        HttpTester.Response response = this.executeRequest(httpVersion);
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)handler.failure(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @ParameterizedTest
    @MethodSource(value={"httpVersion"})
    public void testWriteAndSetContentLengthAndThrow(HttpVersion httpVersion, boolean dispatch, boolean inWait) throws Exception {
        WriteAndSetContentLengthHandler handler = new WriteAndSetContentLengthHandler(true, dispatch, inWait);
        server.setHandler((Handler)handler);
        server.start();
        HttpTester.Response response = this.executeRequest(httpVersion);
        if (inWait) {
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)500));
        } else {
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        }
        MatcherAssert.assertThat((Object)handler.failure(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @ParameterizedTest
    @MethodSource(value={"httpVersion"})
    public void testWriteAndSetContentLengthTooSmall(HttpVersion httpVersion, boolean dispatch, boolean inWait) throws Exception {
        WriteAndSetContentLengthTooSmallHandler handler = new WriteAndSetContentLengthTooSmallHandler(false, dispatch, inWait);
        server.setHandler((Handler)handler);
        server.start();
        HttpTester.Response response = this.executeRequest(httpVersion);
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)handler.failure(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.nullValue())));
    }

    @ParameterizedTest
    @MethodSource(value={"httpVersion"})
    public void testWriteAndSetContentLengthTooSmallAndThrow(HttpVersion httpVersion, boolean dispatch, boolean inWait) throws Exception {
        HttpTester.Response response;
        WriteAndSetContentLengthTooSmallHandler handler = new WriteAndSetContentLengthTooSmallHandler(true, dispatch, inWait);
        server.setHandler((Handler)handler);
        server.start();
        try (StacklessLogging stackless = new StacklessLogging(new Class[]{HttpChannelState.class});){
            response = this.executeRequest(httpVersion);
        }
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)500));
        if (!inWait) {
            MatcherAssert.assertThat((Object)handler.failure(), (Matcher)Matchers.not((Matcher)Matchers.is((Matcher)Matchers.nullValue())));
        } else {
            MatcherAssert.assertThat((Object)handler.failure(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        }
    }

    private void runAsyncInAsyncWait(Request request, Runnable task) {
        server.getThreadPool().execute(() -> {
            long end = System.nanoTime() + TimeUnit.SECONDS.toNanos(10L);
            try {
                block6: while (System.nanoTime() < end) {
                    switch (request.getHttpChannelState().getState()) {
                        case WAITING: {
                            task.run();
                            return;
                        }
                        case HANDLING: {
                            Thread.sleep(100L);
                            continue block6;
                        }
                    }
                    request.getHttpChannel().abort((Throwable)new IllegalStateException());
                    return;
                }
                request.getHttpChannel().abort((Throwable)new TimeoutException());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        });
    }

    private void runAsyncWhileDispatched(Runnable task) {
        CountDownLatch ran = new CountDownLatch(1);
        server.getThreadPool().execute(() -> {
            try {
                task.run();
            }
            finally {
                ran.countDown();
            }
        });
        try {
            ran.await(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void runAsync(Request request, boolean inWait, Runnable task) {
        if (inWait) {
            this.runAsyncInAsyncWait(request, task);
        } else {
            this.runAsyncWhileDispatched(task);
        }
    }

    private class WriteAndSetContentLengthTooSmallHandler
    extends AbstractHttpTest.ThrowExceptionOnDemandHandler {
        private final boolean dispatch;
        private final boolean inWait;

        private WriteAndSetContentLengthTooSmallHandler(boolean throwException, boolean dispatch, boolean inWait) {
            super(HttpManyWaysToAsyncCommitTest.this, throwException);
            this.dispatch = dispatch;
            this.inWait = inWait;
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if (request.getAttribute(HttpManyWaysToAsyncCommitTest.this.contextAttribute) == null) {
                AsyncContext asyncContext = baseRequest.startAsync();
                request.setAttribute(HttpManyWaysToAsyncCommitTest.this.contextAttribute, (Object)asyncContext);
                HttpManyWaysToAsyncCommitTest.this.runAsync(baseRequest, this.inWait, () -> {
                    try {
                        ServletResponse asyncContextResponse = asyncContext.getResponse();
                        asyncContextResponse.getWriter().write("foobar");
                        asyncContextResponse.setContentLength(3);
                    }
                    catch (Throwable e) {
                        this.markFailed(e);
                        if (this.dispatch) {
                            asyncContext.dispatch();
                        }
                        asyncContext.complete();
                    }
                });
            }
            baseRequest.setHandled(true);
            super.handle(target, baseRequest, request, response);
        }
    }

    private class WriteAndSetContentLengthHandler
    extends AbstractHttpTest.ThrowExceptionOnDemandHandler {
        private final boolean dispatch;
        private final boolean inWait;

        private WriteAndSetContentLengthHandler(boolean throwException, boolean dispatch, boolean inWait) {
            super(HttpManyWaysToAsyncCommitTest.this, throwException);
            this.dispatch = dispatch;
            this.inWait = inWait;
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if (request.getAttribute(HttpManyWaysToAsyncCommitTest.this.contextAttribute) == null) {
                AsyncContext asyncContext = baseRequest.startAsync();
                request.setAttribute(HttpManyWaysToAsyncCommitTest.this.contextAttribute, (Object)asyncContext);
                HttpManyWaysToAsyncCommitTest.this.runAsync(baseRequest, this.inWait, () -> {
                    try {
                        ServletResponse asyncContextResponse = asyncContext.getResponse();
                        asyncContextResponse.getWriter().write("foo");
                        asyncContextResponse.setContentLength(3);
                        if (this.dispatch) {
                            asyncContext.dispatch();
                        } else {
                            asyncContext.complete();
                        }
                    }
                    catch (IOException e) {
                        this.markFailed(e);
                    }
                });
            }
            baseRequest.setHandled(true);
            super.handle(target, baseRequest, request, response);
        }
    }

    private class SetContentLengthAndWriteMoreBytesHandler
    extends AbstractHttpTest.ThrowExceptionOnDemandHandler {
        private final boolean dispatch;
        private final boolean inWait;

        private SetContentLengthAndWriteMoreBytesHandler(boolean throwException, boolean dispatch, boolean inWait) {
            super(HttpManyWaysToAsyncCommitTest.this, throwException);
            this.dispatch = dispatch;
            this.inWait = inWait;
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if (request.getAttribute(HttpManyWaysToAsyncCommitTest.this.contextAttribute) == null) {
                AsyncContext asyncContext = baseRequest.startAsync();
                request.setAttribute(HttpManyWaysToAsyncCommitTest.this.contextAttribute, (Object)asyncContext);
                HttpManyWaysToAsyncCommitTest.this.runAsync(baseRequest, this.inWait, () -> {
                    try {
                        ServletResponse asyncContextResponse = asyncContext.getResponse();
                        asyncContextResponse.setContentLength(3);
                        asyncContextResponse.getWriter().write("foobar");
                        if (this.dispatch) {
                            asyncContext.dispatch();
                        } else {
                            asyncContext.complete();
                        }
                    }
                    catch (IOException e) {
                        this.markFailed(e);
                    }
                });
            }
            baseRequest.setHandled(true);
            super.handle(target, baseRequest, request, response);
        }
    }

    private class SetContentLengthAndWriteThatAmountOfBytesHandler
    extends AbstractHttpTest.ThrowExceptionOnDemandHandler {
        private final boolean dispatch;
        private final boolean inWait;

        private SetContentLengthAndWriteThatAmountOfBytesHandler(boolean throwException, boolean dispatch, boolean inWait) {
            super(HttpManyWaysToAsyncCommitTest.this, throwException);
            this.dispatch = dispatch;
            this.inWait = inWait;
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if (request.getAttribute(HttpManyWaysToAsyncCommitTest.this.contextAttribute) == null) {
                AsyncContext asyncContext = baseRequest.startAsync();
                request.setAttribute(HttpManyWaysToAsyncCommitTest.this.contextAttribute, (Object)asyncContext);
                HttpManyWaysToAsyncCommitTest.this.runAsync(baseRequest, this.inWait, () -> {
                    try {
                        ServletResponse asyncContextResponse = asyncContext.getResponse();
                        asyncContextResponse.setContentLength(3);
                        asyncContextResponse.getWriter().write("foo");
                        if (this.dispatch) {
                            asyncContext.dispatch();
                        } else {
                            asyncContext.complete();
                        }
                    }
                    catch (IOException e) {
                        this.markFailed(e);
                    }
                });
            }
            baseRequest.setHandled(true);
            super.handle(target, baseRequest, request, response);
        }
    }

    private class OverflowHandler
    extends AbstractHttpTest.ThrowExceptionOnDemandHandler {
        private final boolean dispatch;
        private final boolean inWait;

        private OverflowHandler(boolean throwException, boolean dispatch, boolean inWait) {
            super(HttpManyWaysToAsyncCommitTest.this, throwException);
            this.dispatch = dispatch;
            this.inWait = inWait;
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if (request.getAttribute(HttpManyWaysToAsyncCommitTest.this.contextAttribute) == null) {
                AsyncContext asyncContext = baseRequest.startAsync();
                request.setAttribute(HttpManyWaysToAsyncCommitTest.this.contextAttribute, (Object)asyncContext);
                HttpManyWaysToAsyncCommitTest.this.runAsync(baseRequest, this.inWait, () -> {
                    try {
                        ServletResponse asyncContextResponse = asyncContext.getResponse();
                        asyncContextResponse.setBufferSize(3);
                        asyncContextResponse.getWriter().write("foobar");
                        if (this.dispatch) {
                            asyncContext.dispatch();
                        } else {
                            asyncContext.complete();
                        }
                    }
                    catch (IOException e) {
                        this.markFailed(e);
                    }
                });
            }
            baseRequest.setHandled(true);
            super.handle(target, baseRequest, request, response);
        }
    }

    private class WriteFlushWriteMoreHandler
    extends AbstractHttpTest.ThrowExceptionOnDemandHandler {
        private final boolean dispatch;
        private final boolean inWait;

        private WriteFlushWriteMoreHandler(boolean throwException, boolean dispatch, boolean inWait) {
            super(HttpManyWaysToAsyncCommitTest.this, throwException);
            this.dispatch = dispatch;
            this.inWait = inWait;
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if (request.getAttribute(HttpManyWaysToAsyncCommitTest.this.contextAttribute) == null) {
                AsyncContext asyncContext = baseRequest.startAsync();
                request.setAttribute(HttpManyWaysToAsyncCommitTest.this.contextAttribute, (Object)asyncContext);
                HttpManyWaysToAsyncCommitTest.this.runAsync(baseRequest, this.inWait, () -> {
                    try {
                        ServletResponse asyncContextResponse = asyncContext.getResponse();
                        asyncContextResponse.getWriter().write("foo");
                        asyncContextResponse.flushBuffer();
                        asyncContextResponse.getWriter().write("bar");
                        if (this.dispatch) {
                            asyncContext.dispatch();
                        } else {
                            asyncContext.complete();
                        }
                    }
                    catch (IOException e) {
                        this.markFailed(e);
                    }
                });
            }
            baseRequest.setHandled(true);
            super.handle(target, baseRequest, request, response);
        }
    }

    private class SetHandledAndFlushWithoutContentHandler
    extends AbstractHttpTest.ThrowExceptionOnDemandHandler {
        private final boolean dispatch;
        private final boolean inWait;

        private SetHandledAndFlushWithoutContentHandler(boolean throwException, boolean dispatch, boolean inWait) {
            super(HttpManyWaysToAsyncCommitTest.this, throwException);
            this.dispatch = dispatch;
            this.inWait = inWait;
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if (request.getAttribute(HttpManyWaysToAsyncCommitTest.this.contextAttribute) == null) {
                AsyncContext asyncContext = baseRequest.startAsync();
                request.setAttribute(HttpManyWaysToAsyncCommitTest.this.contextAttribute, (Object)asyncContext);
                HttpManyWaysToAsyncCommitTest.this.runAsync(baseRequest, this.inWait, () -> {
                    try {
                        asyncContext.getResponse().flushBuffer();
                        if (this.dispatch) {
                            asyncContext.dispatch();
                        } else {
                            asyncContext.complete();
                        }
                    }
                    catch (IOException e) {
                        this.markFailed(e);
                    }
                });
            }
            baseRequest.setHandled(true);
            super.handle(target, baseRequest, request, response);
        }
    }

    private class ExplicitFlushHandler
    extends AbstractHttpTest.ThrowExceptionOnDemandHandler {
        private final boolean dispatch;
        private final boolean inWait;

        private ExplicitFlushHandler(boolean throwException, boolean dispatch, boolean inWait) {
            super(HttpManyWaysToAsyncCommitTest.this, throwException);
            this.dispatch = dispatch;
            this.inWait = inWait;
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if (request.getAttribute(HttpManyWaysToAsyncCommitTest.this.contextAttribute) == null) {
                AsyncContext asyncContext = baseRequest.startAsync();
                request.setAttribute(HttpManyWaysToAsyncCommitTest.this.contextAttribute, (Object)asyncContext);
                HttpManyWaysToAsyncCommitTest.this.runAsync(baseRequest, this.inWait, () -> {
                    try {
                        ServletResponse asyncContextResponse = asyncContext.getResponse();
                        asyncContextResponse.getWriter().write("foobar");
                        asyncContextResponse.flushBuffer();
                        if (this.dispatch) {
                            asyncContext.dispatch();
                        } else {
                            asyncContext.complete();
                        }
                    }
                    catch (IOException e) {
                        this.markFailed(e);
                    }
                });
            }
            baseRequest.setHandled(true);
            super.handle(target, baseRequest, request, response);
        }
    }

    private class SetHandledWriteSomeDataHandler
    extends AbstractHttpTest.ThrowExceptionOnDemandHandler {
        private final boolean dispatch;
        private final boolean inWait;

        private SetHandledWriteSomeDataHandler(boolean throwException, boolean dispatch, boolean inWait) {
            super(HttpManyWaysToAsyncCommitTest.this, throwException);
            this.dispatch = dispatch;
            this.inWait = inWait;
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if (request.getAttribute(HttpManyWaysToAsyncCommitTest.this.contextAttribute) == null) {
                AsyncContext asyncContext = baseRequest.startAsync();
                request.setAttribute(HttpManyWaysToAsyncCommitTest.this.contextAttribute, (Object)asyncContext);
                HttpManyWaysToAsyncCommitTest.this.runAsync(baseRequest, this.inWait, () -> {
                    try {
                        asyncContext.getResponse().getWriter().write("foobar");
                        if (this.dispatch) {
                            asyncContext.dispatch();
                        } else {
                            asyncContext.complete();
                        }
                    }
                    catch (IOException e) {
                        this.markFailed(e);
                    }
                });
            }
            baseRequest.setHandled(true);
            super.handle(target, baseRequest, request, response);
        }
    }

    private class OnlySetHandledHandler
    extends AbstractHttpTest.ThrowExceptionOnDemandHandler {
        private final boolean dispatch;
        private final boolean inWait;

        private OnlySetHandledHandler(boolean throwException, boolean dispatch, boolean inWait) {
            super(HttpManyWaysToAsyncCommitTest.this, throwException);
            this.dispatch = dispatch;
            this.inWait = inWait;
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if (request.getAttribute(HttpManyWaysToAsyncCommitTest.this.contextAttribute) == null) {
                AsyncContext asyncContext = baseRequest.startAsync();
                request.setAttribute(HttpManyWaysToAsyncCommitTest.this.contextAttribute, (Object)asyncContext);
                HttpManyWaysToAsyncCommitTest.this.runAsync(baseRequest, this.inWait, () -> {
                    if (this.dispatch) {
                        asyncContext.dispatch();
                    } else {
                        asyncContext.complete();
                    }
                });
            }
            baseRequest.setHandled(true);
            super.handle(target, baseRequest, request, response);
        }
    }

    private class DoesNotSetHandledHandler
    extends AbstractHttpTest.ThrowExceptionOnDemandHandler {
        private final boolean dispatch;
        private final boolean inWait;

        private DoesNotSetHandledHandler(boolean throwException, boolean dispatch, boolean inWait) {
            super(HttpManyWaysToAsyncCommitTest.this, throwException);
            this.dispatch = dispatch;
            this.inWait = inWait;
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if (request.getAttribute(HttpManyWaysToAsyncCommitTest.this.contextAttribute) == null) {
                AsyncContext asyncContext = baseRequest.startAsync();
                request.setAttribute(HttpManyWaysToAsyncCommitTest.this.contextAttribute, (Object)asyncContext);
                HttpManyWaysToAsyncCommitTest.this.runAsync(baseRequest, this.inWait, () -> {
                    if (this.dispatch) {
                        asyncContext.dispatch();
                    } else {
                        asyncContext.complete();
                    }
                });
            }
            super.handle(target, baseRequest, request, response);
        }
    }
}

