/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpTester;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class HttpChannelEventTest {
    private Server server;
    private LocalConnector connector;

    public void start(Handler handler) throws Exception {
        this.server = new Server();
        this.connector = new LocalConnector(this.server);
        this.server.addConnector((Connector)this.connector);
        this.server.setHandler(handler);
        this.server.start();
    }

    @AfterEach
    public void dispose() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
    }

    @Test
    public void testRequestContentSlice() throws Exception {
        final int data = 120;
        final CountDownLatch applicationLatch = new CountDownLatch(1);
        this.start((Handler)new TestHandler(){

            @Override
            protected void handle(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                ServletInputStream input = request.getInputStream();
                int content = input.read();
                Assertions.assertEquals((int)data, (int)content);
                applicationLatch.countDown();
            }
        });
        final CountDownLatch listenerLatch = new CountDownLatch(1);
        this.connector.addBean((Object)new HttpChannel.Listener(){

            public void onRequestContent(Request request, ByteBuffer content) {
                content.position(content.limit());
                listenerLatch.countDown();
            }
        });
        HttpTester.Request request = HttpTester.newRequest();
        request.setHeader("Host", "localhost");
        request.setContent(new byte[]{(byte)data});
        ByteBuffer buffer = this.connector.getResponse(request.generate(), 5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)listenerLatch.await(5L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)applicationLatch.await(5L, TimeUnit.SECONDS));
        HttpTester.Response response = HttpTester.parseResponse((ByteBuffer)buffer);
        Assertions.assertEquals((int)200, (int)response.getStatus());
    }

    @Test
    public void testResponseContentSlice() throws Exception {
        final byte[] data = new byte[]{121};
        this.start((Handler)new TestHandler(){

            @Override
            protected void handle(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                response.getOutputStream().write(data);
            }
        });
        final CountDownLatch latch = new CountDownLatch(1);
        this.connector.addBean((Object)new HttpChannel.Listener(){

            public void onResponseContent(Request request, ByteBuffer content) {
                Assertions.assertTrue((boolean)content.hasRemaining());
                latch.countDown();
            }
        });
        HttpTester.Request request = HttpTester.newRequest();
        request.setHeader("Host", "localhost");
        HttpTester.Response response = HttpTester.parseResponse((String)this.connector.getResponse(request.toString(), 5L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertArrayEquals((byte[])data, (byte[])response.getContentBytes());
    }

    @Test
    public void testRequestFailure() throws Exception {
        this.start((Handler)new TestHandler());
        final CountDownLatch latch = new CountDownLatch(2);
        this.connector.addBean((Object)new HttpChannel.Listener(){

            public void onRequestFailure(Request request, Throwable failure) {
                latch.countDown();
            }

            public void onComplete(Request request) {
                latch.countDown();
            }
        });
        String request = HttpTester.newRequest().toString();
        HttpTester.Response response = HttpTester.parseResponse((String)this.connector.getResponse(request, 5L, TimeUnit.SECONDS));
        Assertions.assertEquals((int)400, (int)response.getStatus());
        Assertions.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
    }

    @Test
    public void testResponseBeginModifyHeaders() throws Exception {
        this.start((Handler)new TestHandler(){

            @Override
            protected void handle(HttpServletRequest request, HttpServletResponse response) {
                response.setCharacterEncoding("utf-8");
                response.setContentType("text/plain");
                response.addHeader("X-Header", "foo");
                response.addHeader("X-Header", "bar");
            }
        });
        final CountDownLatch latch = new CountDownLatch(1);
        this.connector.addBean((Object)new HttpChannel.Listener(){

            public void onResponseBegin(Request request) {
                Response response = request.getResponse();
                response.getHttpFields().computeField("X-Header", (n, f) -> new HttpField(n, "zed"));
            }

            public void onComplete(Request request) {
                latch.countDown();
            }
        });
        HttpTester.Request request = HttpTester.newRequest();
        request.setVersion(HttpVersion.HTTP_1_1);
        request.setHeader("Host", "localhost");
        request.setHeader("Connection", "close");
        HttpTester.Response response = HttpTester.parseResponse((String)this.connector.getResponse(request.toString(), 5L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        List xheaders = response.getFields("X-Header");
        MatcherAssert.assertThat((String)"X-Header count", (Object)xheaders.size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((String)"X-Header[0].value", (Object)((HttpField)xheaders.get(0)).getValue(), (Matcher)Matchers.is((Object)"zed"));
    }

    @Test
    public void testResponseFailure() throws Exception {
        this.start((Handler)new TestHandler(){

            @Override
            protected void handle(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                HttpChannelEventTest.this.connector.getConnectedEndPoints().forEach(EndPoint::close);
            }
        });
        final CountDownLatch latch = new CountDownLatch(2);
        this.connector.addBean((Object)new HttpChannel.Listener(){

            public void onResponseFailure(Request request, Throwable failure) {
                latch.countDown();
            }

            public void onComplete(Request request) {
                latch.countDown();
            }
        });
        HttpTester.Request request = HttpTester.newRequest();
        request.setHeader("Host", "localhost");
        HttpTester.parseResponse((String)this.connector.getResponse(request.toString(), 5L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
    }

    @Test
    public void testExchangeTimeRecording() throws Exception {
        this.start((Handler)new TestHandler());
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicLong elapsed = new AtomicLong();
        this.connector.addBean((Object)new HttpChannel.Listener(){
            private final String attribute = this.getClass().getName() + ".begin";

            public void onRequestBegin(Request request) {
                request.setAttribute(this.attribute, (Object)System.nanoTime());
            }

            public void onComplete(Request request) {
                long endTime = System.nanoTime();
                long beginTime = (Long)request.getAttribute(this.attribute);
                elapsed.set(endTime - beginTime);
                latch.countDown();
            }
        });
        HttpTester.Request request = HttpTester.newRequest();
        request.setHeader("Host", "localhost");
        HttpTester.Response response = HttpTester.parseResponse((String)this.connector.getResponse(request.toString(), 5L, TimeUnit.SECONDS));
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        MatcherAssert.assertThat((Object)elapsed.get(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
    }

    @Test
    public void testTransientListener() throws Exception {
        this.start((Handler)new TestHandler());
        final CountDownLatch latch = new CountDownLatch(1);
        this.connector.addBean((Object)new HttpChannel.TransientListeners());
        this.connector.addBean((Object)new HttpChannel.Listener(){

            public void onRequestBegin(Request request) {
                request.getHttpChannel().addListener(new HttpChannel.Listener(){

                    public void onComplete(Request request) {
                        latch.countDown();
                    }
                });
            }
        });
        HttpTester.Request request = HttpTester.newRequest();
        request.setHeader("Host", "localhost");
        HttpTester.Response response = HttpTester.parseResponse((String)this.connector.getResponse(request.toString(), 5L, TimeUnit.SECONDS));
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
    }

    private static class TestHandler
    extends AbstractHandler {
        private TestHandler() {
        }

        public final void handle(String target, Request jettyRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            jettyRequest.setHandled(true);
            this.handle(request, response);
        }

        protected void handle(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        }
    }
}

