/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpTester;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.ForwardedRequestCustomizer;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class ForwardedRequestCustomizerTest {
    private Server server;
    private RequestHandler handler;
    private LocalConnector connector;
    private LocalConnector connectorAlt;
    private LocalConnector connectorConfigured;
    private ForwardedRequestCustomizer customizer;
    private ForwardedRequestCustomizer customizerAlt;
    private ForwardedRequestCustomizer customizerConfigured;
    private Actual actual;

    @BeforeEach
    public void init() throws Exception {
        this.server = new Server();
        HttpConnectionFactory http = new HttpConnectionFactory();
        http.getHttpConfiguration().setSecurePort(443);
        this.customizer = new ForwardedRequestCustomizer();
        http.getHttpConfiguration().addCustomizer((HttpConfiguration.Customizer)this.customizer);
        this.connector = new LocalConnector(this.server, (ConnectionFactory)http);
        this.server.addConnector((Connector)this.connector);
        HttpConnectionFactory httpAlt = new HttpConnectionFactory();
        httpAlt.getHttpConfiguration().setSecurePort(8443);
        this.customizerAlt = new ForwardedRequestCustomizer();
        httpAlt.getHttpConfiguration().addCustomizer((HttpConfiguration.Customizer)this.customizerAlt);
        this.connectorAlt = new LocalConnector(this.server, (ConnectionFactory)httpAlt);
        this.server.addConnector((Connector)this.connectorAlt);
        http = new HttpConnectionFactory();
        this.customizerConfigured = new ForwardedRequestCustomizer();
        this.customizerConfigured.setForwardedHeader("Jetty-Forwarded");
        this.customizerConfigured.setForwardedHostHeader("Jetty-Forwarded-Host");
        this.customizerConfigured.setForwardedServerHeader("Jetty-Forwarded-Server");
        this.customizerConfigured.setForwardedProtoHeader("Jetty-Forwarded-Proto");
        this.customizerConfigured.setForwardedForHeader("Jetty-Forwarded-For");
        this.customizerConfigured.setForwardedPortHeader("Jetty-Forwarded-Port");
        this.customizerConfigured.setForwardedHttpsHeader("Jetty-Proxied-Https");
        this.customizerConfigured.setForwardedCipherSuiteHeader("Jetty-Proxy-Auth-Cert");
        this.customizerConfigured.setForwardedSslSessionIdHeader("Jetty-Proxy-Ssl-Id");
        http.getHttpConfiguration().addCustomizer((HttpConfiguration.Customizer)this.customizerConfigured);
        this.connectorConfigured = new LocalConnector(this.server, (ConnectionFactory)http);
        this.server.addConnector((Connector)this.connectorConfigured);
        this.handler = new RequestHandler();
        this.server.setHandler((Handler)this.handler);
        this.handler.requestTester = (request, response) -> {
            this.actual = new Actual();
            this.actual.wasSecure.set(request.isSecure());
            this.actual.sslSession.set(String.valueOf(request.getAttribute("javax.servlet.request.ssl_session_id")));
            this.actual.sslCertificate.set(String.valueOf(request.getAttribute("javax.servlet.request.cipher_suite")));
            this.actual.scheme.set(request.getScheme());
            this.actual.serverName.set(request.getServerName());
            this.actual.serverPort.set(request.getServerPort());
            this.actual.remoteAddr.set(request.getRemoteAddr());
            this.actual.remotePort.set(request.getRemotePort());
            this.actual.requestURL.set(request.getRequestURL().toString());
            return true;
        };
        this.server.start();
    }

    @AfterEach
    public void destroy() throws Exception {
        this.server.stop();
    }

    public static Stream<Arguments> cases() {
        return Stream.of(Arguments.of((Object[])new Object[]{new Request("HTTP/1.0 - no Host header").headers("GET /example HTTP/1.0"), new Expectations().scheme("http").serverName("0.0.0.0").serverPort(80).secure(false).requestURL("http://0.0.0.0/example")}), Arguments.of((Object[])new Object[]{new Request("HTTP/1.0 - Empty Host header").headers("GET /example HTTP/1.0", "Host:"), new Expectations().scheme("http").serverName("0.0.0.0").serverPort(80).secure(false).requestURL("http://0.0.0.0/example")}), Arguments.of((Object[])new Object[]{new Request("HTTP/1.0 - No Host header, with X-Forwarded-Host").headers("GET /example HTTP/1.0", "X-Forwarded-Host: alt.example.net:7070"), new Expectations().scheme("http").serverName("alt.example.net").serverPort(7070).secure(false).requestURL("http://alt.example.net:7070/example")}), Arguments.of((Object[])new Object[]{new Request("HTTP/1.0 - Empty Host header, with X-Forwarded-Host").headers("GET /example HTTP/1.0", "Host:", "X-Forwarded-Host: alt.example.net:7070"), new Expectations().scheme("http").serverName("alt.example.net").serverPort(7070).secure(false).requestURL("http://alt.example.net:7070/example")}), Arguments.of((Object[])new Object[]{new Request("IPv4 Host Only").headers("GET / HTTP/1.1", "Host: 1.2.3.4:2222"), new Expectations().scheme("http").serverName("1.2.3.4").serverPort(2222).secure(false).requestURL("http://1.2.3.4:2222/")}), Arguments.of((Object[])new Object[]{new Request("IPv6 Host Only").headers("GET / HTTP/1.1", "Host: [::1]:2222"), new Expectations().scheme("http").serverName("[::1]").serverPort(2222).secure(false).requestURL("http://[::1]:2222/")}), Arguments.of((Object[])new Object[]{new Request("IPv4 in Request Line").headers("GET https://1.2.3.4:2222/ HTTP/1.1", "Host: wrong"), new Expectations().scheme("https").serverName("1.2.3.4").serverPort(2222).secure(true).requestURL("https://1.2.3.4:2222/")}), Arguments.of((Object[])new Object[]{new Request("IPv6 in Request Line").headers("GET http://[::1]:2222/ HTTP/1.1", "Host: wrong"), new Expectations().scheme("http").serverName("[::1]").serverPort(2222).secure(false).requestURL("http://[::1]:2222/")}), Arguments.of((Object[])new Object[]{new Request("RFC7239 Examples: Section 4").headers("GET / HTTP/1.1", "Host: myhost", "Forwarded: for=\"_gazonk\"", "Forwarded: For=\"[2001:db8:cafe::17]:4711\"", "Forwarded: for=192.0.2.60;proto=http;by=203.0.113.43", "Forwarded: for=192.0.2.43, for=198.51.100.17"), new Expectations().scheme("http").serverName("myhost").serverPort(80).secure(false).requestURL("http://myhost/").remoteAddr("[2001:db8:cafe::17]").remotePort(4711)}), Arguments.of((Object[])new Object[]{new Request("RFC7239 Examples: Section 7").headers("GET / HTTP/1.1", "Host: myhost", "Forwarded: for=192.0.2.43,for=\"[2001:db8:cafe::17]\",for=unknown"), new Expectations().scheme("http").serverName("myhost").serverPort(80).secure(false).requestURL("http://myhost/").remoteAddr("192.0.2.43").remotePort(0)}), Arguments.of((Object[])new Object[]{new Request("RFC7239 Examples: Section 7 (spaced)").headers("GET / HTTP/1.1", "Host: myhost", "Forwarded: for=192.0.2.43, for=\"[2001:db8:cafe::17]\", for=unknown"), new Expectations().scheme("http").serverName("myhost").serverPort(80).secure(false).requestURL("http://myhost/").remoteAddr("192.0.2.43").remotePort(0)}), Arguments.of((Object[])new Object[]{new Request("RFC7239 Examples: Section 7 (multi header)").headers("GET / HTTP/1.1", "Host: myhost", "Forwarded: for=192.0.2.43", "Forwarded: for=\"[2001:db8:cafe::17]\", for=unknown"), new Expectations().scheme("http").serverName("myhost").serverPort(80).secure(false).requestURL("http://myhost/").remoteAddr("192.0.2.43").remotePort(0)}), Arguments.of((Object[])new Object[]{new Request("RFC7239 Examples: Section 7.4 (old syntax)").headers("GET / HTTP/1.1", "Host: myhost", "X-Forwarded-For: 192.0.2.43, 2001:db8:cafe::17"), new Expectations().scheme("http").serverName("myhost").serverPort(80).secure(false).requestURL("http://myhost/").remoteAddr("192.0.2.43").remotePort(0)}), Arguments.of((Object[])new Object[]{new Request("RFC7239 Examples: Section 7.4 (new syntax)").headers("GET / HTTP/1.1", "Host: myhost", "Forwarded: for=192.0.2.43, for=\"[2001:db8:cafe::17]\""), new Expectations().scheme("http").serverName("myhost").serverPort(80).secure(false).requestURL("http://myhost/").remoteAddr("192.0.2.43").remotePort(0)}), Arguments.of((Object[])new Object[]{new Request("RFC7239 Examples: Section 7.5").headers("GET / HTTP/1.1", "Host: myhost", "Forwarded: for=192.0.2.43,for=198.51.100.17;by=203.0.113.60;proto=http;host=example.com"), new Expectations().scheme("http").serverName("example.com").serverPort(80).secure(false).requestURL("http://example.com/").remoteAddr("192.0.2.43").remotePort(0)}), Arguments.of((Object[])new Object[]{new Request("RFC7239: Forwarded proto only").headers("GET / HTTP/1.1", "Host: myhost", "Forwarded: proto=https"), new Expectations().scheme("https").serverName("myhost").serverPort(443).secure(true).requestURL("https://myhost/")}), Arguments.of((Object[])new Object[]{new Request("ProxyPass (example.com:80 to localhost:8080)").headers("GET / HTTP/1.1", "Host: localhost:8080", "X-Forwarded-For: 10.20.30.40", "X-Forwarded-Host: example.com"), new Expectations().scheme("http").serverName("example.com").serverPort(80).secure(false).remoteAddr("10.20.30.40").requestURL("http://example.com/")}), Arguments.of((Object[])new Object[]{new Request("ProxyPass (example.com:81 to localhost:8080)").headers("GET / HTTP/1.1", "Host: localhost:8080", "X-Forwarded-For: 10.20.30.40", "X-Forwarded-Host: example.com:81", "X-Forwarded-Server: example.com", "X-Forwarded-Proto: https"), new Expectations().scheme("https").serverName("example.com").serverPort(81).secure(true).remoteAddr("10.20.30.40").requestURL("https://example.com:81/")}), Arguments.of((Object[])new Object[]{new Request("ProxyPass (example.com:443 to localhost:8443)").headers("GET / HTTP/1.1", "Host: localhost:8443", "X-Forwarded-Host: example.com", "X-Forwarded-Proto: https"), new Expectations().scheme("https").serverName("example.com").serverPort(443).secure(true).requestURL("https://example.com/")}), Arguments.of((Object[])new Object[]{new Request("ProxyPass (IPv6 from [::1]:80 to localhost:8080)").headers("GET / HTTP/1.1", "Host: localhost:8080", "X-Forwarded-For: 10.20.30.40", "X-Forwarded-Host: [::1]"), new Expectations().scheme("http").serverName("[::1]").serverPort(80).secure(false).remoteAddr("10.20.30.40").requestURL("http://[::1]/")}), Arguments.of((Object[])new Object[]{new Request("ProxyPass (IPv6 from [::1]:8888 to localhost:8080)").headers("GET / HTTP/1.1", "Host: localhost:8080", "X-Forwarded-For: 10.20.30.40", "X-Forwarded-Host: [::1]:8888"), new Expectations().scheme("http").serverName("[::1]").serverPort(8888).secure(false).remoteAddr("10.20.30.40").requestURL("http://[::1]:8888/")}), Arguments.of((Object[])new Object[]{new Request("Multiple ProxyPass (example.com:80 to rp.example.com:82 to localhost:8080)").headers("GET / HTTP/1.1", "Host: localhost:8080", "X-Forwarded-For: 10.20.30.40, 10.0.0.1", "X-Forwarded-Host: example.com, rp.example.com:82", "X-Forwarded-Server: example.com, rp.example.com", "X-Forwarded-Proto: https, http"), new Expectations().scheme("https").serverName("example.com").serverPort(443).secure(true).remoteAddr("10.20.30.40").requestURL("https://example.com/")}), Arguments.of((Object[])new Object[]{new Request("X-Forwarded-Proto (old syntax)").headers("GET / HTTP/1.1", "Host: myhost", "X-Forwarded-Proto: https"), new Expectations().scheme("https").serverName("myhost").serverPort(443).secure(true).requestURL("https://myhost/")}), Arguments.of((Object[])new Object[]{new Request("X-Forwarded-For (multiple headers)").headers("GET / HTTP/1.1", "Host: myhost", "X-Forwarded-For: 10.9.8.7,6.5.4.3", "X-Forwarded-For: 8.9.8.7,7.5.4.3"), new Expectations().scheme("http").serverName("myhost").serverPort(80).secure(false).requestURL("http://myhost/").remoteAddr("10.9.8.7").remotePort(0)}), Arguments.of((Object[])new Object[]{new Request("X-Forwarded-For (IPv4 with port)").headers("GET / HTTP/1.1", "Host: myhost", "X-Forwarded-For: 10.9.8.7:1111,6.5.4.3:2222"), new Expectations().scheme("http").serverName("myhost").serverPort(80).secure(false).requestURL("http://myhost/").remoteAddr("10.9.8.7").remotePort(1111)}), Arguments.of((Object[])new Object[]{new Request("X-Forwarded-For (IPv6 without port)").headers("GET / HTTP/1.1", "Host: myhost", "X-Forwarded-For: 2001:db8:cafe::17"), new Expectations().scheme("http").serverName("myhost").serverPort(80).secure(false).requestURL("http://myhost/").remoteAddr("[2001:db8:cafe::17]").remotePort(0)}), Arguments.of((Object[])new Object[]{new Request("X-Forwarded-For (IPv6 with port)").headers("GET / HTTP/1.1", "Host: myhost", "X-Forwarded-For: [2001:db8:cafe::17]:1111,6.5.4.3:2222"), new Expectations().scheme("http").serverName("myhost").serverPort(80).secure(false).requestURL("http://myhost/").remoteAddr("[2001:db8:cafe::17]").remotePort(1111)}), Arguments.of((Object[])new Object[]{new Request("X-Forwarded-For and X-Forwarded-Port (once)").headers("GET / HTTP/1.1", "Host: myhost", "X-Forwarded-For: 1:2:3:4:5:6:7:8", "X-Forwarded-Port: 2222"), new Expectations().scheme("http").serverName("myhost").serverPort(2222).secure(false).requestURL("http://myhost:2222/").remoteAddr("[1:2:3:4:5:6:7:8]").remotePort(0)}), Arguments.of((Object[])new Object[]{new Request("X-Forwarded-For and X-Forwarded-Port (multiple times)").headers("GET / HTTP/1.1", "Host: myhost", "X-Forwarded-Port: 2222", "X-Forwarded-For: 1:2:3:4:5:6:7:8", "X-Forwarded-For: 7:7:7:7:7:7:7:7", "X-Forwarded-Port: 3333"), new Expectations().scheme("http").serverName("myhost").serverPort(2222).secure(false).requestURL("http://myhost:2222/").remoteAddr("[1:2:3:4:5:6:7:8]").remotePort(0)}), Arguments.of((Object[])new Object[]{new Request("X-Forwarded-For and X-Forwarded-Port (multiple times combined)").headers("GET / HTTP/1.1", "Host: myhost", "X-Forwarded-Port: 2222, 3333", "X-Forwarded-For: 1:2:3:4:5:6:7:8, 7:7:7:7:7:7:7:7"), new Expectations().scheme("http").serverName("myhost").serverPort(2222).secure(false).requestURL("http://myhost:2222/").remoteAddr("[1:2:3:4:5:6:7:8]").remotePort(0)}), Arguments.of((Object[])new Object[]{new Request("X-Forwarded-Port").headers("GET / HTTP/1.1", "Host: myhost", "X-Forwarded-Port: 4444", "X-Forwarded-For: 192.168.1.200"), new Expectations().scheme("http").serverName("myhost").serverPort(4444).secure(false).requestURL("http://myhost:4444/").remoteAddr("192.168.1.200").remotePort(0)}), Arguments.of((Object[])new Object[]{new Request("X-Forwarded-Port (ForwardedPortAsAuthority==false)").configureCustomizer(customizer -> customizer.setForwardedPortAsAuthority(false)).headers("GET / HTTP/1.1", "Host: myhost", "X-Forwarded-Port: 4444", "X-Forwarded-For: 192.168.1.200"), new Expectations().scheme("http").serverName("myhost").serverPort(80).secure(false).requestURL("http://myhost/").remoteAddr("192.168.1.200").remotePort(4444)}), Arguments.of((Object[])new Object[]{new Request("X-Forwarded-Port for Late Host header").headers("GET / HTTP/1.1", "X-Forwarded-Port: 4444", "X-Forwarded-For: 192.168.1.200", "Host: myhost"), new Expectations().scheme("http").serverName("myhost").serverPort(4444).secure(false).requestURL("http://myhost:4444/").remoteAddr("192.168.1.200").remotePort(0)}), Arguments.of((Object[])new Object[]{new Request("X-Forwarded-* (all headers except server)").headers("GET / HTTP/1.1", "Host: myhost", "X-Forwarded-Proto: https", "X-Forwarded-Host: www.example.com", "X-Forwarded-Port: 4333", "X-Forwarded-For: 8.5.4.3:2222"), new Expectations().scheme("https").serverName("www.example.com").serverPort(4333).secure(true).requestURL("https://www.example.com:4333/").remoteAddr("8.5.4.3").remotePort(2222)}), Arguments.of((Object[])new Object[]{new Request("X-Forwarded-* (all headers except server, port first)").headers("GET / HTTP/1.1", "Host: myhost", "X-Forwarded-Proto: https", "X-Forwarded-Port: 4333", "X-Forwarded-Host: www.example.com", "X-Forwarded-For: 8.5.4.3:2222"), new Expectations().scheme("https").serverName("www.example.com").serverPort(4333).secure(true).requestURL("https://www.example.com:4333/").remoteAddr("8.5.4.3").remotePort(2222)}), Arguments.of((Object[])new Object[]{new Request("X-Forwarded-* (all headers)").headers("GET / HTTP/1.1", "Host: myhost", "X-Forwarded-Proto: https", "X-Forwarded-Host: www.example.com", "X-Forwarded-Port: 4333", "X-Forwarded-For: 8.5.4.3:2222", "X-Forwarded-Server: fw.example.com"), new Expectations().scheme("https").serverName("www.example.com").serverPort(4333).secure(true).requestURL("https://www.example.com:4333/").remoteAddr("8.5.4.3").remotePort(2222)}), Arguments.of((Object[])new Object[]{new Request("X-Forwarded-* (Server before Host)").headers("GET / HTTP/1.1", "Host: myhost", "X-Forwarded-Proto: https", "X-Forwarded-Server: fw.example.com", "X-Forwarded-Host: www.example.com", "X-Forwarded-Port: 4333", "X-Forwarded-For: 8.5.4.3:2222"), new Expectations().scheme("https").serverName("www.example.com").serverPort(4333).secure(true).requestURL("https://www.example.com:4333/").remoteAddr("8.5.4.3").remotePort(2222)}), Arguments.of((Object[])new Object[]{new Request("X-Forwarded-* (all headers reversed)").headers("GET / HTTP/1.1", "Host: myhost", "X-Forwarded-Server: fw.example.com", "X-Forwarded-For: 8.5.4.3:2222", "X-Forwarded-Port: 4333", "X-Forwarded-Host: www.example.com", "X-Forwarded-Proto: https"), new Expectations().scheme("https").serverName("www.example.com").serverPort(4333).secure(true).requestURL("https://www.example.com:4333/").remoteAddr("8.5.4.3").remotePort(2222)}), Arguments.of((Object[])new Object[]{new Request("X-Forwarded-* (Server and Port)").headers("GET / HTTP/1.1", "Host: myhost", "X-Forwarded-Server: fw.example.com", "X-Forwarded-Port: 4333", "X-Forwarded-For: 8.5.4.3:2222"), new Expectations().scheme("http").serverName("fw.example.com").serverPort(4333).secure(false).requestURL("http://fw.example.com:4333/").remoteAddr("8.5.4.3").remotePort(2222)}), Arguments.of((Object[])new Object[]{new Request("X-Forwarded-* (Port and Server)").headers("GET / HTTP/1.1", "Host: myhost", "X-Forwarded-Port: 4333", "X-Forwarded-For: 8.5.4.3:2222", "X-Forwarded-Server: fw.example.com"), new Expectations().scheme("http").serverName("fw.example.com").serverPort(4333).secure(false).requestURL("http://fw.example.com:4333/").remoteAddr("8.5.4.3").remotePort(2222)}), Arguments.of((Object[])new Object[]{new Request("X-Forwarded-* (Multiple Ports)").headers("GET / HTTP/1.1", "Host: myhost:10001", "X-Forwarded-For: 127.0.0.1:8888,127.0.0.2:9999", "X-Forwarded-Port: 10002", "X-Forwarded-Proto: https", "X-Forwarded-Host: sub1.example.com:10003", "X-Forwarded-Server: sub2.example.com"), new Expectations().scheme("https").serverName("sub1.example.com").serverPort(10003).secure(true).requestURL("https://sub1.example.com:10003/").remoteAddr("127.0.0.1").remotePort(8888)}), Arguments.of((Object[])new Object[]{new Request("X-Forwarded-* (Multiple Ports - Server First)").headers("GET / HTTP/1.1", "X-Forwarded-Server: sub2.example.com:10007", "Host: myhost:10001", "X-Forwarded-For: 127.0.0.1:8888,127.0.0.2:9999", "X-Forwarded-Proto: https", "X-Forwarded-Port: 10002", "X-Forwarded-Host: sub1.example.com:10003"), new Expectations().scheme("https").serverName("sub1.example.com").serverPort(10003).secure(true).requestURL("https://sub1.example.com:10003/").remoteAddr("127.0.0.1").remotePort(8888)}), Arguments.of((Object[])new Object[]{new Request("X-Forwarded-* (Multiple Ports - setForwardedPortAsAuthority = false)").configureCustomizer(customizer -> customizer.setForwardedPortAsAuthority(false)).headers("GET / HTTP/1.1", "Host: myhost:10001", "X-Forwarded-For: 127.0.0.1:8888,127.0.0.2:9999", "X-Forwarded-Port: 10002", "X-Forwarded-Proto: https", "X-Forwarded-Host: sub1.example.com:10003", "X-Forwarded-Server: sub2.example.com"), new Expectations().scheme("https").serverName("sub1.example.com").serverPort(10003).secure(true).requestURL("https://sub1.example.com:10003/").remoteAddr("127.0.0.1").remotePort(8888)}), Arguments.of((Object[])new Object[]{new Request("X-Forwarded-* (Multiple Ports Alt Order)").headers("GET / HTTP/1.1", "Host: myhost:10001", "X-Forwarded-For: 127.0.0.1:8888,127.0.0.2:9999", "X-Forwarded-Proto: https", "X-Forwarded-Host: sub1.example.com:10003", "X-Forwarded-Port: 10002", "X-Forwarded-Server: sub2.example.com"), new Expectations().scheme("https").serverName("sub1.example.com").serverPort(10003).secure(true).requestURL("https://sub1.example.com:10003/").remoteAddr("127.0.0.1").remotePort(8888)}), Arguments.of((Object[])new Object[]{new Request("RFC7239 mixed with X-Forwarded-* headers").headers("GET / HTTP/1.1", "Host: myhost", "X-Forwarded-For: 11.9.8.7:1111,8.5.4.3:2222", "X-Forwarded-Port: 3333", "Forwarded: for=192.0.2.43,for=198.51.100.17;by=203.0.113.60;proto=http;host=example.com", "X-Forwarded-For: 11.9.8.7:1111,8.5.4.3:2222"), new Expectations().scheme("http").serverName("example.com").serverPort(80).secure(false).requestURL("http://example.com/").remoteAddr("192.0.2.43").remotePort(0)}), Arguments.of((Object[])new Object[]{new Request("RFC7239 - mixed with HTTP/1.0 - No Host header").headers("GET /example HTTP/1.0", "Forwarded: for=1.1.1.1:6060,proto=http;host=alt.example.net:7070"), new Expectations().scheme("http").serverName("alt.example.net").serverPort(7070).secure(false).requestURL("http://alt.example.net:7070/example").remoteAddr("1.1.1.1").remotePort(6060)}), Arguments.of((Object[])new Object[]{new Request("RFC7239 - mixed with HTTP/1.0 - Empty Host header").headers("GET /example HTTP/1.0", "Host:", "Forwarded: for=1.1.1.1:6060,proto=http;host=alt.example.net:7070"), new Expectations().scheme("http").serverName("alt.example.net").serverPort(7070).secure(false).requestURL("http://alt.example.net:7070/example").remoteAddr("1.1.1.1").remotePort(6060)}), Arguments.of((Object[])new Object[]{new Request("Forced Host (no port)").configureCustomizer(customizer -> customizer.setForcedHost("always.example.com")).headers("GET / HTTP/1.1", "Host: myhost", "X-Forwarded-For: 11.9.8.7:1111", "X-Forwarded-Host: example.com:2222"), new Expectations().scheme("http").serverName("always.example.com").serverPort(80).secure(false).requestURL("http://always.example.com/").remoteAddr("11.9.8.7").remotePort(1111)}), Arguments.of((Object[])new Object[]{new Request("Forced Host with port").configureCustomizer(customizer -> customizer.setForcedHost("always.example.com:9090")).headers("GET / HTTP/1.1", "Host: myhost", "X-Forwarded-For: 11.9.8.7:1111", "X-Forwarded-Host: example.com:2222"), new Expectations().scheme("http").serverName("always.example.com").serverPort(9090).secure(false).requestURL("http://always.example.com:9090/").remoteAddr("11.9.8.7").remotePort(1111)}), Arguments.of((Object[])new Object[]{new Request("X-Proxied-Https").headers("GET / HTTP/1.1", "Host: myhost", "X-Proxied-Https: on"), new Expectations().scheme("https").serverName("myhost").serverPort(443).secure(true).requestURL("https://myhost/").remoteAddr("0.0.0.0").remotePort(0)}), Arguments.of((Object[])new Object[]{new Request("Proxy-Ssl-Id (setSslIsSecure==false)").configureCustomizer(customizer -> customizer.setSslIsSecure(false)).headers("GET / HTTP/1.1", "Host: myhost", "Proxy-Ssl-Id: Wibble"), new Expectations().scheme("http").serverName("myhost").serverPort(80).secure(false).requestURL("http://myhost/").remoteAddr("0.0.0.0").remotePort(0).sslSession("Wibble")}), Arguments.of((Object[])new Object[]{new Request("Proxy-Ssl-Id (setSslIsSecure==true)").configureCustomizer(customizer -> customizer.setSslIsSecure(true)).headers("GET / HTTP/1.1", "Host: myhost", "Proxy-Ssl-Id: 0123456789abcdef"), new Expectations().scheme("https").serverName("myhost").serverPort(443).secure(true).requestURL("https://myhost/").remoteAddr("0.0.0.0").remotePort(0).sslSession("0123456789abcdef")}), Arguments.of((Object[])new Object[]{new Request("Proxy-Auth-Cert (setSslIsSecure==false)").configureCustomizer(customizer -> customizer.setSslIsSecure(false)).headers("GET / HTTP/1.1", "Host: myhost", "Proxy-auth-cert: Wibble"), new Expectations().scheme("http").serverName("myhost").serverPort(80).secure(false).requestURL("http://myhost/").remoteAddr("0.0.0.0").remotePort(0).sslCertificate("Wibble")}), Arguments.of((Object[])new Object[]{new Request("Proxy-Auth-Cert (setSslIsSecure==true)").configureCustomizer(customizer -> customizer.setSslIsSecure(true)).headers("GET / HTTP/1.1", "Host: myhost", "Proxy-auth-cert: 0123456789abcdef"), new Expectations().scheme("https").serverName("myhost").serverPort(443).secure(true).requestURL("https://myhost/").remoteAddr("0.0.0.0").remotePort(0).sslCertificate("0123456789abcdef")}), Arguments.of((Object[])new Object[]{new Request("No initial authority, X-Forwarded-Proto on http, Proxy-Ssl-Id exists (setSslIsSecure==true)").configureCustomizer(customizer -> customizer.setSslIsSecure(true)).headers("GET /foo HTTP/1.1", "Host: myhost", "X-Forwarded-Proto: http", "Proxy-Ssl-Id: Wibble"), new Expectations().scheme("http").serverName("myhost").serverPort(80).secure(true).requestURL("http://myhost/foo").remoteAddr("0.0.0.0").remotePort(0).sslSession("Wibble")}), Arguments.of((Object[])new Object[]{new Request("https initial authority, X-Forwarded-Proto on http, Proxy-Ssl-Id exists (setSslIsSecure==false)").configureCustomizer(customizer -> customizer.setSslIsSecure(false)).headers("GET https://alt.example.net/foo HTTP/1.1", "Host: myhost", "X-Forwarded-Proto: http", "Proxy-Ssl-Id: Wibble"), new Expectations().scheme("http").serverName("alt.example.net").serverPort(80).secure(false).requestURL("http://alt.example.net/foo").remoteAddr("0.0.0.0").remotePort(0).sslSession("Wibble")}), Arguments.of((Object[])new Object[]{new Request("No initial authority, X-Proxied-Https off, Proxy-Ssl-Id exists (setSslIsSecure==true)").configureCustomizer(customizer -> customizer.setSslIsSecure(true)).headers("GET /foo HTTP/1.1", "Host: myhost", "X-Proxied-Https: off", "Proxy-Ssl-Id: Wibble"), new Expectations().scheme("http").serverName("myhost").serverPort(80).secure(false).requestURL("http://myhost/foo").remoteAddr("0.0.0.0").remotePort(0).sslSession("Wibble")}), Arguments.of((Object[])new Object[]{new Request("Https initial authority, X-Proxied-Https off, Proxy-Ssl-Id exists (setSslIsSecure==true)").configureCustomizer(customizer -> customizer.setSslIsSecure(true)).headers("GET https://alt.example.net/foo HTTP/1.1", "Host: myhost", "X-Proxied-Https: off", "Proxy-Ssl-Id: Wibble"), new Expectations().scheme("http").serverName("alt.example.net").serverPort(80).secure(false).requestURL("http://alt.example.net/foo").remoteAddr("0.0.0.0").remotePort(0).sslSession("Wibble")}), Arguments.of((Object[])new Object[]{new Request("Https initial authority, X-Proxied-Https off, Proxy-Ssl-Id exists (setSslIsSecure==true) (alt order)").configureCustomizer(customizer -> customizer.setSslIsSecure(true)).headers("GET https://alt.example.net/foo HTTP/1.1", "Host: myhost", "Proxy-Ssl-Id: Wibble", "X-Proxied-Https: off"), new Expectations().scheme("http").serverName("alt.example.net").serverPort(80).secure(false).requestURL("http://alt.example.net/foo").remoteAddr("0.0.0.0").remotePort(0).sslSession("Wibble")}), Arguments.of((Object[])new Object[]{new Request("Http initial authority, X-Proxied-Https off, Proxy-Ssl-Id exists (setSslIsSecure==false)").configureCustomizer(customizer -> customizer.setSslIsSecure(false)).headers("GET https://alt.example.net/foo HTTP/1.1", "Host: myhost", "X-Proxied-Https: off", "Proxy-Ssl-Id: Wibble", "Proxy-auth-cert: 0123456789abcdef"), new Expectations().scheme("http").serverName("alt.example.net").serverPort(80).secure(false).requestURL("http://alt.example.net/foo").remoteAddr("0.0.0.0").remotePort(0).sslSession("Wibble").sslCertificate("0123456789abcdef")}), Arguments.of((Object[])new Object[]{new Request("Http initial authority, X-Proxied-Https off, Proxy-Ssl-Id exists (setSslIsSecure==false) (alt)").configureCustomizer(customizer -> customizer.setSslIsSecure(false)).headers("GET https://alt.example.net/foo HTTP/1.1", "Host: myhost", "Proxy-Ssl-Id: Wibble", "Proxy-auth-cert: 0123456789abcdef", "X-Proxied-Https: off"), new Expectations().scheme("http").serverName("alt.example.net").serverPort(80).secure(false).requestURL("http://alt.example.net/foo").remoteAddr("0.0.0.0").remotePort(0).sslSession("Wibble").sslCertificate("0123456789abcdef")}));
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"cases"})
    public void testDefaultBehavior(Request request, Expectations expectations) throws Exception {
        request.configure(this.customizer);
        String rawRequest = request.getRawRequest(header -> header);
        HttpTester.Response response = HttpTester.parseResponse((String)this.connector.getResponse(rawRequest));
        MatcherAssert.assertThat((String)"status", (Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        expectations.accept(this.actual);
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"cases"})
    public void testConfiguredBehavior(Request request, Expectations expectations) throws Exception {
        request.configure(this.customizerConfigured);
        String rawRequest = request.getRawRequest(header -> header.replaceFirst("X-Forwarded-", "Jetty-Forwarded-").replaceFirst("Forwarded:", "Jetty-Forwarded:").replaceFirst("X-Proxied-Https:", "Jetty-Proxied-Https:").replaceFirst("Proxy-Ssl-Id:", "Jetty-Proxy-Ssl-Id:").replaceFirst("Proxy-auth-cert:", "Jetty-Proxy-Auth-Cert:"));
        HttpTester.Response response = HttpTester.parseResponse((String)this.connectorConfigured.getResponse(rawRequest));
        MatcherAssert.assertThat((String)"status", (Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        expectations.accept(this.actual);
    }

    public static Stream<Arguments> nonStandardPortCases() {
        return Stream.of(Arguments.of((Object[])new Object[]{new Request("RFC7239 with https and h2").headers("GET /test/forwarded.jsp HTTP/1.1", "Host: web.example.net", "Forwarded: for=192.168.2.6;host=web.example.net;proto=https;proto-version=h2"), new Expectations().scheme("https").serverName("web.example.net").serverPort(443).requestURL("https://web.example.net/test/forwarded.jsp").remoteAddr("192.168.2.6").remotePort(0)}), Arguments.of((Object[])new Object[]{new Request("RFC7239 with proxy provided port on https and h2").headers("GET /test/forwarded.jsp HTTP/1.1", "Host: web.example.net:9443", "Forwarded: for=192.168.2.6;host=web.example.net:9443;proto=https;proto-version=h2"), new Expectations().scheme("https").serverName("web.example.net").serverPort(9443).requestURL("https://web.example.net:9443/test/forwarded.jsp").remoteAddr("192.168.2.6").remotePort(0)}), Arguments.of((Object[])new Object[]{new Request("RFC7239 with client provided host and different proxy provided port on https and h2").headers("GET /test/forwarded.jsp HTTP/1.1", "Host: web.example.net", "Forwarded: for=192.168.2.6;host=new.example.net:7443;proto=https;proto-version=h2"), new Expectations().scheme("https").serverName("new.example.net").serverPort(7443).requestURL("https://new.example.net:7443/test/forwarded.jsp").remoteAddr("192.168.2.6").remotePort(0)}));
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"nonStandardPortCases"})
    public void testNonStandardPortBehavior(Request request, Expectations expectations) throws Exception {
        request.configure(this.customizerAlt);
        String rawRequest = request.getRawRequest(header -> header);
        HttpTester.Response response = HttpTester.parseResponse((String)this.connectorAlt.getResponse(rawRequest));
        MatcherAssert.assertThat((String)"status", (Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        expectations.accept(this.actual);
    }

    public static Stream<Request> badRequestCases() {
        return Stream.of(new Request("Bad port value").headers("GET / HTTP/1.1", "Host: myhost", "X-Forwarded-Port: "), new Request("Invalid X-Proxied-Https value").headers("GET / HTTP/1.1", "Host: myhost", "X-Proxied-Https: foo"));
    }

    @ParameterizedTest
    @MethodSource(value={"badRequestCases"})
    public void testBadInput(Request request) throws Exception {
        request.configure(this.customizer);
        String rawRequest = request.getRawRequest(header -> header);
        HttpTester.Response response = HttpTester.parseResponse((String)this.connector.getResponse(rawRequest));
        MatcherAssert.assertThat((String)"status", (Object)response.getStatus(), (Matcher)Matchers.is((Object)400));
    }

    private class RequestHandler
    extends AbstractHandler {
        private RequestTester requestTester;

        private RequestHandler() {
        }

        public void handle(String target, org.eclipse.jetty.server.Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            if (this.requestTester != null && this.requestTester.check(request, response)) {
                response.setStatus(200);
            } else {
                response.sendError(500);
            }
        }
    }

    static interface RequestTester {
        public boolean check(HttpServletRequest var1, HttpServletResponse var2) throws IOException;
    }

    private static class Expectations
    implements Consumer<Actual> {
        String expectedScheme;
        String expectedServerName;
        int expectedServerPort;
        String expectedRequestURL;
        String expectedRemoteAddr = "0.0.0.0";
        int expectedRemotePort = 0;
        String expectedSslSession;
        String expectedSslCertificate;
        Boolean secure;

        private Expectations() {
        }

        @Override
        public void accept(Actual actual) {
            MatcherAssert.assertThat((String)"scheme", (Object)actual.scheme.get(), (Matcher)Matchers.is((Object)this.expectedScheme));
            if (this.secure != null && this.secure.booleanValue()) {
                Assertions.assertTrue((boolean)actual.wasSecure.get(), (String)"wasSecure");
            }
            MatcherAssert.assertThat((String)"serverName", (Object)actual.serverName.get(), (Matcher)Matchers.is((Object)this.expectedServerName));
            MatcherAssert.assertThat((String)"serverPort", (Object)actual.serverPort.get(), (Matcher)Matchers.is((Object)this.expectedServerPort));
            MatcherAssert.assertThat((String)"requestURL", (Object)actual.requestURL.get(), (Matcher)Matchers.is((Object)this.expectedRequestURL));
            if (this.expectedRemoteAddr != null) {
                MatcherAssert.assertThat((String)"remoteAddr", (Object)actual.remoteAddr.get(), (Matcher)Matchers.is((Object)this.expectedRemoteAddr));
                MatcherAssert.assertThat((String)"remotePort", (Object)actual.remotePort.get(), (Matcher)Matchers.is((Object)this.expectedRemotePort));
            }
            if (this.expectedSslSession != null) {
                MatcherAssert.assertThat((String)"sslSession", (Object)actual.sslSession.get(), (Matcher)Matchers.is((Object)this.expectedSslSession));
            }
            if (this.expectedSslCertificate != null) {
                MatcherAssert.assertThat((String)"sslCertificate", (Object)actual.sslCertificate.get(), (Matcher)Matchers.is((Object)this.expectedSslCertificate));
            }
        }

        public Expectations secure(boolean flag) {
            this.secure = flag;
            return this;
        }

        public Expectations scheme(String scheme) {
            this.expectedScheme = scheme;
            return this;
        }

        public Expectations serverName(String name) {
            this.expectedServerName = name;
            return this;
        }

        public Expectations serverPort(int port) {
            this.expectedServerPort = port;
            return this;
        }

        public Expectations requestURL(String requestURL) {
            this.expectedRequestURL = requestURL;
            return this;
        }

        public Expectations remoteAddr(String remoteAddr) {
            this.expectedRemoteAddr = remoteAddr;
            return this;
        }

        public Expectations remotePort(int remotePort) {
            this.expectedRemotePort = remotePort;
            return this;
        }

        public Expectations sslSession(String sslSession) {
            this.expectedSslSession = sslSession;
            return this;
        }

        public Expectations sslCertificate(String sslCertificate) {
            this.expectedSslCertificate = sslCertificate;
            return this;
        }
    }

    private static class Request {
        String description;
        String[] requestHeaders;
        Consumer<ForwardedRequestCustomizer> forwardedRequestCustomizerConsumer;

        public Request(String description) {
            this.description = description;
        }

        public Request headers(String ... headers) {
            this.requestHeaders = headers;
            return this;
        }

        public Request configureCustomizer(Consumer<ForwardedRequestCustomizer> forwardedRequestCustomizerConsumer) {
            this.forwardedRequestCustomizerConsumer = forwardedRequestCustomizerConsumer;
            return this;
        }

        public void configure(ForwardedRequestCustomizer customizer) {
            if (this.forwardedRequestCustomizerConsumer != null) {
                this.forwardedRequestCustomizerConsumer.accept(customizer);
            }
        }

        public String getRawRequest(Function<String, String> headerManip) {
            StringBuilder request = new StringBuilder();
            for (String header : this.requestHeaders) {
                request.append(headerManip.apply(header)).append('\n');
            }
            request.append('\n');
            return request.toString();
        }

        public String toString() {
            return this.description;
        }
    }

    private static class Actual {
        final AtomicReference<String> scheme = new AtomicReference();
        final AtomicBoolean wasSecure = new AtomicBoolean(false);
        final AtomicReference<String> serverName = new AtomicReference();
        final AtomicReference<Integer> serverPort = new AtomicReference();
        final AtomicReference<String> requestURL = new AtomicReference();
        final AtomicReference<String> remoteAddr = new AtomicReference();
        final AtomicReference<Integer> remotePort = new AtomicReference();
        final AtomicReference<String> sslSession = new AtomicReference();
        final AtomicReference<String> sslCertificate = new AtomicReference();

        private Actual() {
        }
    }
}

