/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.util.Arrays;
import java.util.List;
import javax.servlet.http.Cookie;
import org.eclipse.jetty.http.CookieCompliance;
import org.eclipse.jetty.server.CookieCutter;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class CookieCutterTest {
    private Cookie[] parseCookieHeaders(CookieCompliance compliance, String ... headers) {
        CookieCutter cutter = new CookieCutter(compliance);
        for (String header : headers) {
            cutter.addCookieField(header);
        }
        return cutter.getCookies();
    }

    private void assertCookie(String prefix, Cookie cookie, String expectedName, String expectedValue, int expectedVersion, String expectedPath) {
        MatcherAssert.assertThat((String)(prefix + ".name"), (Object)cookie.getName(), (Matcher)Matchers.is((Object)expectedName));
        MatcherAssert.assertThat((String)(prefix + ".value"), (Object)cookie.getValue(), (Matcher)Matchers.is((Object)expectedValue));
        MatcherAssert.assertThat((String)(prefix + ".version"), (Object)cookie.getVersion(), (Matcher)Matchers.is((Object)expectedVersion));
        MatcherAssert.assertThat((String)(prefix + ".path"), (Object)cookie.getPath(), (Matcher)Matchers.is((Object)expectedPath));
    }

    @Test
    public void testRFCSingle() {
        String rawCookie = "$Version=\"1\"; Customer=\"WILE_E_COYOTE\"; $Path=\"/acme\"";
        Cookie[] cookies = this.parseCookieHeaders(CookieCompliance.RFC2965, rawCookie);
        MatcherAssert.assertThat((String)"Cookies.length", (Object)cookies.length, (Matcher)Matchers.is((Object)1));
        this.assertCookie("Cookies[0]", cookies[0], "Customer", "WILE_E_COYOTE", 1, "/acme");
    }

    @Test
    public void testRFCSingleLenientNoSpaces() {
        String rawCookie = "$Version=\"1\";Customer=\"WILE_E_COYOTE\";$Path=\"/acme\"";
        Cookie[] cookies = this.parseCookieHeaders(CookieCompliance.RFC2965, rawCookie);
        MatcherAssert.assertThat((String)"Cookies.length", (Object)cookies.length, (Matcher)Matchers.is((Object)1));
        this.assertCookie("Cookies[0]", cookies[0], "Customer", "WILE_E_COYOTE", 1, "/acme");
    }

    @Test
    public void testRFCDouble() {
        String rawCookie = "$Version=\"1\"; Customer=\"WILE_E_COYOTE\"; $Path=\"/acme\"; Part_Number=\"Rocket_Launcher_0001\"; $Path=\"/acme\"";
        Cookie[] cookies = this.parseCookieHeaders(CookieCompliance.RFC2965, rawCookie);
        MatcherAssert.assertThat((String)"Cookies.length", (Object)cookies.length, (Matcher)Matchers.is((Object)2));
        this.assertCookie("Cookies[0]", cookies[0], "Customer", "WILE_E_COYOTE", 1, "/acme");
        this.assertCookie("Cookies[1]", cookies[1], "Part_Number", "Rocket_Launcher_0001", 1, "/acme");
    }

    @Test
    public void testRFCTriple() {
        String rawCookie = "$Version=\"1\"; Customer=\"WILE_E_COYOTE\"; $Path=\"/acme\"; Part_Number=\"Rocket_Launcher_0001\"; $Path=\"/acme\"; Shipping=\"FedEx\"; $Path=\"/acme\"";
        Cookie[] cookies = this.parseCookieHeaders(CookieCompliance.RFC2965, rawCookie);
        MatcherAssert.assertThat((String)"Cookies.length", (Object)cookies.length, (Matcher)Matchers.is((Object)3));
        this.assertCookie("Cookies[0]", cookies[0], "Customer", "WILE_E_COYOTE", 1, "/acme");
        this.assertCookie("Cookies[1]", cookies[1], "Part_Number", "Rocket_Launcher_0001", 1, "/acme");
        this.assertCookie("Cookies[2]", cookies[2], "Shipping", "FedEx", 1, "/acme");
    }

    @Test
    public void testRFCPathExample() {
        String rawCookie = "$Version=\"1\"; Part_Number=\"Riding_Rocket_0023\"; $Path=\"/acme/ammo\"; Part_Number=\"Rocket_Launcher_0001\"; $Path=\"/acme\"";
        Cookie[] cookies = this.parseCookieHeaders(CookieCompliance.RFC2965, rawCookie);
        MatcherAssert.assertThat((String)"Cookies.length", (Object)cookies.length, (Matcher)Matchers.is((Object)2));
        this.assertCookie("Cookies[0]", cookies[0], "Part_Number", "Riding_Rocket_0023", 1, "/acme/ammo");
        this.assertCookie("Cookies[1]", cookies[1], "Part_Number", "Rocket_Launcher_0001", 1, "/acme");
    }

    @Test
    public void testRFC2109CookieSpoofingExample() {
        String rawCookie = "$Version=\"1\"; session_id=\"1234\"; session_id=\"1111\"; $Domain=\".cracker.edu\"";
        Cookie[] cookies = this.parseCookieHeaders(CookieCompliance.RFC2965, rawCookie);
        MatcherAssert.assertThat((String)"Cookies.length", (Object)cookies.length, (Matcher)Matchers.is((Object)2));
        this.assertCookie("Cookies[0]", cookies[0], "session_id", "1234", 1, null);
        this.assertCookie("Cookies[1]", cookies[1], "session_id", "1111", 1, null);
    }

    @Test
    public void testRFC2965CookieSpoofingExample() {
        String rawCookie = "$Version=\"1\"; session_id=\"1234\", $Version=\"1\"; session_id=\"1111\"; $Domain=\".cracker.edu\"";
        Cookie[] cookies = this.parseCookieHeaders(CookieCompliance.RFC2965, rawCookie);
        MatcherAssert.assertThat((String)"Cookies.length", (Object)cookies.length, (Matcher)Matchers.is((Object)2));
        this.assertCookie("Cookies[0]", cookies[0], "session_id", "1234", 1, null);
        this.assertCookie("Cookies[1]", cookies[1], "session_id", "1111", 1, null);
        cookies = this.parseCookieHeaders(CookieCompliance.RFC6265, rawCookie);
        MatcherAssert.assertThat((String)"Cookies.length", (Object)cookies.length, (Matcher)Matchers.is((Object)1));
        this.assertCookie("Cookies[0]", cookies[0], "session_id", "1111", 0, null);
    }

    @Test
    public void testRFC6265SidExample() {
        String rawCookie = "SID=31d4d96e407aad42";
        Cookie[] cookies = this.parseCookieHeaders(CookieCompliance.RFC6265, rawCookie);
        MatcherAssert.assertThat((String)"Cookies.length", (Object)cookies.length, (Matcher)Matchers.is((Object)1));
        this.assertCookie("Cookies[0]", cookies[0], "SID", "31d4d96e407aad42", 0, null);
    }

    @Test
    public void testRFC6265SidLangExample() {
        String rawCookie = "SID=31d4d96e407aad42; lang=en-US";
        Cookie[] cookies = this.parseCookieHeaders(CookieCompliance.RFC6265, rawCookie);
        MatcherAssert.assertThat((String)"Cookies.length", (Object)cookies.length, (Matcher)Matchers.is((Object)2));
        this.assertCookie("Cookies[0]", cookies[0], "SID", "31d4d96e407aad42", 0, null);
        this.assertCookie("Cookies[1]", cookies[1], "lang", "en-US", 0, null);
    }

    @Test
    public void testRFC6265SidLangExampleLenient() {
        String rawCookie = "SID=31d4d96e407aad42;lang=en-US";
        Cookie[] cookies = this.parseCookieHeaders(CookieCompliance.RFC6265, rawCookie);
        MatcherAssert.assertThat((String)"Cookies.length", (Object)cookies.length, (Matcher)Matchers.is((Object)2));
        this.assertCookie("Cookies[0]", cookies[0], "SID", "31d4d96e407aad42", 0, null);
        this.assertCookie("Cookies[1]", cookies[1], "lang", "en-US", 0, null);
    }

    @Test
    public void testKeyValue() {
        String rawCookie = "key=value";
        Cookie[] cookies = this.parseCookieHeaders(CookieCompliance.RFC6265, rawCookie);
        MatcherAssert.assertThat((String)"Cookies.length", (Object)cookies.length, (Matcher)Matchers.is((Object)1));
        this.assertCookie("Cookies[0]", cookies[0], "key", "value", 0, null);
    }

    @Test
    public void testDollarName() {
        String rawCookie = "$key=value";
        Cookie[] cookies = this.parseCookieHeaders(CookieCompliance.RFC6265, rawCookie);
        MatcherAssert.assertThat((String)"Cookies.length", (Object)cookies.length, (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testMultipleCookies() {
        String rawCookie = "testcookie; server.id=abcd; server.detail=cfg";
        Cookie[] cookies = this.parseCookieHeaders(CookieCompliance.RFC6265, rawCookie);
        MatcherAssert.assertThat((String)"Cookies.length", (Object)cookies.length, (Matcher)Matchers.is((Object)2));
        this.assertCookie("Cookies[0]", cookies[0], "server.id", "abcd", 0, null);
        this.assertCookie("Cookies[1]", cookies[1], "server.detail", "cfg", 0, null);
    }

    @Test
    public void testExcessiveSemicolons() {
        char[] excessive = new char[65535];
        Arrays.fill(excessive, ';');
        String rawCookie = "foo=bar; " + new String(excessive) + "; xyz=pdq";
        Cookie[] cookies = this.parseCookieHeaders(CookieCompliance.RFC6265, rawCookie);
        MatcherAssert.assertThat((String)"Cookies.length", (Object)cookies.length, (Matcher)Matchers.is((Object)2));
        this.assertCookie("Cookies[0]", cookies[0], "foo", "bar", 0, null);
        this.assertCookie("Cookies[1]", cookies[1], "xyz", "pdq", 0, null);
    }

    @ParameterizedTest
    @MethodSource(value={"rfc6265Cookies"})
    public void testRFC6265CookieParsing(Param param) {
        Cookie[] cookies = this.parseCookieHeaders(CookieCompliance.RFC6265, param.input);
        MatcherAssert.assertThat((String)("Cookies.length (" + CookieCutterTest.dump(cookies) + ")"), (Object)cookies.length, (Matcher)Matchers.is((Object)param.expected.size()));
        for (int i = 0; i < cookies.length; ++i) {
            Cookie cookie = cookies[i];
            MatcherAssert.assertThat((String)("Cookies[" + i + "] (" + CookieCutterTest.dump(cookies) + ")"), (Object)(cookie.getName() + "=" + cookie.getValue()), (Matcher)Matchers.is((Object)((String)param.expected.get(i))));
        }
    }

    public static List<Param> rfc6265Cookies() {
        return Arrays.asList(new Param("A=1; B=2; C=3", "A=1", "B=2", "C=3"), new Param("A=\"1\"; B=2; C=3", "A=1", "B=2", "C=3"), new Param("A=\"1\"; B=\"2\"; C=\"3\"", "A=1", "B=2", "C=3"), new Param("A=1; B=2; C=\"3", "A=1", "B=2"), new Param("A=1 ; B=2; C=3", "A=1", "B=2", "C=3"), new Param("A= 1; B=2; C=3", "A=1", "B=2", "C=3"), new Param("A=\"1; B=2\"; C=3", "C=3"), new Param("A=\"1; B=2; C=3", new String[0]), new Param("A=\"1 B=2\"; C=3", "A=1 B=2", "C=3"), new Param("A=\"\"1; B=2; C=3", "B=2", "C=3"), new Param("A=\"\" ; B=2; C=3", "A=", "B=2", "C=3"), new Param("A=\"\"; B=2; C=3", "A=", "B=2", "C=3"), new Param("A=1\"\"; B=2; C=3", "B=2", "C=3"), new Param("A=1\"; B=2; C=3", "B=2", "C=3"), new Param("A=1\"1; B=2; C=3", "B=2", "C=3"), new Param("A=\" 1\"; B=2; C=3", "A= 1", "B=2", "C=3"), new Param("A=\"1 \"; B=2; C=3", "A=1 ", "B=2", "C=3"), new Param("A=\" 1 \"; B=2; C=3", "A= 1 ", "B=2", "C=3"), new Param("A=\" 1 1 \"; B=2; C=3", "A= 1 1 ", "B=2", "C=3"), new Param("A=1,; B=2; C=3", "B=2", "C=3"), new Param("A=\"1,\"; B=2; C=3", "B=2", "C=3"), new Param("A=\\1; B=2; C=3", "B=2", "C=3"), new Param("A=\"\\1\"; B=2; C=3", "B=2", "C=3"), new Param("A=1\u0007; B=2; C=3", "B=2", "C=3"), new Param("A=\"1\u0007\"; B=2; C=3", "B=2", "C=3"), new Param("\u20ac", new String[0]), new Param("@={}", new String[0]), new Param("$X=Y; N=V", "N=V"), new Param("N=V; $X=Y", "N=V"));
    }

    private static String dump(Cookie[] cookies) {
        StringBuilder sb = new StringBuilder();
        for (Cookie cookie : cookies) {
            sb.append("<").append(cookie.getName()).append(">=<").append(cookie.getValue()).append("> | ");
        }
        if (sb.length() > 0) {
            sb.delete(sb.length() - 2, sb.length() - 1);
        }
        return sb.toString();
    }

    private static class Param {
        private final String input;
        private final List<String> expected;

        public Param(String input, String ... expected) {
            this.input = input;
            this.expected = Arrays.asList(expected);
        }

        public String toString() {
            return this.input + " -> " + this.expected.toString();
        }
    }
}

