/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.test;

import java.util.List;
import org.junit.jupiter.api.Assertions;

public final class StringAssert {
    private StringAssert() {
    }

    public static void assertContains(String msg, String haystack, String needle) {
        Assertions.assertNotNull((Object)haystack, msg + ": haystack should not be null");
        Assertions.assertNotNull((Object)needle, msg + ": needle should not be null");
        int idx = haystack.indexOf(needle);
        if (idx == -1) {
            StringBuffer buf = new StringBuffer();
            buf.append(msg).append(": Unable to find \"").append(needle).append("\" in \"");
            buf.append(haystack).append('\"');
            System.err.println(buf);
            Assertions.fail(buf.toString());
        }
    }

    public static void assertContains(String msg, String haystack, String needle, int offset) {
        Assertions.assertNotNull((Object)haystack, msg + ": haystack should not be null");
        Assertions.assertNotNull((Object)needle, msg + ": needle should not be null");
        int idx = haystack.indexOf(needle, offset);
        if (idx == -1) {
            StringBuffer buf = new StringBuffer();
            buf.append(msg).append(": Unable to find \"").append(needle).append("\" in \"");
            buf.append(haystack.substring(offset)).append('\"');
            System.err.println(buf);
            Assertions.fail(buf.toString());
        }
    }

    public static void assertContainsSame(String msg, List<String> linesExpected, List<String> linesActual) {
        Assertions.assertEquals(linesExpected.size(), linesActual.size(), msg + " line count");
        for (String expected : linesExpected) {
            Assertions.assertTrue(linesActual.contains(expected), msg + ": expecting to see line <" + expected + ">");
        }
    }

    public static void assertNotContains(String msg, String haystack, String needle) {
        Assertions.assertNotNull((Object)haystack, msg + ": haystack should not be null");
        Assertions.assertNotNull((Object)needle, msg + ": needle should not be null");
        int idx = haystack.indexOf(needle);
        if (idx != -1) {
            StringBuffer buf = new StringBuffer();
            buf.append(msg).append(": Should not have found \"").append(needle).append("\" at offset ");
            buf.append(idx).append(" in \"").append(haystack).append('\"');
            System.err.println(buf);
            Assertions.fail(buf.toString());
        }
    }

    public static void assertNotContains(String msg, String haystack, String needle, int offset) {
        Assertions.assertNotNull((Object)haystack, msg + ": haystack should not be null");
        Assertions.assertNotNull((Object)needle, msg + ": needle should not be null");
        int idx = haystack.indexOf(needle, offset);
        if (idx != -1) {
            StringBuffer buf = new StringBuffer();
            buf.append(msg).append(": Should not have found \"").append(needle).append("\" at offset ");
            buf.append(idx).append(" in \"").append(haystack.substring(offset)).append('\"');
            System.err.println(buf);
            Assertions.fail(buf.toString());
        }
    }

    public static void assertStartsWith(String msg, String haystack, String expected) {
        Assertions.assertNotNull((Object)haystack, msg + ": haystack should not be null");
        Assertions.assertNotNull((Object)expected, msg + ": expected should not be null");
        if (!haystack.startsWith(expected)) {
            StringBuffer buf = new StringBuffer();
            buf.append(msg).append(": String \"");
            int len = Math.min(expected.length() + 4, haystack.length());
            buf.append(haystack.substring(0, len));
            buf.append("\" does not start with expected \"").append(expected).append('\"');
            System.err.println(buf);
            Assertions.fail(buf.toString());
        }
    }
}

