/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.test;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.eclipse.jetty.toolchain.test.FS;
import org.eclipse.jetty.toolchain.test.InMemoryCompiler;
import org.eclipse.jetty.toolchain.test.MavenTestingUtils;

public class MultiReleaseJarCreator {
    public static final String CODE_HELLO = "package hello;\npublic class Hello {\n  public static void main(String args[]) {\n    Greetings greetings = new Greetings();\n    System.out.println(greetings.get());\n  }\n}\n";
    public static final String CODE_GREETINGS_BASE = "package hello;\npublic class Greetings {\n  public String get() {\n    return \"Hello from zipfs base.\";\n  }\n}\n";
    public static final String CODE_GREETINGS_VER9 = "package hello;\npublic class Greetings {\n  public String get() {\n    return \"Hello from versions/9.\";\n  }\n}\n";
    public static final String CODE_GREETINGS_VER10 = "package hello;\npublic class Greetings {\n  public String get() {\n    DetailedVer ver = new DetailedVer();\n    return \"Hello from versions/\" + ver.get();\n  }\n}\n";
    public static final String CODE_DETAILED_VER10 = "package hello;\npublic class DetailedVer {\n  public int get() {\n    return 10;\n  }\n}\n";
    public static final String CODE_DETAILED_VER11 = "package hello;\npublic class DetailedVer {\n  public int get() {\n    return Integer.parseInt(\"1\" + \"1\");\n  }\n}\n";
    public static final String README_ROOT = "Hello README (from root)";
    public static final String README_VER9 = "README Hello (from versions/9)";
    public static final String README_VER11 = "README Hello (from versions/11)";
    private final Path outputDir;

    public MultiReleaseJarCreator(Path outputDir) {
        this.outputDir = outputDir;
    }

    public Path createBasicJar() throws IOException {
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        manifest.getMainAttributes().put(Attributes.Name.IMPLEMENTATION_TITLE, "Basic Jar Example");
        InMemoryCompiler compiler = new InMemoryCompiler().setSourceTarget("8", "8");
        ArrayList<Entry> entries = new ArrayList<Entry>();
        entries.add(new Entry("README.txt", README_ROOT));
        AddUnitEntries unitEntriesConsumer = new AddUnitEntries(entries);
        ArrayList<InMemoryCompiler.Unit> units = new ArrayList<InMemoryCompiler.Unit>();
        units.add(new InMemoryCompiler.Unit("hello.Hello", CODE_HELLO));
        units.add(new InMemoryCompiler.Unit("hello.Greetings", CODE_GREETINGS_BASE));
        compiler.compile(units).stream().forEach(unitEntriesConsumer);
        return this.createJar(this.outputDir.resolve("basic.jar"), manifest, entries);
    }

    public Path createMultiReleaseJar9() throws IOException {
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        manifest.getMainAttributes().put(Attributes.Name.IMPLEMENTATION_TITLE, "Multi-Release Jar Example");
        manifest.getMainAttributes().putValue("Multi-Release", "true");
        InMemoryCompiler compiler8 = new InMemoryCompiler().setSourceTarget("8", "8");
        ArrayList<Entry> entries = new ArrayList<Entry>();
        entries.add(new Entry("README.txt", README_ROOT));
        entries.add(new Entry("META-INF/versions/9/README.txt", README_VER9));
        AddUnitEntries unitEntriesConsumer = new AddUnitEntries(entries);
        ArrayList<InMemoryCompiler.Unit> units8 = new ArrayList<InMemoryCompiler.Unit>();
        units8.add(new InMemoryCompiler.Unit("hello.Hello", CODE_HELLO));
        units8.add(new InMemoryCompiler.Unit("hello.Greetings", CODE_GREETINGS_BASE));
        compiler8.compile(units8).stream().forEach(unitEntriesConsumer);
        ArrayList<InMemoryCompiler.Unit> units9 = new ArrayList<InMemoryCompiler.Unit>();
        units9.add(new InMemoryCompiler.Unit("hello.Greetings", CODE_GREETINGS_VER9));
        unitEntriesConsumer.setPathPrefix("META-INF/versions/9/");
        compiler8.compile(units9).stream().forEach(unitEntriesConsumer);
        return this.createJar(this.outputDir.resolve("multirelease-9.jar"), manifest, entries);
    }

    public Path createMultiReleaseJar10() throws IOException {
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        manifest.getMainAttributes().put(Attributes.Name.IMPLEMENTATION_TITLE, "Multi-Release Jar Example");
        manifest.getMainAttributes().putValue("Multi-Release", "true");
        InMemoryCompiler compiler8 = new InMemoryCompiler().setSourceTarget("8", "8");
        ArrayList<Entry> entries = new ArrayList<Entry>();
        entries.add(new Entry("README.txt", README_ROOT));
        entries.add(new Entry("META-INF/versions/9/README.txt", README_VER9));
        AddUnitEntries unitEntriesConsumer = new AddUnitEntries(entries);
        ArrayList<InMemoryCompiler.Unit> units8 = new ArrayList<InMemoryCompiler.Unit>();
        units8.add(new InMemoryCompiler.Unit("hello.Hello", CODE_HELLO));
        units8.add(new InMemoryCompiler.Unit("hello.Greetings", CODE_GREETINGS_BASE));
        compiler8.compile(units8).stream().forEach(unitEntriesConsumer);
        ArrayList<InMemoryCompiler.Unit> units9 = new ArrayList<InMemoryCompiler.Unit>();
        units9.add(new InMemoryCompiler.Unit("hello.Greetings", CODE_GREETINGS_VER9));
        unitEntriesConsumer.setPathPrefix("META-INF/versions/9/");
        compiler8.compile(units9).stream().forEach(unitEntriesConsumer);
        ArrayList<InMemoryCompiler.Unit> units10 = new ArrayList<InMemoryCompiler.Unit>();
        units10.add(new InMemoryCompiler.Unit("hello.Greetings", CODE_GREETINGS_VER10));
        units10.add(new InMemoryCompiler.Unit("hello.DetailedVer", CODE_DETAILED_VER10));
        unitEntriesConsumer.setPathPrefix("META-INF/versions/10/");
        compiler8.compile(units10).stream().forEach(unitEntriesConsumer);
        return this.createJar(this.outputDir.resolve("multirelease-10.jar"), manifest, entries);
    }

    public Path createMultiReleaseJar11() throws IOException {
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        manifest.getMainAttributes().put(Attributes.Name.IMPLEMENTATION_TITLE, "Multi-Release Jar Example");
        manifest.getMainAttributes().putValue("Multi-Release", "true");
        InMemoryCompiler compiler8 = new InMemoryCompiler().setSourceTarget("8", "8");
        ArrayList<Entry> entries = new ArrayList<Entry>();
        entries.add(new Entry("README.txt", README_ROOT));
        entries.add(new Entry("META-INF/versions/9/README.txt", README_VER9));
        entries.add(new Entry("META-INF/versions/11/README.txt", README_VER11));
        AddUnitEntries unitEntriesConsumer = new AddUnitEntries(entries);
        ArrayList<InMemoryCompiler.Unit> units8 = new ArrayList<InMemoryCompiler.Unit>();
        units8.add(new InMemoryCompiler.Unit("hello.Hello", CODE_HELLO));
        units8.add(new InMemoryCompiler.Unit("hello.Greetings", CODE_GREETINGS_BASE));
        compiler8.compile(units8).stream().forEach(unitEntriesConsumer);
        ArrayList<InMemoryCompiler.Unit> units9 = new ArrayList<InMemoryCompiler.Unit>();
        units9.add(new InMemoryCompiler.Unit("hello.Greetings", CODE_GREETINGS_VER9));
        unitEntriesConsumer.setPathPrefix("META-INF/versions/9/");
        compiler8.compile(units9).stream().forEach(unitEntriesConsumer);
        ArrayList<InMemoryCompiler.Unit> units10 = new ArrayList<InMemoryCompiler.Unit>();
        units10.add(new InMemoryCompiler.Unit("hello.Greetings", CODE_GREETINGS_VER10));
        units10.add(new InMemoryCompiler.Unit("hello.DetailedVer", CODE_DETAILED_VER10));
        unitEntriesConsumer.setPathPrefix("META-INF/versions/10/");
        compiler8.compile(units10).stream().forEach(unitEntriesConsumer);
        ArrayList<InMemoryCompiler.Unit> units11 = new ArrayList<InMemoryCompiler.Unit>();
        units11.add(new InMemoryCompiler.Unit("hello.DetailedVer", CODE_DETAILED_VER11));
        unitEntriesConsumer.setPathPrefix("META-INF/versions/11/");
        compiler8.compile(units11).stream().forEach(unitEntriesConsumer);
        return this.createJar(this.outputDir.resolve("multirelease-11.jar"), manifest, entries);
    }

    private Path createJar(Path jarpath, Manifest manifest, List<Entry> entries) throws IOException {
        try (OutputStream outputStream = Files.newOutputStream(jarpath, new OpenOption[0]);
             JarOutputStream jarOutputStream = new JarOutputStream(outputStream, manifest);){
            entries.forEach(entry -> {
                JarEntry je = new JarEntry(entry.name);
                try {
                    jarOutputStream.putNextEntry(je);
                    jarOutputStream.write(entry.contents);
                    jarOutputStream.closeEntry();
                }
                catch (IOException iox) {
                    throw new RuntimeException(iox);
                }
            });
        }
        return jarpath;
    }

    public static void main(String[] args) throws IOException, URISyntaxException {
        Path outputDir = MavenTestingUtils.getTargetTestingPath();
        FS.ensureDirExists(outputDir);
        MultiReleaseJarCreator creator = new MultiReleaseJarCreator(outputDir);
        System.out.println("basic-jar = " + creator.createBasicJar());
        System.out.println("multirelease-jar/9 = " + creator.createMultiReleaseJar9());
        System.out.println("multirelease-jar/10 = " + creator.createMultiReleaseJar10());
        System.out.println("multirelease-jar/11 = " + creator.createMultiReleaseJar11());
    }

    private static class AddUnitEntries
    implements Consumer<InMemoryCompiler.Unit> {
        private List<Entry> entries;
        private String pathPrefix = "";

        public AddUnitEntries(List<Entry> entries) {
            this.entries = entries;
        }

        @Override
        public void accept(InMemoryCompiler.Unit unit) {
            Entry classEntry = new Entry();
            classEntry.name = this.pathPrefix + unit.getClassFilename();
            classEntry.contents = unit.bytecode;
            this.entries.add(classEntry);
            Entry srcEntry = new Entry();
            srcEntry.name = this.pathPrefix + unit.getSourceFilename();
            srcEntry.contents = unit.source.getBytes(StandardCharsets.UTF_8);
            this.entries.add(srcEntry);
        }

        public void setPathPrefix(String pathPrefix) {
            this.pathPrefix = pathPrefix;
        }
    }

    public static class Entry {
        String name;
        byte[] contents;

        public Entry() {
        }

        public Entry(String name, String contents) {
            this.name = name;
            this.contents = contents.getBytes(StandardCharsets.UTF_8);
        }
    }
}

