/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import java.io.IOException;
import java.util.regex.Matcher;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.rewrite.handler.RegexRule;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.annotation.Name;

public class RedirectRegexRule
extends RegexRule {
    protected String _location;
    private int _statusCode = 302;

    public RedirectRegexRule() {
    }

    public RedirectRegexRule(@Name(value="regex") String regex, @Name(value="location") String location) {
        super(regex);
        this._location = location;
    }

    @Override
    public boolean isTerminating() {
        return true;
    }

    public String getLocation() {
        return this._location;
    }

    public void setLocation(String location) {
        this._location = location;
    }

    public int getStatusCode() {
        return this._statusCode;
    }

    public void setStatusCode(int statusCode) {
        if (!HttpStatus.isRedirection((int)statusCode)) {
            throw new IllegalArgumentException("Invalid redirect status code " + statusCode + " (must be a value between 300 and 399)");
        }
        this._statusCode = statusCode;
    }

    @Override
    protected Rule.Handler apply(Rule.Handler input, final Matcher matcher) throws IOException {
        return new Rule.Handler(input){

            @Override
            protected boolean handle(Response response, Callback callback) {
                String target = matcher.replaceAll(RedirectRegexRule.this.getLocation());
                response.setStatus(RedirectRegexRule.this._statusCode);
                response.getHeaders().put(HttpHeader.LOCATION, Response.toRedirectURI((Request)this, (String)target));
                callback.succeeded();
                return true;
            }
        };
    }

    @Override
    public String toString() {
        return "%s[redirect:%d>%s]".formatted(super.toString(), this.getStatusCode(), this.getLocation());
    }
}

