/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.proxy;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jetty.client.AsyncRequestContent;
import org.eclipse.jetty.client.ContentSourceRequestContent;
import org.eclipse.jetty.client.ContinueProtocolHandler;
import org.eclipse.jetty.client.EarlyHintsProtocolHandler;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.ProcessingProtocolHandler;
import org.eclipse.jetty.client.ProtocolHandler;
import org.eclipse.jetty.client.ProtocolHandlers;
import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.client.Response;
import org.eclipse.jetty.client.Result;
import org.eclipse.jetty.client.transport.HttpClientTransportDynamic;
import org.eclipse.jetty.http.HttpCookieStore;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.thread.Invocable;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProxyHandler
extends Handler.Abstract {
    private static final Logger LOG = LoggerFactory.getLogger(ProxyHandler.class);
    private static final String CLIENT_TO_PROXY_REQUEST_ATTRIBUTE = ProxyHandler.class.getName() + ".clientToProxyRequest";
    private static final String PROXY_TO_CLIENT_RESPONSE_ATTRIBUTE = ProxyHandler.class.getName() + ".proxyToClientResponse";
    private static final String PROXY_TO_SERVER_CONTINUE_ATTRIBUTE = ProxyHandler.class.getName() + ".proxyToServerContinue";
    private static final EnumSet<HttpHeader> HOP_HEADERS = EnumSet.of(HttpHeader.CONNECTION, new HttpHeader[]{HttpHeader.KEEP_ALIVE, HttpHeader.PROXY_AUTHORIZATION, HttpHeader.PROXY_AUTHENTICATE, HttpHeader.PROXY_CONNECTION, HttpHeader.TRANSFER_ENCODING, HttpHeader.TE, HttpHeader.TRAILER, HttpHeader.UPGRADE});
    private HttpClient httpClient;
    private String proxyToServerHost;
    private String viaHost;

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public String getProxyToServerHost() {
        return this.proxyToServerHost;
    }

    public void setProxyToServerHost(String host) {
        this.proxyToServerHost = host;
    }

    public String getViaHost() {
        return this.viaHost;
    }

    public void setViaHost(String viaHost) {
        this.viaHost = viaHost;
    }

    private static String viaHost() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException x) {
            return "localhost";
        }
    }

    protected void doStart() throws Exception {
        if (this.httpClient == null) {
            this.setHttpClient(this.createHttpClient());
        }
        this.addBean(this.httpClient, true);
        if (this.viaHost == null) {
            this.setViaHost(ProxyHandler.viaHost());
        }
        super.doStart();
    }

    private HttpClient createHttpClient() {
        HttpClient httpClient = this.newHttpClient();
        this.configureHttpClient(httpClient);
        LifeCycle.start((Object)httpClient);
        httpClient.getContentDecoderFactories().clear();
        ProtocolHandlers protocolHandlers = httpClient.getProtocolHandlers();
        protocolHandlers.clear();
        protocolHandlers.put((ProtocolHandler)new ProxyContinueProtocolHandler());
        protocolHandlers.put((ProtocolHandler)new ProxyProcessingProtocolHandler());
        protocolHandlers.put((ProtocolHandler)new ProxyEarlyHintsProtocolHandler());
        return httpClient;
    }

    protected HttpClient newHttpClient() {
        ClientConnector clientConnector = new ClientConnector();
        QueuedThreadPool proxyClientThreads = new QueuedThreadPool();
        proxyClientThreads.setName("proxy-client");
        clientConnector.setExecutor((Executor)proxyClientThreads);
        return new HttpClient((HttpClientTransport)new HttpClientTransportDynamic(clientConnector, new ClientConnectionFactory.Info[0]));
    }

    protected void configureHttpClient(HttpClient httpClient) {
        httpClient.setFollowRedirects(false);
        httpClient.setHttpCookieStore((HttpCookieStore)new HttpCookieStore.Empty());
    }

    protected static String requestId(org.eclipse.jetty.server.Request clientToProxyRequest) {
        return String.valueOf(System.identityHashCode(clientToProxyRequest));
    }

    public boolean handle(org.eclipse.jetty.server.Request clientToProxyRequest, Response proxyToClientResponse, Callback proxyToClientCallback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} C2P received request\n{}\n{}", new Object[]{ProxyHandler.requestId(clientToProxyRequest), clientToProxyRequest, clientToProxyRequest.getHeaders()});
        }
        HttpURI rewritten = this.rewriteHttpURI(clientToProxyRequest);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} URI rewrite {} => {}", new Object[]{ProxyHandler.requestId(clientToProxyRequest), clientToProxyRequest.getHttpURI(), rewritten});
        }
        Request proxyToServerRequest = this.newProxyToServerRequest(clientToProxyRequest, rewritten);
        proxyToServerRequest.attribute(CLIENT_TO_PROXY_REQUEST_ATTRIBUTE, (Object)clientToProxyRequest).attribute(PROXY_TO_CLIENT_RESPONSE_ATTRIBUTE, (Object)proxyToClientResponse);
        this.copyRequestHeaders(clientToProxyRequest, proxyToServerRequest);
        this.addProxyHeaders(clientToProxyRequest, proxyToServerRequest);
        if (this.hasContent(clientToProxyRequest)) {
            if (this.expects100Continue(clientToProxyRequest)) {
                AsyncRequestContent delayedProxyToServerRequestContent = new AsyncRequestContent(new ByteBuffer[0]);
                proxyToServerRequest.body((Request.Content)delayedProxyToServerRequestContent);
                Runnable action = () -> {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} P2S continuing request", (Object)ProxyHandler.requestId(clientToProxyRequest));
                    }
                    Request.Content proxyToServerRequestContent = this.newProxyToServerRequestContent(clientToProxyRequest, proxyToClientResponse, proxyToServerRequest);
                    Content.copy((Content.Source)proxyToServerRequestContent, (Content.Sink)delayedProxyToServerRequestContent, (Callback)Callback.from(() -> ((AsyncRequestContent)delayedProxyToServerRequestContent).close(), arg_0 -> ((AsyncRequestContent)delayedProxyToServerRequestContent).fail(arg_0)));
                };
                proxyToServerRequest.attribute(PROXY_TO_SERVER_CONTINUE_ATTRIBUTE, (Object)action);
            } else {
                Request.Content proxyToServerRequestContent = this.newProxyToServerRequestContent(clientToProxyRequest, proxyToClientResponse, proxyToServerRequest);
                proxyToServerRequest.body(proxyToServerRequestContent);
            }
        }
        this.sendProxyToServerRequest(clientToProxyRequest, proxyToServerRequest, proxyToClientResponse, proxyToClientCallback);
        return true;
    }

    protected abstract HttpURI rewriteHttpURI(org.eclipse.jetty.server.Request var1);

    protected Request newProxyToServerRequest(org.eclipse.jetty.server.Request clientToProxyRequest, HttpURI newHttpURI) {
        return this.getHttpClient().newRequest(newHttpURI.toURI()).method(clientToProxyRequest.getMethod());
    }

    protected void copyRequestHeaders(org.eclipse.jetty.server.Request clientToProxyRequest, Request proxyToServerRequest) {
        Set<String> headersToRemove = this.findConnectionHeaders(clientToProxyRequest);
        for (HttpField clientToProxyRequestField : clientToProxyRequest.getHeaders()) {
            String host;
            HttpHeader clientToProxyRequestHeader = clientToProxyRequestField.getHeader();
            if (HttpHeader.HOST == clientToProxyRequestHeader && (host = this.getProxyToServerHost()) != null) {
                proxyToServerRequest.headers(headers -> headers.put(HttpHeader.HOST, host));
                continue;
            }
            if (HOP_HEADERS.contains(clientToProxyRequestHeader) || headersToRemove != null && headersToRemove.contains(clientToProxyRequestField.getLowerCaseName())) continue;
            proxyToServerRequest.headers(headers -> headers.add(clientToProxyRequestField));
        }
    }

    private Set<String> findConnectionHeaders(org.eclipse.jetty.server.Request clientToProxyRequest) {
        HashSet<String> hopHeaders = null;
        List connectionHeaders = clientToProxyRequest.getHeaders().getValuesList(HttpHeader.CONNECTION);
        for (String value : connectionHeaders) {
            String[] values;
            for (String name : values = value.split(",")) {
                name = name.trim().toLowerCase(Locale.ENGLISH);
                if (hopHeaders == null) {
                    hopHeaders = new HashSet<String>();
                }
                hopHeaders.add(name);
            }
        }
        return hopHeaders;
    }

    protected void addProxyHeaders(org.eclipse.jetty.server.Request clientToProxyRequest, Request proxyToServerRequest) {
        this.addViaHeader(clientToProxyRequest, proxyToServerRequest);
        this.addForwardedHeader(clientToProxyRequest, proxyToServerRequest);
    }

    protected void addViaHeader(org.eclipse.jetty.server.Request clientToProxyRequest, Request proxyToServerRequest) {
        String protocol = clientToProxyRequest.getConnectionMetaData().getProtocol();
        String[] parts = protocol.split("/", 2);
        String protocolPart = parts.length == 2 && "HTTP".equalsIgnoreCase(parts[0]) ? parts[1] : protocol;
        String viaHeaderValue = protocolPart + " " + this.getViaHost();
        proxyToServerRequest.headers(headers -> headers.computeField(HttpHeader.VIA, (header, viaFields) -> {
            if (viaFields == null || viaFields.isEmpty()) {
                return new HttpField(header, viaHeaderValue);
            }
            String separator = ", ";
            Object newValue = viaFields.stream().flatMap(field -> Stream.of(field.getValues())).filter(value -> !StringUtil.isBlank((String)value)).collect(Collectors.joining(separator));
            if (!((String)newValue).isEmpty()) {
                newValue = (String)newValue + separator;
            }
            newValue = (String)newValue + viaHeaderValue;
            return new HttpField(HttpHeader.VIA, (String)newValue);
        }));
    }

    protected void addForwardedHeader(org.eclipse.jetty.server.Request clientToProxyRequest, Request proxyToServerRequest) {
        String byAttr = org.eclipse.jetty.server.Request.getLocalAddr((org.eclipse.jetty.server.Request)clientToProxyRequest);
        String forAttr = org.eclipse.jetty.server.Request.getRemoteAddr((org.eclipse.jetty.server.Request)clientToProxyRequest);
        String hostAttr = clientToProxyRequest.getHeaders().get(HttpHeader.HOST);
        String scheme = clientToProxyRequest.getHttpURI().getScheme();
        String protoAttr = scheme == null ? (clientToProxyRequest.isSecure() ? "https" : "http") : scheme;
        String forwardedValue = "by=%s;for=%s;host=%s;proto=%s".formatted(HttpField.PARAMETER_TOKENIZER.quote(byAttr), HttpField.PARAMETER_TOKENIZER.quote(forAttr), HttpField.PARAMETER_TOKENIZER.quote(hostAttr), protoAttr);
        proxyToServerRequest.headers(headers -> headers.computeField(HttpHeader.FORWARDED, (header, fields) -> {
            Object newValue;
            if (fields == null || fields.isEmpty()) {
                newValue = forwardedValue;
            } else {
                String separator = ", ";
                newValue = fields.stream().flatMap(field -> field.getValueList().stream()).collect(Collectors.joining(separator));
                newValue = (String)newValue + separator + forwardedValue;
            }
            return new HttpField(HttpHeader.FORWARDED, (String)newValue);
        }));
    }

    private boolean hasContent(org.eclipse.jetty.server.Request clientToProxyRequest) {
        long contentLength = clientToProxyRequest.getLength();
        if (contentLength == 0L) {
            return false;
        }
        if (contentLength > 0L) {
            return true;
        }
        return clientToProxyRequest.getHeaders().get(HttpHeader.TRANSFER_ENCODING) != null;
    }

    private boolean expects100Continue(org.eclipse.jetty.server.Request clientToProxyRequest) {
        return HttpHeaderValue.CONTINUE.is(clientToProxyRequest.getHeaders().get(HttpHeader.EXPECT));
    }

    protected Request.Content newProxyToServerRequestContent(org.eclipse.jetty.server.Request clientToProxyRequest, Response proxyToClientResponse, Request proxyToServerRequest) {
        return new ProxyRequestContent(clientToProxyRequest);
    }

    protected void sendProxyToServerRequest(org.eclipse.jetty.server.Request clientToProxyRequest, Request proxyToServerRequest, Response proxyToClientResponse, Callback proxyToClientCallback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} P2S sending request\n{}\n{}", new Object[]{ProxyHandler.requestId(clientToProxyRequest), proxyToServerRequest, proxyToServerRequest.getHeaders()});
        }
        proxyToServerRequest.send(this.newServerToProxyResponseListener(clientToProxyRequest, proxyToServerRequest, proxyToClientResponse, proxyToClientCallback));
    }

    protected Response.CompleteListener newServerToProxyResponseListener(org.eclipse.jetty.server.Request clientToProxyRequest, Request proxyToServerRequest, Response proxyToClientResponse, Callback proxyToClientCallback) {
        return new ProxyResponseListener(clientToProxyRequest, proxyToServerRequest, proxyToClientResponse, proxyToClientCallback);
    }

    protected HttpField filterServerToProxyResponseField(HttpField serverToProxyResponseField) {
        return serverToProxyResponseField;
    }

    protected void onServerToProxyResponseFailure(org.eclipse.jetty.server.Request clientToProxyRequest, Request proxyToServerRequest, org.eclipse.jetty.client.Response serverToProxyResponse, Response proxyToClientResponse, Callback proxyToClientCallback, Throwable failure) {
        int status = 502;
        if (failure instanceof TimeoutException) {
            status = 504;
        }
        ProxyToClientResponseFailureCallback callback = new ProxyToClientResponseFailureCallback(clientToProxyRequest, proxyToServerRequest, serverToProxyResponse, proxyToClientResponse, proxyToClientCallback);
        Response.writeError((org.eclipse.jetty.server.Request)clientToProxyRequest, (Response)proxyToClientResponse, (Callback)callback, (int)status);
    }

    protected Runnable onServerToProxyResponse100Continue(org.eclipse.jetty.server.Request clientToProxyRequest, Request proxyToServerRequest) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} P2C 100 continue response", (Object)ProxyHandler.requestId(clientToProxyRequest));
        }
        return (Runnable)proxyToServerRequest.getAttributes().get(PROXY_TO_SERVER_CONTINUE_ATTRIBUTE);
    }

    protected void onServerToProxyResponse102Processing(org.eclipse.jetty.server.Request clientToProxyRequest, Request proxyToServerRequest, HttpFields serverToProxyResponseHeaders, Response proxyToClientResponse) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} P2C 102 interim response {}", (Object)ProxyHandler.requestId(clientToProxyRequest), (Object)serverToProxyResponseHeaders);
        }
        proxyToClientResponse.writeInterim(102, serverToProxyResponseHeaders);
    }

    protected void onServerToProxyResponse103EarlyHints(org.eclipse.jetty.server.Request clientToProxyRequest, Request proxyToServerRequest, HttpFields serverToProxyResponseHeaders, Response proxyToClientResponse) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} P2C 103 interim response {}", (Object)ProxyHandler.requestId(clientToProxyRequest), (Object)serverToProxyResponseHeaders);
        }
        proxyToClientResponse.writeInterim(103, serverToProxyResponseHeaders);
    }

    protected void onProxyToClientResponseComplete(org.eclipse.jetty.server.Request clientToProxyRequest, Request proxyToServerRequest, org.eclipse.jetty.client.Response serverToProxyResponse, Response proxyToClientResponse, Callback proxyToClientCallback) {
        proxyToClientCallback.succeeded();
    }

    protected void onProxyToClientResponseFailure(org.eclipse.jetty.server.Request clientToProxyRequest, Request proxyToServerRequest, org.eclipse.jetty.client.Response serverToProxyResponse, Response proxyToClientResponse, Callback proxyToClientCallback, Throwable failure) {
        proxyToClientCallback.failed(failure);
    }

    private class ProxyContinueProtocolHandler
    extends ContinueProtocolHandler {
        private ProxyContinueProtocolHandler() {
        }

        protected Runnable onContinue(Request proxyToServerRequest) {
            org.eclipse.jetty.server.Request clientToProxyRequest = (org.eclipse.jetty.server.Request)proxyToServerRequest.getAttributes().get(CLIENT_TO_PROXY_REQUEST_ATTRIBUTE);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} S2P received 100 Continue", (Object)ProxyHandler.requestId(clientToProxyRequest));
            }
            return ProxyHandler.this.onServerToProxyResponse100Continue(clientToProxyRequest, proxyToServerRequest);
        }
    }

    private class ProxyProcessingProtocolHandler
    extends ProcessingProtocolHandler {
        private ProxyProcessingProtocolHandler() {
        }

        protected void onProcessing(Request proxyToServerRequest, HttpFields serverToProxyResponseHeaders) {
            super.onProcessing(proxyToServerRequest, serverToProxyResponseHeaders);
            org.eclipse.jetty.server.Request clientToProxyRequest = (org.eclipse.jetty.server.Request)proxyToServerRequest.getAttributes().get(CLIENT_TO_PROXY_REQUEST_ATTRIBUTE);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} S2P received 102 Processing", (Object)ProxyHandler.requestId(clientToProxyRequest));
            }
            Response proxyToClientResponse = (Response)proxyToServerRequest.getAttributes().get(PROXY_TO_CLIENT_RESPONSE_ATTRIBUTE);
            ProxyHandler.this.onServerToProxyResponse102Processing(clientToProxyRequest, proxyToServerRequest, serverToProxyResponseHeaders, proxyToClientResponse);
        }
    }

    private class ProxyEarlyHintsProtocolHandler
    extends EarlyHintsProtocolHandler {
        private ProxyEarlyHintsProtocolHandler() {
        }

        protected void onEarlyHints(Request proxyToServerRequest, HttpFields serverToProxyResponseHeaders) {
            super.onEarlyHints(proxyToServerRequest, serverToProxyResponseHeaders);
            org.eclipse.jetty.server.Request clientToProxyRequest = (org.eclipse.jetty.server.Request)proxyToServerRequest.getAttributes().get(CLIENT_TO_PROXY_REQUEST_ATTRIBUTE);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} S2P received 103 Early Hints", (Object)ProxyHandler.requestId(clientToProxyRequest));
            }
            Response proxyToClientResponse = (Response)proxyToServerRequest.getAttributes().get(PROXY_TO_CLIENT_RESPONSE_ATTRIBUTE);
            ProxyHandler.this.onServerToProxyResponse103EarlyHints(clientToProxyRequest, proxyToServerRequest, serverToProxyResponseHeaders, proxyToClientResponse);
        }
    }

    protected static class ProxyRequestContent
    extends ContentSourceRequestContent {
        public ProxyRequestContent(org.eclipse.jetty.server.Request clientToProxyRequest) {
            super((Content.Source)clientToProxyRequest, clientToProxyRequest.getHeaders().get(HttpHeader.CONTENT_TYPE));
        }

        public org.eclipse.jetty.server.Request getContentSource() {
            return (org.eclipse.jetty.server.Request)super.getContentSource();
        }

        public Content.Chunk read() {
            Content.Chunk chunk = super.read();
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} C2P read content {}", (Object)ProxyHandler.requestId(this.getContentSource()), (Object)chunk);
            }
            return chunk;
        }
    }

    protected class ProxyResponseListener
    extends Callback.Completable
    implements Response.Listener {
        private final org.eclipse.jetty.server.Request clientToProxyRequest;
        private final Request proxyToServerRequest;
        private final Response proxyToClientResponse;
        private final Callback proxyToClientCallback;

        public ProxyResponseListener(org.eclipse.jetty.server.Request clientToProxyRequest, Request proxyToServerRequest, Response proxyToClientResponse, Callback proxyToClientCallback) {
            super(Invocable.InvocationType.NON_BLOCKING);
            this.clientToProxyRequest = clientToProxyRequest;
            this.proxyToServerRequest = proxyToServerRequest;
            this.proxyToClientResponse = proxyToClientResponse;
            this.proxyToClientCallback = proxyToClientCallback;
        }

        public void onBegin(org.eclipse.jetty.client.Response serverToProxyResponse) {
            this.proxyToClientResponse.setStatus(serverToProxyResponse.getStatus());
        }

        public void onHeaders(org.eclipse.jetty.client.Response serverToProxyResponse) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} S2P received response\n{}\n{}", new Object[]{ProxyHandler.requestId(this.clientToProxyRequest), serverToProxyResponse, serverToProxyResponse.getHeaders()});
            }
            for (HttpField serverToProxyResponseField : serverToProxyResponse.getHeaders()) {
                HttpField newField;
                if (HOP_HEADERS.contains(serverToProxyResponseField.getHeader()) || (newField = ProxyHandler.this.filterServerToProxyResponseField(serverToProxyResponseField)) == null) continue;
                this.proxyToClientResponse.getHeaders().add(newField);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} P2C sending response\n{}\n{}", new Object[]{ProxyHandler.requestId(this.clientToProxyRequest), this.proxyToClientResponse, this.proxyToClientResponse.getHeaders()});
            }
        }

        public void onContent(final org.eclipse.jetty.client.Response serverToProxyResponse, final Content.Chunk serverToProxyChunk, final Runnable serverToProxyDemander) {
            final ByteBuffer serverToProxyContent = serverToProxyChunk.getByteBuffer();
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} S2P received content {}", (Object)ProxyHandler.requestId(this.clientToProxyRequest), (Object)BufferUtil.toDetailString((ByteBuffer)serverToProxyContent));
            }
            serverToProxyChunk.retain();
            Callback callback = new Callback(){
                final /* synthetic */ ProxyResponseListener this$1;
                {
                    this.this$1 = this$1;
                }

                public void succeeded() {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} P2C succeeded to write content {}", (Object)ProxyHandler.requestId(this.this$1.clientToProxyRequest), (Object)BufferUtil.toDetailString((ByteBuffer)serverToProxyContent));
                    }
                    serverToProxyChunk.release();
                    serverToProxyDemander.run();
                }

                public void failed(Throwable failure) {
                    if (LOG.isDebugEnabled()) {
                        LOG.atDebug().setCause(failure).log("{} P2C failed to write content {}", (Object)ProxyHandler.requestId(this.this$1.clientToProxyRequest), (Object)BufferUtil.toDetailString((ByteBuffer)serverToProxyContent));
                    }
                    serverToProxyChunk.release();
                    serverToProxyResponse.abort(failure);
                }

                public Invocable.InvocationType getInvocationType() {
                    return Invocable.InvocationType.NON_BLOCKING;
                }
            };
            this.proxyToClientResponse.write(false, serverToProxyContent, callback);
        }

        public void onSuccess(org.eclipse.jetty.client.Response serverToProxyResponse) {
            this.proxyToClientResponse.write(true, BufferUtil.EMPTY_BUFFER, (Callback)this);
        }

        public void onComplete(Result result) {
            if (result.isSucceeded()) {
                this.whenComplete((r, failure) -> {
                    if (failure == null) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{} P2C response complete {}", (Object)ProxyHandler.requestId(this.clientToProxyRequest), (Object)this.proxyToClientResponse);
                        }
                        ProxyHandler.this.onProxyToClientResponseComplete(this.clientToProxyRequest, this.proxyToServerRequest, result.getResponse(), this.proxyToClientResponse, this.proxyToClientCallback);
                    } else {
                        if (LOG.isDebugEnabled()) {
                            LOG.atDebug().setCause(failure).log("{} P2C response failure {}", (Object)ProxyHandler.requestId(this.clientToProxyRequest), (Object)this.proxyToClientResponse);
                        }
                        ProxyHandler.this.onProxyToClientResponseFailure(this.clientToProxyRequest, this.proxyToServerRequest, result.getResponse(), this.proxyToClientResponse, this.proxyToClientCallback, (Throwable)failure);
                    }
                });
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} S2P failure {}", new Object[]{ProxyHandler.requestId(this.clientToProxyRequest), result.getResponse(), result.getFailure()});
                }
                ProxyHandler.this.onServerToProxyResponseFailure(this.clientToProxyRequest, this.proxyToServerRequest, result.getResponse(), this.proxyToClientResponse, this.proxyToClientCallback, result.getFailure());
            }
        }
    }

    private class ProxyToClientResponseFailureCallback
    implements Callback {
        private final org.eclipse.jetty.server.Request clientToProxyRequest;
        private final Request proxyToServerRequest;
        private final org.eclipse.jetty.client.Response serverToProxyResponse;
        private final Response proxyToClientResponse;
        private final Callback proxyToClientCallback;

        private ProxyToClientResponseFailureCallback(org.eclipse.jetty.server.Request clientToProxyRequest, Request proxyToServerRequest, org.eclipse.jetty.client.Response serverToProxyResponse, Response proxyToClientResponse, Callback proxyToClientCallback) {
            this.clientToProxyRequest = clientToProxyRequest;
            this.proxyToServerRequest = proxyToServerRequest;
            this.serverToProxyResponse = serverToProxyResponse;
            this.proxyToClientResponse = proxyToClientResponse;
            this.proxyToClientCallback = proxyToClientCallback;
        }

        public void succeeded() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} P2C response complete {}", (Object)ProxyHandler.requestId(this.clientToProxyRequest), (Object)this.proxyToClientResponse);
            }
            ProxyHandler.this.onProxyToClientResponseComplete(this.clientToProxyRequest, this.proxyToServerRequest, this.serverToProxyResponse, this.proxyToClientResponse, this.proxyToClientCallback);
        }

        public void failed(Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.atDebug().setCause(x).log("{} P2C response failure {}", (Object)ProxyHandler.requestId(this.clientToProxyRequest), (Object)this.proxyToClientResponse);
            }
            ProxyHandler.this.onProxyToClientResponseFailure(this.clientToProxyRequest, this.proxyToServerRequest, this.serverToProxyResponse, this.proxyToClientResponse, this.proxyToClientCallback, x);
        }

        public Invocable.InvocationType getInvocationType() {
            return Invocable.InvocationType.NON_BLOCKING;
        }
    }

    public static class Reverse
    extends ProxyHandler {
        private final Function<org.eclipse.jetty.server.Request, HttpURI> httpURIRewriter;

        public Reverse(String uriPattern, String uriReplacement) {
            this(request -> {
                String uri = request.getHttpURI().toString();
                return HttpURI.build((String)uri.replaceAll(uriPattern, uriReplacement));
            });
        }

        public Reverse(Function<org.eclipse.jetty.server.Request, HttpURI> httpURIRewriter) {
            this.httpURIRewriter = Objects.requireNonNull(httpURIRewriter);
        }

        public Function<org.eclipse.jetty.server.Request, HttpURI> getHttpURIRewriter() {
            return this.httpURIRewriter;
        }

        @Override
        protected HttpURI rewriteHttpURI(org.eclipse.jetty.server.Request clientToProxyRequest) {
            return this.getHttpURIRewriter().apply(clientToProxyRequest);
        }
    }

    public static class Forward
    extends ProxyHandler {
        @Override
        protected HttpURI rewriteHttpURI(org.eclipse.jetty.server.Request clientToProxyRequest) {
            return clientToProxyRequest.getHttpURI();
        }
    }
}

