/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.stream.Stream;
import org.eclipse.jetty.http.compression.EncodingException;
import org.eclipse.jetty.http.compression.HuffmanDecoder;
import org.eclipse.jetty.http.compression.HuffmanEncoder;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.TypeUtil;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class HuffmanTest {
    public static String decode(ByteBuffer buffer, int length) throws EncodingException {
        HuffmanDecoder huffmanDecoder = new HuffmanDecoder();
        huffmanDecoder.setLength(length);
        String decoded = huffmanDecoder.decode(buffer);
        if (decoded == null) {
            throw new EncodingException("invalid string encoding");
        }
        huffmanDecoder.reset();
        return decoded;
    }

    public static Stream<Arguments> data() {
        return Stream.of({"D.4.1", "f1e3c2e5f23a6ba0ab90f4ff", "www.example.com"}, {"D.4.2", "a8eb10649cbf", "no-cache"}, {"D.6.1k", "6402", "302"}, {"D.6.1v", "aec3771a4b", "private"}, {"D.6.1d", "d07abe941054d444a8200595040b8166e082a62d1bff", "Mon, 21 Oct 2013 20:13:21 GMT"}, {"D.6.1l", "9d29ad171863c78f0b97c8e9ae82ae43d3", "https://www.example.com"}, {"D.6.2te", "640cff", "303"}).map(Arguments::of);
    }

    @ParameterizedTest(name="[{index}] spec={0}")
    @MethodSource(value={"data"})
    public void testDecode(String specSection, String hex, String expected) throws Exception {
        byte[] encoded = TypeUtil.fromHexString((String)hex);
        HuffmanDecoder huffmanDecoder = new HuffmanDecoder();
        huffmanDecoder.setLength(encoded.length);
        String decoded = huffmanDecoder.decode(ByteBuffer.wrap(encoded));
        Assertions.assertEquals((Object)expected, (Object)decoded, (String)specSection);
    }

    @ParameterizedTest(name="[{index}] spec={0}")
    @MethodSource(value={"data"})
    public void testEncode(String specSection, String hex, String expected) {
        ByteBuffer buf = BufferUtil.allocate((int)1024);
        int pos = BufferUtil.flipToFill((ByteBuffer)buf);
        HuffmanEncoder.encode((ByteBuffer)buf, (String)expected);
        BufferUtil.flipToFlush((ByteBuffer)buf, (int)pos);
        String encoded = TypeUtil.toHexString((byte[])BufferUtil.toArray((ByteBuffer)buf)).toLowerCase(Locale.ENGLISH);
        Assertions.assertEquals((Object)hex, (Object)encoded, (String)specSection);
        Assertions.assertEquals((int)(hex.length() / 2), (int)HuffmanEncoder.octetsNeeded((String)expected));
    }

    public static Stream<Arguments> testDecode8859OnlyArguments() {
        return Stream.of(Arguments.of((Object[])new Object[]{"FfFe6f", Character.valueOf('\u0080')}), Arguments.of((Object[])new Object[]{"FfFfFbBf", Character.valueOf('\u00ff')}), Arguments.of((Object[])new Object[]{"FfC7", Character.valueOf(' ')}), Arguments.of((Object[])new Object[]{"FfFfFfF7", Character.valueOf(' ')}), Arguments.of((Object[])new Object[]{"FfFfFfF3", Character.valueOf(' ')}), Arguments.of((Object[])new Object[]{"FfFfFfBf", Character.valueOf('?')}));
    }

    @ParameterizedTest(name="[{index}]")
    @MethodSource(value={"testDecode8859OnlyArguments"})
    public void testDecode8859Only(String hexString, char expected) throws Exception {
        ByteBuffer buffer = ByteBuffer.wrap(TypeUtil.fromHexString((String)hexString));
        String decoded = HuffmanTest.decode(buffer, buffer.remaining());
        MatcherAssert.assertThat((Object)decoded, (Matcher)Matchers.equalTo((Object)("" + expected)));
    }

    public static Stream<Arguments> testEncode8859OnlyArguments() {
        return Stream.of(Arguments.of((Object[])new Object[]{Character.valueOf('\u0080'), Character.valueOf('\u0080')}), Arguments.of((Object[])new Object[]{Character.valueOf('\u00ff'), Character.valueOf('\u00ff')}), Arguments.of((Object[])new Object[]{Character.valueOf('\u0000'), null}), Arguments.of((Object[])new Object[]{Character.valueOf('\r'), null}), Arguments.of((Object[])new Object[]{Character.valueOf('\n'), null}), Arguments.of((Object[])new Object[]{Character.valueOf('\u01c8'), null}), Arguments.of((Object[])new Object[]{Character.valueOf('\u0100'), null}), Arguments.of((Object[])new Object[]{Character.valueOf('\uffff'), null}), Arguments.of((Object[])new Object[]{Character.valueOf('\u001f'), null}));
    }

    @ParameterizedTest(name="[{index}]")
    @MethodSource(value={"testEncode8859OnlyArguments"})
    public void testEncode8859Only(char value, Character expectedValue) throws Exception {
        String s = "value = '" + value + "'";
        if (expectedValue == null) {
            MatcherAssert.assertThat((Object)HuffmanEncoder.octetsNeeded((String)s), (Matcher)Matchers.equalTo((Object)-1));
            Assertions.assertThrows(Throwable.class, () -> this.encode(s));
            return;
        }
        String expected = "value = '" + expectedValue + "'";
        MatcherAssert.assertThat((Object)HuffmanEncoder.octetsNeeded((String)s), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        ByteBuffer buffer = this.encode(s);
        String decode = this.decode(buffer);
        System.err.println("decoded: " + decode);
        MatcherAssert.assertThat((Object)decode, (Matcher)Matchers.equalTo((Object)expected));
    }

    private ByteBuffer encode(String s) {
        ByteBuffer buffer = BufferUtil.allocate((int)32);
        BufferUtil.clearToFill((ByteBuffer)buffer);
        HuffmanEncoder.encode((ByteBuffer)buffer, (String)s);
        BufferUtil.flipToFlush((ByteBuffer)buffer, (int)0);
        return buffer;
    }

    private String decode(ByteBuffer buffer) throws Exception {
        return HuffmanTest.decode(buffer, buffer.remaining());
    }
}

