/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.spi;

import com.sun.net.httpserver.Authenticator;
import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpPrincipal;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.http.spi.JettyExchange;
import org.eclipse.jetty.http.spi.JettyHttpExchange;
import org.eclipse.jetty.http.spi.JettyHttpsExchange;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSpiContextHandler
extends ContextHandler {
    public static final Logger LOG = LoggerFactory.getLogger(HttpSpiContextHandler.class);
    private final HttpContext _httpContext;
    private HttpHandler _httpHandler;

    public HttpSpiContextHandler(HttpContext httpContext, HttpHandler httpHandler) {
        this._httpContext = httpContext;
        this._httpHandler = httpHandler;
        this.setAllowNullPathInContext(true);
        super.setHandler((Handler)new Handler.Abstract(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean handle(Request request, Response response, Callback callback) {
                try (HttpExchange jettyHttpExchange = request.isSecure() ? new JettyHttpsExchange(HttpSpiContextHandler.this._httpContext, request, response) : new JettyHttpExchange(HttpSpiContextHandler.this._httpContext, request, response);){
                    Authenticator auth = HttpSpiContextHandler.this._httpContext.getAuthenticator();
                    if (auth != null && HttpSpiContextHandler.this.handleAuthentication(request, response, callback, jettyHttpExchange, auth)) {
                        boolean bl = true;
                        return bl;
                    }
                    HttpSpiContextHandler.this._httpHandler.handle(jettyHttpExchange);
                    callback.succeeded();
                    return true;
                }
                catch (Exception ex) {
                    LOG.debug("Failed to handle", (Throwable)ex);
                    Response.writeError((Request)request, (Response)response, (Callback)callback, (int)500, null, (Throwable)ex);
                }
                return true;
            }
        });
    }

    public void setHandler(Handler handler) {
        throw new UnsupportedOperationException();
    }

    private boolean handleAuthentication(Request request, Response response, Callback callback, HttpExchange httpExchange, Authenticator auth) {
        Authenticator.Result result = auth.authenticate(httpExchange);
        if (result instanceof Authenticator.Failure) {
            int rc = ((Authenticator.Failure)result).getResponseCode();
            for (Map.Entry<String, List<String>> header : httpExchange.getResponseHeaders().entrySet()) {
                for (String value : header.getValue()) {
                    response.getHeaders().add(header.getKey(), value);
                }
            }
            Response.writeError((Request)request, (Response)response, (Callback)callback, (int)rc);
            return true;
        }
        if (result instanceof Authenticator.Retry) {
            int rc = ((Authenticator.Retry)result).getResponseCode();
            for (Map.Entry<String, List<String>> header : httpExchange.getResponseHeaders().entrySet()) {
                for (String value : header.getValue()) {
                    response.getHeaders().add(header.getKey(), value);
                }
            }
            Response.writeError((Request)request, (Response)response, (Callback)callback, (int)rc);
            return true;
        }
        if (result instanceof Authenticator.Success) {
            HttpPrincipal principal = ((Authenticator.Success)result).getPrincipal();
            ((JettyExchange)((Object)httpExchange)).setPrincipal(principal);
            return false;
        }
        Response.writeError((Request)request, (Response)response, (Callback)callback, (int)500);
        return true;
    }

    public HttpHandler getHttpHandler() {
        return this._httpHandler;
    }

    public void setHttpHandler(HttpHandler handler) {
        this._httpHandler = handler;
    }
}

