/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.transport;

import java.util.concurrent.CompletionStage;
import org.eclipse.jetty.client.Connection;
import org.eclipse.jetty.client.Result;
import org.eclipse.jetty.client.transport.HttpDestination;
import org.eclipse.jetty.client.transport.HttpExchange;
import org.eclipse.jetty.client.transport.HttpReceiver;
import org.eclipse.jetty.client.transport.HttpRequest;
import org.eclipse.jetty.client.transport.HttpSender;
import org.eclipse.jetty.io.CyclicTimeouts;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.thread.AutoLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpChannel
implements CyclicTimeouts.Expirable {
    private static final Logger LOG = LoggerFactory.getLogger(HttpChannel.class);
    private final AutoLock _lock = new AutoLock();
    private final HttpDestination _destination;
    private HttpExchange _exchange;

    protected HttpChannel(HttpDestination destination) {
        this._destination = destination;
    }

    public void destroy() {
    }

    public HttpDestination getHttpDestination() {
        return this._destination;
    }

    public boolean associate(HttpExchange exchange) {
        boolean result = false;
        boolean abort = true;
        try (AutoLock ignored = this._lock.lock();){
            if (this._exchange == null) {
                abort = false;
                result = exchange.associate(this);
                if (result) {
                    this._exchange = exchange;
                }
            }
        }
        HttpRequest request = exchange.getRequest();
        if (abort) {
            request.abort(new UnsupportedOperationException("Pipelined requests not supported"));
        } else {
            request.setConnection(this.getConnection());
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} associated {} to {}", new Object[]{exchange, result, this});
            }
        }
        return result;
    }

    public boolean disassociate(HttpExchange exchange) {
        boolean result = false;
        try (AutoLock ignored = this._lock.lock();){
            HttpExchange existing = this._exchange;
            this._exchange = null;
            if (existing == exchange) {
                existing.disassociate(this);
                result = true;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} disassociated {} from {}", new Object[]{exchange, result, this});
        }
        return result;
    }

    public HttpExchange getHttpExchange() {
        try (AutoLock ignored = this._lock.lock();){
            HttpExchange httpExchange = this._exchange;
            return httpExchange;
        }
    }

    protected abstract Connection getConnection();

    public long getExpireNanoTime() {
        HttpExchange exchange = this.getHttpExchange();
        return exchange != null ? exchange.getExpireNanoTime() : Long.MAX_VALUE;
    }

    protected abstract HttpSender getHttpSender();

    protected abstract HttpReceiver getHttpReceiver();

    public void send() {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange != null) {
            this.send(exchange);
        }
    }

    public abstract void send(HttpExchange var1);

    public abstract void release();

    public void proceed(HttpExchange exchange, Throwable failure) {
        this.getHttpSender().proceed(exchange, failure);
    }

    public void abort(HttpExchange exchange, Throwable requestFailure, Throwable responseFailure, Promise<Boolean> promise) {
        Promise.Completable requestPromise = new Promise.Completable();
        if (requestFailure != null) {
            this.getHttpSender().abort(exchange, requestFailure, (Promise<Boolean>)requestPromise);
        } else {
            requestPromise.succeeded((Object)false);
        }
        Promise.Completable responsePromise = new Promise.Completable();
        if (responseFailure != null) {
            this.abortResponse(exchange, responseFailure, (Promise<Boolean>)responsePromise);
        } else {
            responsePromise.succeeded((Object)false);
        }
        requestPromise.thenAcceptBoth((CompletionStage)responsePromise, (requestAborted, responseAborted) -> promise.succeeded((Object)(requestAborted != false || responseAborted != false ? 1 : 0)));
    }

    public void abortResponse(HttpExchange exchange, Throwable failure, Promise<Boolean> promise) {
        this.getHttpReceiver().abort(exchange, failure, promise);
    }

    public Result exchangeTerminating(HttpExchange exchange, Result result) {
        return result;
    }

    public void exchangeTerminated(HttpExchange exchange, Result result) {
        this.disassociate(exchange);
    }

    public String toString() {
        return String.format("%s@%x(exchange=%s)", this.getClass().getSimpleName(), this.hashCode(), this.getHttpExchange());
    }
}

