/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.alpn.java.server;

import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import org.eclipse.jetty.alpn.ALPN;
import org.eclipse.jetty.io.ssl.ALPNProcessor;
import org.eclipse.jetty.io.ssl.SslHandshakeListener;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class JDK9ServerALPNProcessor
implements ALPNProcessor.Server,
SslHandshakeListener {
    private static final Logger LOG = Log.getLogger(JDK9ServerALPNProcessor.class);

    public void configure(SSLEngine sslEngine) {
        sslEngine.setHandshakeApplicationProtocolSelector(this::process);
    }

    private String process(SSLEngine sslEngine, List<String> protocols) {
        try {
            ALPN.ServerProvider provider;
            if (LOG.isDebugEnabled()) {
                LOG.debug("ALPN selecting among client{}", new Object[]{protocols});
            }
            return (provider = (ALPN.ServerProvider)ALPN.remove((SSLEngine)sslEngine)) == null ? "" : provider.select(protocols);
        }
        catch (SSLException x) {
            return null;
        }
    }

    public void handshakeSucceeded(SslHandshakeListener.Event event) {
        ALPN.ServerProvider provider = (ALPN.ServerProvider)ALPN.remove((SSLEngine)event.getSSLEngine());
        if (provider != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("ALPN unsupported by client", new Object[0]);
            }
            provider.unsupported();
        }
    }

    public void handshakeFailed(SslHandshakeListener.Event event, Throwable failure) {
    }
}

