/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.server;

import java.util.Map;
import java.util.Objects;
import org.eclipse.jetty.http3.HTTP3Configuration;
import org.eclipse.jetty.http3.api.Session;
import org.eclipse.jetty.http3.parser.MessageParser;
import org.eclipse.jetty.http3.parser.ParserListener;
import org.eclipse.jetty.http3.server.internal.ServerHTTP3Session;
import org.eclipse.jetty.http3.server.internal.ServerHTTP3StreamConnection;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.quic.common.ProtocolSession;
import org.eclipse.jetty.quic.common.QuicSession;
import org.eclipse.jetty.quic.common.QuicStreamEndPoint;
import org.eclipse.jetty.quic.server.ServerQuicSession;
import org.eclipse.jetty.server.AbstractConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;

public abstract class AbstractHTTP3ServerConnectionFactory
extends AbstractConnectionFactory
implements ProtocolSession.Factory {
    private final HTTP3Configuration configuration = new HTTP3Configuration();
    private final HttpConfiguration httpConfiguration;
    private final Session.Server.Listener listener;

    public AbstractHTTP3ServerConnectionFactory(HttpConfiguration httpConfiguration, Session.Server.Listener listener) {
        super("h3");
        this.addBean(this.configuration);
        this.httpConfiguration = Objects.requireNonNull(httpConfiguration);
        this.addBean(httpConfiguration);
        this.listener = listener;
        this.configuration.setUseInputDirectByteBuffers(httpConfiguration.isUseInputDirectByteBuffers());
        this.configuration.setUseOutputDirectByteBuffers(httpConfiguration.isUseOutputDirectByteBuffers());
        this.configuration.setMaxRequestHeadersSize(httpConfiguration.getRequestHeaderSize());
        this.configuration.setMaxResponseHeadersSize(httpConfiguration.getResponseHeaderSize());
    }

    public HttpConfiguration getHttpConfiguration() {
        return this.httpConfiguration;
    }

    public HTTP3Configuration getHTTP3Configuration() {
        return this.configuration;
    }

    public ProtocolSession newProtocolSession(QuicSession quicSession, Map<String, Object> context) {
        return new ServerHTTP3Session(this.getHTTP3Configuration(), (ServerQuicSession)quicSession, this.listener);
    }

    public Connection newConnection(Connector connector, EndPoint endPoint) {
        QuicStreamEndPoint streamEndPoint = (QuicStreamEndPoint)endPoint;
        long streamId = streamEndPoint.getStreamId();
        ServerHTTP3Session http3Session = (ServerHTTP3Session)streamEndPoint.getQuicSession().getProtocolSession();
        MessageParser parser = new MessageParser((ParserListener)http3Session.getSessionServer(), http3Session.getQpackDecoder(), streamId, () -> ((QuicStreamEndPoint)streamEndPoint).isStreamFinished());
        ServerHTTP3StreamConnection connection = new ServerHTTP3StreamConnection(connector, this.getHttpConfiguration(), streamEndPoint, http3Session, parser);
        return this.configure((AbstractConnection)connection, connector, endPoint);
    }
}

