/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.server.internal;

import java.util.EnumSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.http3.HTTP3Session;
import org.eclipse.jetty.http3.HTTP3Stream;
import org.eclipse.jetty.http3.MessageFlusher;
import org.eclipse.jetty.http3.api.Session;
import org.eclipse.jetty.http3.api.Stream;
import org.eclipse.jetty.http3.frames.Frame;
import org.eclipse.jetty.http3.frames.HeadersFrame;
import org.eclipse.jetty.quic.common.QuicStreamEndPoint;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTP3StreamServer
extends HTTP3Stream
implements Stream.Server {
    private static final Logger LOG = LoggerFactory.getLogger(HTTP3StreamServer.class);
    private Stream.Server.Listener listener;

    public HTTP3StreamServer(HTTP3Session session, QuicStreamEndPoint endPoint, boolean local) {
        super(session, endPoint, local);
    }

    public void onRequest(HeadersFrame frame) {
        if (this.validateAndUpdate(EnumSet.of(HTTP3Stream.FrameState.INITIAL), HTTP3Stream.FrameState.HEADER)) {
            this.onHeaders(frame);
            Stream.Server.Listener listener = this.listener = this.notifyRequest(frame);
            if (listener == null) {
                this.getSession().writeMessageFrame(this.getId(), (Frame)new MessageFlusher.FlushFrame(), Callback.NOOP);
            }
            this.updateClose(frame.isLast(), false);
        }
    }

    private Stream.Server.Listener notifyRequest(HeadersFrame frame) {
        Session.Server.Listener listener = (Session.Server.Listener)this.getSession().getListener();
        try {
            return listener.onRequest((Stream.Server)this, frame);
        }
        catch (Throwable x) {
            LOG.info("failure notifying listener {}", (Object)listener, (Object)x);
            return null;
        }
    }

    public CompletableFuture<Stream> respond(HeadersFrame frame) {
        return this.write((Frame)frame);
    }

    protected void notifyDataAvailable() {
        Stream.Server.Listener listener = this.listener;
        try {
            if (listener != null) {
                listener.onDataAvailable((Stream.Server)this);
            }
        }
        catch (Throwable x) {
            LOG.info("failure notifying listener {}", (Object)listener, (Object)x);
        }
    }

    protected void notifyTrailer(HeadersFrame frame) {
        Stream.Server.Listener listener = this.listener;
        try {
            if (listener != null) {
                listener.onTrailer((Stream.Server)this, frame);
            }
        }
        catch (Throwable x) {
            LOG.info("failure notifying listener {}", (Object)listener, (Object)x);
        }
    }

    protected void notifyIdleTimeout(TimeoutException timeout, Promise<Boolean> promise) {
        Stream.Server.Listener listener = this.listener;
        try {
            if (listener != null) {
                listener.onIdleTimeout((Stream.Server)this, timeout, promise);
            } else {
                promise.succeeded((Object)true);
            }
        }
        catch (Throwable x) {
            LOG.info("failure notifying listener {}", (Object)listener, (Object)x);
            promise.failed(x);
        }
    }

    protected void notifyFailure(long error, Throwable failure) {
        Stream.Server.Listener listener = this.listener;
        try {
            if (listener != null) {
                listener.onFailure((Stream.Server)this, error, failure);
            }
        }
        catch (Throwable x) {
            LOG.info("failure notifying listener {}", (Object)listener, (Object)x);
        }
    }
}

