/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.client;

import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.http2.FlowControlStrategy;
import org.eclipse.jetty.http2.HTTP2Connection;
import org.eclipse.jetty.http2.HTTP2Session;
import org.eclipse.jetty.http2.api.Session;
import org.eclipse.jetty.http2.client.HTTP2Client;
import org.eclipse.jetty.http2.client.internal.HTTP2ClientSession;
import org.eclipse.jetty.http2.frames.PrefaceFrame;
import org.eclipse.jetty.http2.frames.SettingsFrame;
import org.eclipse.jetty.http2.frames.WindowUpdateFrame;
import org.eclipse.jetty.http2.generator.Generator;
import org.eclipse.jetty.http2.parser.Parser;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.thread.Invocable;

public class HTTP2ClientConnectionFactory
implements ClientConnectionFactory {
    public static final String CLIENT_CONTEXT_KEY = "org.eclipse.jetty.client.http2";
    public static final String SESSION_LISTENER_CONTEXT_KEY = "org.eclipse.jetty.client.http2.sessionListener";
    public static final String SESSION_PROMISE_CONTEXT_KEY = "org.eclipse.jetty.client.http2.sessionPromise";
    private final Connection.Listener connectionListener = new ConnectionListener();

    public Connection newConnection(EndPoint endPoint, Map<String, Object> context) {
        HTTP2Client client = (HTTP2Client)((Object)context.get(CLIENT_CONTEXT_KEY));
        ByteBufferPool bufferPool = client.getByteBufferPool();
        Session.Listener listener = (Session.Listener)context.get(SESSION_LISTENER_CONTEXT_KEY);
        Promise sessionPromise = (Promise)context.get(SESSION_PROMISE_CONTEXT_KEY);
        Generator generator = new Generator(bufferPool, client.isUseOutputDirectByteBuffers(), client.getMaxHeaderBlockFragment());
        FlowControlStrategy flowControl = client.getFlowControlStrategyFactory().newFlowControlStrategy();
        Parser parser = new Parser(bufferPool, client.getMaxResponseHeadersSize());
        parser.setMaxFrameSize(client.getMaxFrameSize());
        parser.setMaxSettingsKeys(client.getMaxSettingsKeys());
        HTTP2ClientSession session = new HTTP2ClientSession(client.getScheduler(), endPoint, parser, generator, listener, flowControl);
        session.setMaxRemoteStreams(client.getMaxConcurrentPushedStreams());
        session.setMaxEncoderTableCapacity(client.getMaxEncoderTableCapacity());
        long streamIdleTimeout = client.getStreamIdleTimeout();
        if (streamIdleTimeout > 0L) {
            session.setStreamIdleTimeout(streamIdleTimeout);
        }
        HTTP2ClientConnection connection = new HTTP2ClientConnection(client, endPoint, session, (Promise<Session>)sessionPromise, listener);
        context.put(HTTP2Connection.class.getName(), (Object)connection);
        connection.addEventListener((EventListener)this.connectionListener);
        parser.init((Parser.Listener)connection);
        return this.customize((Connection)connection, context);
    }

    private static class ConnectionListener
    implements Connection.Listener {
        private ConnectionListener() {
        }

        public void onOpened(Connection connection) {
            HTTP2ClientConnection http2Connection = (HTTP2ClientConnection)connection;
            http2Connection.client.addManaged((LifeCycle)http2Connection.getSession());
        }

        public void onClosed(Connection connection) {
            HTTP2ClientConnection http2Connection = (HTTP2ClientConnection)connection;
            http2Connection.client.removeBean(http2Connection.getSession());
        }
    }

    private static class HTTP2ClientConnection
    extends HTTP2Connection
    implements Callback {
        private final HTTP2Client client;
        private final Promise<Session> promise;
        private final Session.Listener listener;

        private HTTP2ClientConnection(HTTP2Client client, EndPoint endpoint, HTTP2ClientSession session, Promise<Session> sessionPromise, Session.Listener listener) {
            super(client.getByteBufferPool(), client.getExecutor(), endpoint, (HTTP2Session)session, client.getInputBufferSize());
            this.client = client;
            this.promise = sessionPromise;
            this.listener = listener;
            this.setUseInputDirectByteBuffers(client.isUseInputDirectByteBuffers());
            this.setUseOutputDirectByteBuffers(client.isUseOutputDirectByteBuffers());
        }

        public void onOpen() {
            HashMap<Integer, Integer> settings = this.listener.onPreface((Session)this.getSession());
            if (settings == null) {
                settings = new HashMap<Integer, Integer>();
            }
            settings.compute(1, (k, v) -> {
                if (v == null && (v = Integer.valueOf(this.client.getMaxDecoderTableCapacity())) == 4096) {
                    v = null;
                }
                return v;
            });
            settings.computeIfAbsent(3, k -> this.client.getMaxConcurrentPushedStreams());
            settings.compute(4, (k, v) -> {
                if (v == null && (v = Integer.valueOf(this.client.getInitialStreamRecvWindow())) == 65535) {
                    v = null;
                }
                return v;
            });
            settings.compute(5, (k, v) -> {
                if (v == null && (v = Integer.valueOf(this.client.getMaxFrameSize())) == 16384) {
                    v = null;
                }
                return v;
            });
            settings.compute(6, (k, v) -> {
                if (v == null && (v = Integer.valueOf(this.client.getMaxResponseHeadersSize())) <= 0) {
                    v = null;
                }
                return v;
            });
            PrefaceFrame prefaceFrame = new PrefaceFrame();
            SettingsFrame settingsFrame = new SettingsFrame(settings, false);
            HTTP2Session session = this.getSession();
            int windowDelta = this.client.getInitialSessionRecvWindow() - 65535;
            session.updateRecvWindow(windowDelta);
            if (windowDelta > 0) {
                session.frames(null, List.of(prefaceFrame, settingsFrame, new WindowUpdateFrame(0, windowDelta)), (Callback)this);
            } else {
                session.frames(null, List.of(prefaceFrame, settingsFrame), (Callback)this);
            }
        }

        public void succeeded() {
            super.onOpen();
            this.promise.succeeded((Object)this.getSession());
            this.produce();
        }

        public void failed(Throwable x) {
            this.close();
            this.promise.failed(x);
        }

        public Invocable.InvocationType getInvocationType() {
            return Invocable.InvocationType.NON_BLOCKING;
        }
    }
}

