/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.nested;

import java.io.Serializable;
import java.util.Arrays;

public class ServletConstraint
implements Cloneable,
Serializable {
    public static final int DC_NONE = 0;
    public static final int DC_INTEGRAL = 1;
    public static final int DC_CONFIDENTIAL = 2;
    public static final String NONE = "NONE";
    public static final String ANY_ROLE = "*";
    public static final String ANY_AUTH = "**";
    private String _name;
    private String[] _roles;
    private int _dataConstraint = -1;
    private boolean _anyRole = false;
    private boolean _anyAuth = false;
    private boolean _authenticate = false;

    public ServletConstraint() {
    }

    public ServletConstraint(String name, String role) {
        this.setName(name);
        this.setRoles(new String[]{role});
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public void setRoles(String[] roles) {
        this._roles = roles;
        this._anyRole = false;
        this._anyAuth = false;
        if (roles != null) {
            int i = roles.length;
            while (i-- > 0) {
                this._anyRole |= ANY_ROLE.equals(roles[i]);
                this._anyAuth |= ANY_AUTH.equals(roles[i]);
            }
        }
    }

    public boolean isAnyRole() {
        return this._anyRole;
    }

    public boolean isAnyAuth() {
        return this._anyAuth;
    }

    public String[] getRoles() {
        return this._roles;
    }

    public void setAuthenticate(boolean authenticate) {
        this._authenticate = authenticate;
    }

    public boolean getAuthenticate() {
        return this._authenticate;
    }

    public boolean isForbidden() {
        return this._authenticate && !this._anyRole && (this._roles == null || this._roles.length == 0);
    }

    public void setDataConstraint(int c) {
        if (c < 0 || c > 2) {
            throw new IllegalArgumentException("Constraint out of range");
        }
        this._dataConstraint = c;
    }

    public int getDataConstraint() {
        return this._dataConstraint;
    }

    public String toString() {
        return "SC{" + this._name + "," + (this._anyRole ? ANY_ROLE : (this._roles == null ? "-" : Arrays.asList(this._roles).toString())) + "," + (this._dataConstraint == -1 ? "UNSET}" : (this._dataConstraint == 0 ? "NONE}" : (this._dataConstraint == 1 ? "INTEGRAL}" : "CONFIDENTIAL}")));
    }
}

