/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee11.websocket.jakarta.common.encoders;

import jakarta.websocket.Encoder;
import jakarta.websocket.EndpointConfig;
import java.io.Closeable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.jetty.ee11.websocket.jakarta.common.InitException;
import org.eclipse.jetty.ee11.websocket.jakarta.common.encoders.BooleanEncoder;
import org.eclipse.jetty.ee11.websocket.jakarta.common.encoders.ByteArrayEncoder;
import org.eclipse.jetty.ee11.websocket.jakarta.common.encoders.ByteBufferEncoder;
import org.eclipse.jetty.ee11.websocket.jakarta.common.encoders.ByteEncoder;
import org.eclipse.jetty.ee11.websocket.jakarta.common.encoders.CharacterEncoder;
import org.eclipse.jetty.ee11.websocket.jakarta.common.encoders.DoubleEncoder;
import org.eclipse.jetty.ee11.websocket.jakarta.common.encoders.FloatEncoder;
import org.eclipse.jetty.ee11.websocket.jakarta.common.encoders.IntegerEncoder;
import org.eclipse.jetty.ee11.websocket.jakarta.common.encoders.LongEncoder;
import org.eclipse.jetty.ee11.websocket.jakarta.common.encoders.RegisteredEncoder;
import org.eclipse.jetty.ee11.websocket.jakarta.common.encoders.ShortEncoder;
import org.eclipse.jetty.ee11.websocket.jakarta.common.encoders.StringEncoder;
import org.eclipse.jetty.websocket.core.WebSocketComponents;
import org.eclipse.jetty.websocket.core.exception.InvalidSignatureException;
import org.eclipse.jetty.websocket.core.exception.InvalidWebSocketException;
import org.eclipse.jetty.websocket.core.util.ReflectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvailableEncoders
implements Predicate<Class<?>>,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(AvailableEncoders.class);
    private final EndpointConfig config;
    private final WebSocketComponents components;
    private final LinkedList<RegisteredEncoder> registeredEncoders;

    public AvailableEncoders(EndpointConfig config, WebSocketComponents components) {
        this.config = Objects.requireNonNull(config);
        this.components = Objects.requireNonNull(components);
        this.registeredEncoders = new LinkedList();
        this.registerPrimitive(BooleanEncoder.class, Encoder.Text.class, Boolean.class);
        this.registerPrimitive(ByteEncoder.class, Encoder.Text.class, Byte.class);
        this.registerPrimitive(CharacterEncoder.class, Encoder.Text.class, Character.class);
        this.registerPrimitive(DoubleEncoder.class, Encoder.Text.class, Double.class);
        this.registerPrimitive(FloatEncoder.class, Encoder.Text.class, Float.class);
        this.registerPrimitive(ShortEncoder.class, Encoder.Text.class, Short.class);
        this.registerPrimitive(IntegerEncoder.class, Encoder.Text.class, Integer.class);
        this.registerPrimitive(LongEncoder.class, Encoder.Text.class, Long.class);
        this.registerPrimitive(StringEncoder.class, Encoder.Text.class, String.class);
        this.registerPrimitive(BooleanEncoder.class, Encoder.Text.class, Boolean.TYPE);
        this.registerPrimitive(ByteEncoder.class, Encoder.Text.class, Byte.TYPE);
        this.registerPrimitive(CharacterEncoder.class, Encoder.Text.class, Character.TYPE);
        this.registerPrimitive(DoubleEncoder.class, Encoder.Text.class, Double.TYPE);
        this.registerPrimitive(FloatEncoder.class, Encoder.Text.class, Float.TYPE);
        this.registerPrimitive(ShortEncoder.class, Encoder.Text.class, Short.TYPE);
        this.registerPrimitive(IntegerEncoder.class, Encoder.Text.class, Integer.TYPE);
        this.registerPrimitive(LongEncoder.class, Encoder.Text.class, Long.TYPE);
        this.registerPrimitive(ByteBufferEncoder.class, Encoder.Binary.class, ByteBuffer.class);
        this.registerPrimitive(ByteArrayEncoder.class, Encoder.Binary.class, byte[].class);
        this.registerAll(config.getEncoders());
    }

    private void registerPrimitive(Class<? extends Encoder> encoderClass, Class<? extends Encoder> interfaceType, Class<?> type) {
        this.registeredEncoders.add(new RegisteredEncoder(encoderClass, interfaceType, type, true));
    }

    public void register(Class<? extends Encoder> encoder) {
        if (!ReflectUtils.isDefaultConstructable(encoder)) {
            throw new InvalidSignatureException("Encoder must have public, no-args constructor: " + encoder.getName());
        }
        boolean foundEncoder = false;
        if (Encoder.Binary.class.isAssignableFrom(encoder)) {
            this.add(encoder, Encoder.Binary.class);
            foundEncoder = true;
        }
        if (Encoder.BinaryStream.class.isAssignableFrom(encoder)) {
            this.add(encoder, Encoder.BinaryStream.class);
            foundEncoder = true;
        }
        if (Encoder.Text.class.isAssignableFrom(encoder)) {
            this.add(encoder, Encoder.Text.class);
            foundEncoder = true;
        }
        if (Encoder.TextStream.class.isAssignableFrom(encoder)) {
            this.add(encoder, Encoder.TextStream.class);
            foundEncoder = true;
        }
        if (!foundEncoder) {
            throw new InvalidSignatureException("Not a valid Encoder class: " + encoder.getName() + " implements no " + Encoder.class.getName() + " interfaces");
        }
    }

    public void registerAll(Class<? extends Encoder>[] encoders) {
        if (encoders == null) {
            return;
        }
        for (Class<? extends Encoder> encoder : encoders) {
            this.register(encoder);
        }
    }

    public void registerAll(List<Class<? extends Encoder>> encoders) {
        if (encoders == null) {
            return;
        }
        encoders.forEach(this::register);
    }

    private void add(Class<? extends Encoder> encoder, Class<? extends Encoder> interfaceClass) {
        Type objectType = ReflectUtils.findGenericTypeFor(encoder, interfaceClass);
        if (objectType == null) {
            StringBuilder err = new StringBuilder();
            err.append("Invalid Encoder Object type declared for interface ");
            err.append(interfaceClass.getName());
            err.append(" on class ");
            err.append(encoder);
            throw new InvalidWebSocketException(err.toString());
        }
        this.registeredEncoders.addFirst(new RegisteredEncoder(encoder, interfaceClass, objectType));
    }

    public List<RegisteredEncoder> supporting(Class<? extends Encoder> interfaceType) {
        return this.registeredEncoders.stream().filter(registered -> registered.implementsInterface(interfaceType)).collect(Collectors.toList());
    }

    public RegisteredEncoder getRegisteredEncoderFor(Class<?> type) {
        return this.registeredEncoders.stream().filter(registered -> registered.isType(type)).findFirst().get();
    }

    public Class<? extends Encoder> getEncoderFor(Class<?> type) {
        try {
            return this.getRegisteredEncoderFor(type).encoder;
        }
        catch (NoSuchElementException e) {
            throw new InvalidWebSocketException("No Encoder found for type " + String.valueOf(type));
        }
    }

    public Encoder getInstanceFor(Class<?> type) {
        try {
            RegisteredEncoder registeredEncoder = this.getRegisteredEncoderFor(type);
            if (registeredEncoder.instance != null) {
                return registeredEncoder.instance;
            }
            registeredEncoder.instance = (Encoder)this.components.getObjectFactory().createInstance(registeredEncoder.encoder);
            registeredEncoder.instance.init(this.config);
            return registeredEncoder.instance;
        }
        catch (NoSuchElementException e) {
            throw new InvalidWebSocketException("No Encoder found for type " + String.valueOf(type));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new InitException("Unable to init Encoder for type:" + type.getName(), e);
        }
    }

    @Override
    public boolean test(Class<?> type) {
        return this.registeredEncoders.stream().anyMatch(registered -> registered.isType(type));
    }

    @Override
    public void close() {
        this.registeredEncoders.forEach(RegisteredEncoder::destroyInstance);
    }
}

