/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.webapp;

import jakarta.servlet.HttpConstraintElement;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.ServletSecurityElement;
import jakarta.servlet.http.HttpSessionActivationListener;
import jakarta.servlet.http.HttpSessionAttributeListener;
import jakarta.servlet.http.HttpSessionBindingListener;
import jakarta.servlet.http.HttpSessionIdListener;
import jakarta.servlet.http.HttpSessionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jetty.ee.WebAppClassLoading;
import org.eclipse.jetty.ee10.servlet.ErrorHandler;
import org.eclipse.jetty.ee10.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletHandler;
import org.eclipse.jetty.ee10.servlet.SessionHandler;
import org.eclipse.jetty.ee10.servlet.security.ConstraintAware;
import org.eclipse.jetty.ee10.servlet.security.ConstraintMapping;
import org.eclipse.jetty.ee10.servlet.security.ConstraintSecurityHandler;
import org.eclipse.jetty.ee10.webapp.ClassMatcher;
import org.eclipse.jetty.ee10.webapp.Configuration;
import org.eclipse.jetty.ee10.webapp.Configurations;
import org.eclipse.jetty.ee10.webapp.MetaData;
import org.eclipse.jetty.ee10.webapp.Origin;
import org.eclipse.jetty.ee10.webapp.WebAppClassLoader;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Deployable;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.ExceptionUtil;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.ClassLoaderDump;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.DumpableCollection;
import org.eclipse.jetty.util.component.Environment;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.eclipse.jetty.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject(value="Web Application ContextHandler")
public class WebAppContext
extends ServletContextHandler
implements WebAppClassLoader.Context,
Deployable {
    static final Logger LOG = LoggerFactory.getLogger(WebAppContext.class);
    public static final String WEB_DEFAULTS_XML = "org/eclipse/jetty/ee10/webapp/webdefault-ee10.xml";
    @Deprecated(forRemoval=true, since="12.0.9")
    public static final String SERVER_SYS_CLASSES = "org.eclipse.jetty.webapp.systemClasses";
    @Deprecated(forRemoval=true, since="12.0.9")
    public static final String SERVER_SRV_CLASSES = "org.eclipse.jetty.webapp.serverClasses";
    private static final String[] __dftProtectedTargets = new String[]{"/WEB-INF", "/META-INF"};
    @Deprecated(forRemoval=true, since="12.0.9")
    public static final ClassMatcher __dftSystemClasses = ClassMatcher.wrap(WebAppClassLoading.DEFAULT_PROTECTED_CLASSES);
    @Deprecated(forRemoval=true, since="12.0.9")
    public static final ClassMatcher __dftServerClasses = ClassMatcher.wrap(WebAppClassLoading.DEFAULT_HIDDEN_CLASSES);
    private final org.eclipse.jetty.util.ClassMatcher _protectedClasses = new org.eclipse.jetty.util.ClassMatcher(WebAppClassLoading.getProtectedClasses((Environment)ServletContextHandler.ENVIRONMENT));
    private final org.eclipse.jetty.util.ClassMatcher _hiddenClasses = new org.eclipse.jetty.util.ClassMatcher(WebAppClassLoading.getHiddenClasses((Environment)ServletContextHandler.ENVIRONMENT));
    private Configurations _configurations;
    private String _defaultsDescriptor = "org/eclipse/jetty/ee10/webapp/webdefault-ee10.xml";
    private String _descriptor = null;
    private final List<String> _overrideDescriptors = new ArrayList<String>();
    private boolean _distributable = false;
    private boolean _extractWAR = true;
    private boolean _copyDir = false;
    private boolean _copyWebInf = false;
    private boolean _logUrlOnStart = false;
    private boolean _parentLoaderPriority = Boolean.getBoolean("org.eclipse.jetty.server.webapp.parentLoaderPriority");
    private PermissionCollection _permissions;
    private boolean _defaultContextPath = true;
    private String[] _contextWhiteList = null;
    private String _war;
    private List<Resource> _extraClasspath;
    private Throwable _unavailableException;
    private Map<String, String> _resourceAliases;
    private ClassLoader _initialClassLoader;
    private boolean _configurationDiscovered = true;
    private boolean _allowDuplicateFragmentNames = false;
    private boolean _throwUnavailableOnStartupException = false;
    private MetaData _metadata = new MetaData();

    public static WebAppContext getCurrentWebAppContext() {
        ServletContextHandler handler = ServletContextHandler.getCurrentServletContextHandler();
        if (handler != null && handler instanceof WebAppContext) {
            return (WebAppContext)handler;
        }
        return null;
    }

    public WebAppContext() {
        this(null, null, null, null, (ErrorHandler)new ErrorPageErrorHandler(), 3);
    }

    public WebAppContext(String webApp, String contextPath) {
        this(contextPath, null, null, null, (ErrorHandler)new ErrorPageErrorHandler(), 3);
        this.setWar(webApp);
    }

    public WebAppContext(Resource webApp, String contextPath) {
        this(contextPath, null, null, null, (ErrorHandler)new ErrorPageErrorHandler(), 3);
        this.setWarResource(webApp);
    }

    public WebAppContext(SessionHandler sessionHandler, SecurityHandler securityHandler, ServletHandler servletHandler, ErrorHandler errorHandler) {
        this(null, sessionHandler, securityHandler, servletHandler, errorHandler, 0);
    }

    public WebAppContext(String contextPath, SessionHandler sessionHandler, SecurityHandler securityHandler, ServletHandler servletHandler, ErrorHandler errorHandler, int options) {
        super(contextPath, sessionHandler, securityHandler, servletHandler, errorHandler, options);
        this.setErrorHandler((Request.Handler)(errorHandler != null ? errorHandler : new ErrorPageErrorHandler()));
        this.setProtectedTargets(__dftProtectedTargets);
    }

    public void initializeDefaults(Map<String, String> properties) {
        block24: for (String property : properties.keySet()) {
            String value = properties.get(property);
            if (LOG.isDebugEnabled()) {
                LOG.debug("init {}: {}", (Object)property, (Object)value);
            }
            switch (property) {
                case "jetty.deploy.war": {
                    if (this.getWar() != null) continue block24;
                    this.setWar(value);
                    continue block24;
                }
                case "jetty.deploy.tempDir": {
                    this.setTempDirectory(IO.asFile((Object)value));
                    continue block24;
                }
                case "jetty.deploy.configurationClasses": {
                    this.setConfigurationClasses(value == null ? null : value.split(","));
                    continue block24;
                }
                case "jetty.deploy.containerScanJarPattern": {
                    this.setAttribute("org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern", value);
                    continue block24;
                }
                case "jetty.deploy.extractWars": {
                    this.setExtractWAR(Boolean.parseBoolean(value));
                    continue block24;
                }
                case "jetty.deploy.parentLoaderPriority": {
                    this.setParentLoaderPriority(Boolean.parseBoolean(value));
                    continue block24;
                }
                case "jetty.deploy.webInfScanJarPattern": {
                    this.setAttribute("org.eclipse.jetty.server.webapp.WebInfIncludeJarPattern", value);
                    continue block24;
                }
                case "jetty.deploy.defaultsDescriptor": {
                    this.setDefaultsDescriptor(value);
                    continue block24;
                }
                case "jetty.deploy.servletContainerInitializerExclusionPattern": {
                    this.setAttribute("org.eclipse.jetty.containerInitializerExclusionPattern", value);
                    continue block24;
                }
                case "jetty.deploy.servletContainerInitializerOrder": {
                    this.setAttribute("org.eclipse.jetty.containerInitializerOrder", value);
                    continue block24;
                }
            }
            if (!LOG.isDebugEnabled() || !StringUtil.isNotBlank((String)value)) continue;
            LOG.debug("unknown property {}={}", (Object)property, (Object)value);
        }
        this._defaultContextPath = true;
    }

    public boolean isContextPathDefault() {
        return this._defaultContextPath;
    }

    public void setContextPath(String contextPath) {
        super.setContextPath(contextPath);
        this._defaultContextPath = false;
    }

    public void setDefaultContextPath(String contextPath) {
        super.setContextPath(contextPath);
        this._defaultContextPath = true;
    }

    public void setDisplayName(String servletContextName) {
        super.setDisplayName(servletContextName);
        ClassLoader cl = this.getClassLoader();
        if (servletContextName != null && cl instanceof WebAppClassLoader) {
            WebAppClassLoader webAppClassLoader = (WebAppClassLoader)cl;
            webAppClassLoader.setName(servletContextName);
        }
    }

    public Throwable getUnavailableException() {
        return this._unavailableException;
    }

    public void setResourceAlias(String alias, String uri) {
        if (this._resourceAliases == null) {
            this._resourceAliases = new HashMap<String, String>(5);
        }
        this._resourceAliases.put(alias, uri);
    }

    public Map<String, String> getResourceAliases() {
        if (this._resourceAliases == null) {
            return null;
        }
        return this._resourceAliases;
    }

    public void setResourceAliases(Map<String, String> map) {
        this._resourceAliases = map;
    }

    public String getResourceAlias(String path) {
        if (this._resourceAliases == null) {
            return null;
        }
        Object alias = this._resourceAliases.get(path);
        int slash = path.length();
        while (alias == null && (slash = path.lastIndexOf("/", slash - 1)) >= 0) {
            String match = this._resourceAliases.get(path.substring(0, slash + 1));
            if (match == null) continue;
            alias = match + path.substring(slash + 1);
        }
        return alias;
    }

    public String removeResourceAlias(String alias) {
        if (this._resourceAliases == null) {
            return null;
        }
        return this._resourceAliases.remove(alias);
    }

    public void setClassLoader(ClassLoader classLoader) {
        super.setClassLoader(classLoader);
        String name = this.getDisplayName();
        if (name == null) {
            name = this.getContextPath();
        }
        if (classLoader instanceof WebAppClassLoader) {
            WebAppClassLoader webAppClassLoader = (WebAppClassLoader)classLoader;
            if (this.getDisplayName() != null) {
                webAppClassLoader.setName(name);
            }
        }
    }

    public ResourceFactory getResourceFactory() {
        return ResourceFactory.of((Container)this);
    }

    public Resource getResource(String pathInContext) throws MalformedURLException {
        if (pathInContext == null || !pathInContext.startsWith("/")) {
            throw new MalformedURLException(pathInContext);
        }
        MalformedURLException mue = null;
        Resource resource = null;
        int loop = 0;
        while (pathInContext != null && loop++ < 100) {
            try {
                resource = super.getResource(pathInContext);
                if (Resources.exists((Resource)resource)) {
                    return resource;
                }
                pathInContext = this.getResourceAlias(pathInContext);
            }
            catch (MalformedURLException e) {
                LOG.trace("IGNORED", (Throwable)e);
                if (mue != null) continue;
                mue = e;
            }
            catch (Throwable t) {
                if (mue != null) continue;
                mue = new MalformedURLException(pathInContext);
            }
        }
        if (mue != null) {
            throw mue;
        }
        return resource;
    }

    public boolean isConfigurationDiscovered() {
        return this._configurationDiscovered;
    }

    public void setConfigurationDiscovered(boolean discovered) {
        this._configurationDiscovered = discovered;
    }

    public void preConfigure() throws Exception {
        for (Configuration configuration : Configurations.getKnown()) {
            this._hiddenClasses.include(configuration.getHiddenClasses().getInclusions());
        }
        this.loadConfigurations();
        this._configurations.sort();
        for (Configuration configuration : this._configurations) {
            this._protectedClasses.add(configuration.getProtectedClasses().getPatterns());
            this._hiddenClasses.exclude(configuration.getHiddenClasses().getExclusions());
        }
        this._initialClassLoader = this.getClassLoader();
        ClassLoader loader = this.configureClassLoader(this._initialClassLoader);
        if (loader != this._initialClassLoader) {
            this.setClassLoader(loader);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Thread Context classloader {}", (Object)loader);
            for (loader = loader.getParent(); loader != null; loader = loader.getParent()) {
                LOG.debug("Parent class loader: {} ", (Object)loader);
            }
        }
        this._configurations.preConfigure(this);
    }

    protected ClassLoader configureClassLoader(ClassLoader loader) {
        if (loader instanceof WebAppClassLoader) {
            return loader;
        }
        return new WebAppClassLoader(loader, this);
    }

    protected void createTempDirectory() {
        super.createTempDirectory();
    }

    public boolean configure() throws Exception {
        return this._configurations.configure(this);
    }

    public void postConfigure() throws Exception {
        this._configurations.postConfigure(this);
    }

    protected void doStart() throws Exception {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(ServletContextHandler.ENVIRONMENT.getClassLoader());
        try {
            this._metadata.setAllowDuplicateFragmentNames(this.isAllowDuplicateFragmentNames());
            Boolean validate = (Boolean)this.getAttribute("org.eclipse.jetty.webapp.validateXml");
            this._metadata.setValidateXml(validate != null && validate != false);
            this.preConfigure();
            super.doStart();
            this.postConfigure();
            if (this.isLogUrlOnStart()) {
                this.dumpUrl();
            }
        }
        catch (Throwable t) {
            LOG.warn("Failed startup of context {}", (Object)this, (Object)t);
            this._unavailableException = t;
            this.setAvailable(false);
            if (this.isThrowUnavailableOnStartupException()) {
                throw t;
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public void destroy() {
        Throwable multiException = null;
        if (this._configurations != null) {
            for (Configuration configuration : this._configurations) {
                try {
                    configuration.destroy(this);
                }
                catch (Exception e) {
                    multiException = ExceptionUtil.combine(multiException, (Throwable)e);
                }
            }
        }
        this._configurations = null;
        super.destroy();
        ExceptionUtil.ifExceptionThrowUnchecked(multiException);
    }

    private void dumpUrl() {
        Object[] connectors;
        for (Connector connector : connectors = this.getServer().getConnectors()) {
            Object displayName = this.getDisplayName();
            if (displayName == null) {
                displayName = "WebApp@" + Arrays.hashCode(connectors);
            }
            LOG.info("{} at http://{}{}", new Object[]{displayName, connector.toString(), this.getContextPath()});
        }
    }

    @ManagedAttribute(value="configuration classes used to configure webapp", readonly=true)
    public String[] getConfigurationClasses() {
        this.loadConfigurations();
        return this._configurations.toStringArray();
    }

    public Configurations getConfigurations() {
        this.loadConfigurations();
        return this._configurations;
    }

    @ManagedAttribute(value="default web.xml deascriptor applied before standard web.xml", readonly=true)
    public String getDefaultsDescriptor() {
        return this._defaultsDescriptor;
    }

    public String getOverrideDescriptor() {
        if (this._overrideDescriptors.size() != 1) {
            return null;
        }
        return this._overrideDescriptors.get(0);
    }

    @ManagedAttribute(value="web.xml deascriptors applied after standard web.xml", readonly=true)
    public List<String> getOverrideDescriptors() {
        return Collections.unmodifiableList(this._overrideDescriptors);
    }

    @Override
    public PermissionCollection getPermissions() {
        return this._permissions;
    }

    public void setHiddenClassMatcher(org.eclipse.jetty.util.ClassMatcher hiddenClasses) {
        this._hiddenClasses.clear();
        this._hiddenClasses.add(hiddenClasses.getPatterns());
    }

    public void setProtectedClassMatcher(org.eclipse.jetty.util.ClassMatcher protectedClasses) {
        this._protectedClasses.clear();
        this._protectedClasses.add(protectedClasses.getPatterns());
    }

    public void addHiddenClassMatcher(org.eclipse.jetty.util.ClassMatcher hiddenClasses) {
        this._hiddenClasses.add(hiddenClasses.getPatterns());
    }

    public void addProtectedClassMatcher(org.eclipse.jetty.util.ClassMatcher protectedClasses) {
        this._protectedClasses.add(protectedClasses.getPatterns());
    }

    public org.eclipse.jetty.util.ClassMatcher getProtectedClassMatcher() {
        return this._protectedClasses;
    }

    public org.eclipse.jetty.util.ClassMatcher getHiddenClassMatcher() {
        return this._hiddenClasses;
    }

    @ManagedAttribute(value="classes and packages protected by context classloader", readonly=true)
    public String[] getProtectedClasses() {
        return this._protectedClasses.getPatterns();
    }

    @ManagedAttribute(value="classes and packages hidden by the context classloader", readonly=true)
    public String[] getHiddenClasses() {
        return this._hiddenClasses.getPatterns();
    }

    public boolean isHiddenClass(Class<?> clazz) {
        return this._hiddenClasses.match(clazz);
    }

    public boolean isProtectedClass(Class<?> clazz) {
        return this._protectedClasses.match(clazz);
    }

    @Override
    public boolean isHiddenResource(String name, URL url) {
        return this._hiddenClasses.match(name, url);
    }

    @Override
    public boolean isProtectedResource(String name, URL url) {
        return this._protectedClasses.match(name, url);
    }

    @Deprecated(since="12.0.8", forRemoval=true)
    public void setServerClassMatcher(ClassMatcher serverClasses) {
        this.setHiddenClassMatcher(serverClasses);
    }

    @Deprecated(since="12.0.8", forRemoval=true)
    public void setSystemClassMatcher(ClassMatcher systemClasses) {
        this.setProtectedClassMatcher(systemClasses);
    }

    @Deprecated(since="12.0.8", forRemoval=true)
    public void addServerClassMatcher(ClassMatcher serverClasses) {
        this.addHiddenClassMatcher(serverClasses);
    }

    @Deprecated(since="12.0.8", forRemoval=true)
    public void addSystemClassMatcher(ClassMatcher systemClasses) {
        this.addProtectedClassMatcher(systemClasses);
    }

    @Deprecated(since="12.0.8", forRemoval=true)
    public ClassMatcher getSystemClassMatcher() {
        return ClassMatcher.wrap(this.getProtectedClassMatcher());
    }

    @Deprecated(since="12.0.8", forRemoval=true)
    public ClassMatcher getServerClassMatcher() {
        return ClassMatcher.wrap(this.getHiddenClassMatcher());
    }

    @Deprecated(since="12.0.8", forRemoval=true)
    public String[] getSystemClasses() {
        return this.getProtectedClasses();
    }

    @Deprecated(since="12.0.8", forRemoval=true)
    public String[] getServerClasses() {
        return this.getHiddenClasses();
    }

    @Deprecated(since="12.0.8", forRemoval=true)
    public boolean isServerClass(Class<?> clazz) {
        return this.isHiddenClass(clazz);
    }

    @Deprecated(since="12.0.8", forRemoval=true)
    public boolean isSystemClass(Class<?> clazz) {
        return this.isProtectedClass(clazz);
    }

    public void setServer(Server server) {
        super.setServer(server);
        if (server != null) {
            this._protectedClasses.add(WebAppClassLoading.getProtectedClasses((Server)server).getPatterns());
            this._hiddenClasses.add(WebAppClassLoading.getHiddenClasses((Server)server).getPatterns());
        }
    }

    @ManagedAttribute(value="war file location", readonly=true)
    public String getWar() {
        Path warPath;
        if (this._war == null && this.getBaseResource() != null && (warPath = this.getBaseResource().getPath()) != null) {
            this._war = warPath.toUri().toASCIIString();
        }
        return this._war;
    }

    public Resource getWebInf() throws IOException {
        if (this.getBaseResource() == null) {
            return null;
        }
        Resource webInf = this.getBaseResource().resolve("WEB-INF/");
        if (Resources.isReadableDirectory((Resource)webInf)) {
            return webInf;
        }
        return null;
    }

    @ManagedAttribute(value="web application distributable")
    public boolean isDistributable() {
        return this._distributable;
    }

    @ManagedAttribute(value="extract war", readonly=true)
    public boolean isExtractWAR() {
        return this._extractWAR;
    }

    @ManagedAttribute(value="webdir copied on deploy (allows hot replacement on windows)", readonly=true)
    public boolean isCopyWebDir() {
        return this._copyDir;
    }

    public boolean isCopyWebInf() {
        return this._copyWebInf;
    }

    @Override
    @ManagedAttribute(value="parent classloader given priority", readonly=true)
    public boolean isParentLoaderPriority() {
        return this._parentLoaderPriority;
    }

    protected void loadConfigurations() {
        if (this._configurations != null) {
            return;
        }
        if (this.isStarted()) {
            throw new IllegalStateException();
        }
        this._configurations = this.newConfigurations();
    }

    protected Configurations newConfigurations() {
        return new Configurations(Configurations.getServerDefault(this.getServer()).getConfigurations());
    }

    public ServletContextHandler.ServletContextApi newServletContextApi() {
        return new ServletApiContext();
    }

    public String toString() {
        if (this._war != null) {
            return super.toString() + "{" + this._war + "}";
        }
        return super.toString();
    }

    public void dump(Appendable out, String indent) throws IOException {
        String name;
        ArrayList systemClasses = null;
        if (this._protectedClasses != null) {
            systemClasses = new ArrayList(this._protectedClasses);
            Collections.sort(systemClasses);
        }
        ArrayList serverClasses = null;
        if (this._hiddenClasses != null) {
            serverClasses = new ArrayList(this._hiddenClasses);
            Collections.sort(serverClasses);
        }
        if ((name = this.getDisplayName()) == null) {
            if (this._war != null) {
                int webapps = this._war.indexOf("/webapps/");
                name = webapps >= 0 ? this._war.substring(webapps + 8) : this._war;
            } else if (this.getBaseResource() != null) {
                name = this.getBaseResource().getURI().toASCIIString();
                int webapps = name.indexOf("/webapps/");
                if (webapps >= 0) {
                    name = name.substring(webapps + 8);
                }
            } else {
                name = this.getClass().getSimpleName();
            }
        }
        name = String.format("%s@%x", name, this.hashCode());
        this.dumpObjects(out, indent, new Object[]{Dumpable.named((String)"environment", (Object)ServletContextHandler.ENVIRONMENT.getName()), new ClassLoaderDump(this.getClassLoader()), new DumpableCollection("Systemclasses " + name, systemClasses), new DumpableCollection("Serverclasses " + name, serverClasses), new DumpableCollection("Configurations " + name, (Collection)this._configurations), new DumpableCollection("Handler attributes " + name, this.asAttributeMap().entrySet()), new DumpableCollection("Context attributes " + name, this.getContext().asAttributeMap().entrySet()), Dumpable.named((String)"maxFormKeys ", (Object)this.getMaxFormKeys()), Dumpable.named((String)"maxFormContentSize ", (Object)this.getMaxFormContentSize()), new DumpableCollection("EventListeners " + String.valueOf(this), (Collection)this.getEventListeners()), new DumpableCollection("Initparams " + name, this.getInitParams().entrySet())});
    }

    public void setConfigurationClasses(String[] configurations) {
        if (this._configurations == null) {
            this._configurations = new Configurations();
        }
        this._configurations.set(configurations);
    }

    public void setConfigurationClasses(List<String> configurations) {
        this.setConfigurationClasses(configurations.toArray(new String[0]));
    }

    public void setConfigurations(Configurations configurations) {
        this._configurations = configurations == null ? new Configurations() : configurations;
    }

    public void setConfigurations(Configuration[] configurations) {
        if (this._configurations == null) {
            this._configurations = new Configurations();
        }
        this._configurations.set(configurations);
    }

    public void addConfiguration(Configuration ... configuration) {
        this.loadConfigurations();
        this._configurations.add(configuration);
    }

    public <T> T getConfiguration(Class<? extends T> configClass) {
        this.loadConfigurations();
        return this._configurations.get(configClass);
    }

    public void removeConfiguration(Configuration ... configurations) {
        if (this._configurations != null) {
            this._configurations.remove(configurations);
        }
    }

    public void removeConfiguration(Class<? extends Configuration> ... configurations) {
        if (this._configurations != null) {
            this._configurations.remove(configurations);
        }
    }

    public void setDefaultsDescriptor(String defaultsDescriptor) {
        this._defaultsDescriptor = defaultsDescriptor;
    }

    public void setOverrideDescriptor(String overrideDescriptor) {
        this._overrideDescriptors.clear();
        this._overrideDescriptors.add(overrideDescriptor);
    }

    public void setOverrideDescriptors(List<String> overrideDescriptors) {
        this._overrideDescriptors.clear();
        this._overrideDescriptors.addAll(overrideDescriptors);
    }

    public void addOverrideDescriptor(String overrideDescriptor) {
        this._overrideDescriptors.add(overrideDescriptor);
    }

    @ManagedAttribute(value="standard web.xml descriptor", readonly=true)
    public String getDescriptor() {
        return this._descriptor;
    }

    public void setDescriptor(String descriptor) {
        this._descriptor = descriptor;
    }

    public void setDistributable(boolean distributable) {
        this._distributable = distributable;
    }

    public boolean removeEventListener(EventListener listener) {
        if (super.removeEventListener(listener)) {
            if ((listener instanceof HttpSessionActivationListener || listener instanceof HttpSessionAttributeListener || listener instanceof HttpSessionBindingListener || listener instanceof HttpSessionListener || listener instanceof HttpSessionIdListener) && this._sessionHandler != null) {
                this._sessionHandler.removeEventListener(listener);
            }
            return true;
        }
        return false;
    }

    public void setExtractWAR(boolean extractWAR) {
        this._extractWAR = extractWAR;
    }

    public void setCopyWebDir(boolean copy) {
        this._copyDir = copy;
    }

    public void setCopyWebInf(boolean copyWebInf) {
        this._copyWebInf = copyWebInf;
    }

    public void setParentLoaderPriority(boolean java2compliant) {
        this._parentLoaderPriority = java2compliant;
    }

    public void setPermissions(PermissionCollection permissions) {
        this._permissions = permissions;
    }

    public void setContextWhiteList(String ... contextWhiteList) {
        this._contextWhiteList = contextWhiteList;
    }

    public void setWar(String war) {
        this._war = war;
    }

    public void setWarResource(Resource war) {
        this.setWar(war == null ? null : war.toString());
    }

    @Override
    @ManagedAttribute(value="extra classpath for context classloader", readonly=true)
    public List<Resource> getExtraClasspath() {
        return this._extraClasspath == null ? Collections.emptyList() : this._extraClasspath;
    }

    public void setExtraClasspath(String extraClasspath) {
        this.setExtraClasspath(this.getResourceFactory().split(extraClasspath, File.pathSeparator, true));
    }

    public void setExtraClasspath(List<Resource> extraClasspath) {
        this._extraClasspath = extraClasspath;
    }

    public boolean isLogUrlOnStart() {
        return this._logUrlOnStart;
    }

    public void setLogUrlOnStart(boolean logOnStart) {
        this._logUrlOnStart = logOnStart;
    }

    public boolean isAllowDuplicateFragmentNames() {
        return this._allowDuplicateFragmentNames;
    }

    public void setAllowDuplicateFragmentNames(boolean allowDuplicateFragmentNames) {
        this._allowDuplicateFragmentNames = allowDuplicateFragmentNames;
    }

    public void setThrowUnavailableOnStartupException(boolean throwIfStartupException) {
        this._throwUnavailableOnStartupException = throwIfStartupException;
    }

    public boolean isThrowUnavailableOnStartupException() {
        return this._throwUnavailableOnStartupException;
    }

    protected void startContext() throws Exception {
        if (this.configure()) {
            this._metadata.resolve(this);
            this.startWebapp();
        }
    }

    protected void stopContext() throws Exception {
        this.stopWebapp();
        try {
            int i = this._configurations.size();
            while (i-- > 0) {
                this._configurations.get(i).deconfigure(this);
            }
            if (this._metadata != null) {
                this._metadata.clear();
            }
            this._metadata = new MetaData();
        }
        finally {
            ClassLoader loader = this.getClassLoader();
            if (loader != this._initialClassLoader) {
                if (loader instanceof URLClassLoader) {
                    URLClassLoader urlClassLoader = (URLClassLoader)loader;
                    urlClassLoader.close();
                }
                this.setClassLoader(this._initialClassLoader);
            }
            this._unavailableException = null;
            super.cleanupAfterStop();
        }
    }

    protected void startWebapp() throws Exception {
        super.startContext();
    }

    protected void stopWebapp() throws Exception {
        super.stopContext();
    }

    protected void cleanupAfterStop() throws Exception {
    }

    public Set<String> setServletSecurity(ServletRegistration.Dynamic registration, ServletSecurityElement servletSecurityElement) {
        Object object;
        HashSet<String> unchangedURLMappings = new HashSet<String>();
        Collection pathMappings = registration.getMappings();
        if (pathMappings != null && (object = this.getSecurityHandler()) instanceof ConstraintAware) {
            ConstraintAware constraintAware = (ConstraintAware)object;
            ConstraintSecurityHandler.createConstraint((String)registration.getName(), (HttpConstraintElement)servletSecurityElement);
            block5: for (String pathSpec : pathMappings) {
                Origin origin = this.getMetaData().getOrigin("constraint.url." + pathSpec);
                switch (origin) {
                    case NotSet: {
                        List mappings = ConstraintSecurityHandler.createConstraintsWithMappingsForPath((String)registration.getName(), (String)pathSpec, (ServletSecurityElement)servletSecurityElement);
                        for (ConstraintMapping m : mappings) {
                            constraintAware.addConstraintMapping(m);
                        }
                        constraintAware.checkPathsWithUncoveredHttpMethods();
                        this.getMetaData().setOriginAPI("constraint.url." + pathSpec);
                        continue block5;
                    }
                    case WebXml: 
                    case WebDefaults: 
                    case WebOverride: 
                    case WebFragment: {
                        unchangedURLMappings.add(pathSpec);
                        continue block5;
                    }
                    case Annotation: 
                    case API: {
                        List constraintMappings = ConstraintSecurityHandler.removeConstraintMappingsForPath((String)pathSpec, (List)constraintAware.getConstraintMappings());
                        List freshMappings = ConstraintSecurityHandler.createConstraintsWithMappingsForPath((String)registration.getName(), (String)pathSpec, (ServletSecurityElement)servletSecurityElement);
                        constraintMappings.addAll(freshMappings);
                        ((ConstraintSecurityHandler)this.getSecurityHandler()).setConstraintMappings(constraintMappings);
                        constraintAware.checkPathsWithUncoveredHttpMethods();
                        continue block5;
                    }
                }
                throw new IllegalStateException(origin.toString());
            }
        }
        return unchangedURLMappings;
    }

    public MetaData getMetaData() {
        return this._metadata;
    }

    protected void makeTempDirectory() throws Exception {
        super.makeTempDirectory();
    }

    protected String getCanonicalNameForTmpDir() {
        return super.getCanonicalNameForTmpDir();
    }

    protected Resource getResourceForTempDirName() {
        Resource resource = super.getResourceForTempDirName();
        if (resource == null) {
            if (this.getWar() == null || this.getWar().length() == 0) {
                throw new IllegalStateException("No resourceBase or war set for context");
            }
            resource = this.newResource(this.getWar());
        }
        return resource;
    }

    @Deprecated(since="12.0.8", forRemoval=true)
    public static void addServerClasses(Server server, String ... patterns) {
        WebAppClassLoading.addHiddenClasses((Server)server, (String[])patterns);
    }

    @Deprecated(since="12.0.8", forRemoval=true)
    public static void addSystemClasses(Server server, String ... patterns) {
        WebAppClassLoading.addProtectedClasses((Server)server, (String[])patterns);
    }

    public class ServletApiContext
    extends ServletContextHandler.ServletContextApi {
        public ServletApiContext() {
            super((ServletContextHandler)WebAppContext.this);
        }

        public ServletContext getContext(String path) {
            ServletContext servletContext = super.getContext(path);
            if (servletContext != null && WebAppContext.this._contextWhiteList != null) {
                for (String context : WebAppContext.this._contextWhiteList) {
                    if (!context.equals(path)) continue;
                    return servletContext;
                }
                return null;
            }
            return servletContext;
        }

        public URL getResource(String path) throws MalformedURLException {
            try {
                if (path == null) {
                    return null;
                }
                Resource resource = WebAppContext.this.getResource(path);
                if (Resources.missing((Resource)resource)) {
                    return null;
                }
                Iterator iterator = resource.iterator();
                if (iterator.hasNext()) {
                    Resource r = (Resource)iterator.next();
                    return r.getURI().toURL();
                }
            }
            catch (MalformedURLException e) {
                throw e;
            }
            catch (Throwable e) {
                throw (MalformedURLException)new MalformedURLException(path).initCause(e);
            }
            return null;
        }
    }
}

