/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.servlet;

import jakarta.servlet.AsyncListener;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletRequestAttributeListener;
import jakarta.servlet.ServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.eclipse.jetty.ee10.servlet.HttpInput;
import org.eclipse.jetty.ee10.servlet.HttpOutput;
import org.eclipse.jetty.ee10.servlet.ServletApiRequest;
import org.eclipse.jetty.ee10.servlet.ServletChannel;
import org.eclipse.jetty.ee10.servlet.ServletChannelState;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletContextResponse;
import org.eclipse.jetty.ee10.servlet.ServletHandler;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.UriCompliance;
import org.eclipse.jetty.http.pathmap.MatchedResource;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Session;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextRequest;
import org.eclipse.jetty.session.AbstractSessionManager;
import org.eclipse.jetty.session.ManagedSession;
import org.eclipse.jetty.session.SessionManager;
import org.eclipse.jetty.util.Fields;
import org.eclipse.jetty.util.URIUtil;

public class ServletContextRequest
extends ContextRequest
implements ServletContextHandler.ServletRequestInfo,
Request.ServeAs {
    public static final String MULTIPART_CONFIG_ELEMENT = "org.eclipse.jetty.multipartConfig";
    static final int INPUT_NONE = 0;
    static final int INPUT_STREAM = 1;
    static final int INPUT_READER = 2;
    static final Fields NO_PARAMS = new Fields(Collections.emptyMap());
    static final Fields BAD_PARAMS = new Fields(Collections.emptyMap());
    private static final Object NULL_VALUE = new Object();
    private final ServletApiRequest _servletApiRequest;
    private final ServletContextResponse _response;
    private final MatchedResource<ServletHandler.MappedServlet> _matchedResource;
    private final HttpInput _httpInput;
    private final String _decodedPathInContext;
    private final ServletChannel _servletChannel;
    private final SessionManager _sessionManager;
    private List<ServletRequestAttributeListener> _requestAttributeListeners;
    private Charset _queryEncoding;
    private HttpFields _trailers;
    private ManagedSession _managedSession;
    AbstractSessionManager.RequestedSession _requestedSession;

    public static ServletContextRequest getServletContextRequest(ServletRequest request) {
        ServletApiRequest servletApiRequest;
        ServletContextHandler.ServletRequestInfo servletRequestInfo;
        if (request instanceof ServletApiRequest && (servletRequestInfo = (servletApiRequest = (ServletApiRequest)request).getServletRequestInfo()) instanceof ServletContextRequest) {
            ServletContextRequest servletContextRequest = (ServletContextRequest)servletRequestInfo;
            return servletContextRequest;
        }
        Object servletContextRequest = request.getAttribute(ServletChannel.class.getName());
        if (servletContextRequest instanceof ServletChannel) {
            ServletChannel servletChannel = (ServletChannel)servletContextRequest;
            return servletChannel.getServletContextRequest();
        }
        while (request instanceof ServletRequestWrapper) {
            ServletApiRequest servletApiRequest2;
            ServletContextHandler.ServletRequestInfo servletRequestInfo2;
            ServletRequestWrapper wrapper = (ServletRequestWrapper)request;
            if (!((request = wrapper.getRequest()) instanceof ServletApiRequest) || !((servletRequestInfo2 = (servletApiRequest2 = (ServletApiRequest)request).getServletRequestInfo()) instanceof ServletContextRequest)) continue;
            ServletContextRequest servletContextRequest2 = (ServletContextRequest)servletRequestInfo2;
            return servletContextRequest2;
        }
        throw new IllegalStateException("could not find %s for %s".formatted(ServletContextRequest.class.getSimpleName(), request));
    }

    protected ServletContextRequest(ServletContextHandler.ServletContextApi servletContextApi, ServletChannel servletChannel, Request request, Response response, String decodedPathInContext, MatchedResource<ServletHandler.MappedServlet> matchedResource, SessionManager sessionManager) {
        super((ContextHandler.ScopedContext)servletContextApi.getContext(), request);
        this._servletChannel = servletChannel;
        this._servletApiRequest = this.newServletApiRequest();
        this._matchedResource = matchedResource;
        this._httpInput = this._servletChannel.getHttpInput();
        this._decodedPathInContext = decodedPathInContext;
        this._response = this.newServletContextResponse(response);
        this._sessionManager = sessionManager;
        this.addIdleTimeoutListener(this._servletChannel.getServletRequestState()::onIdleTimeout);
    }

    public Request wrap(Request request, final HttpURI uri) {
        String decodedPathInContext = URIUtil.decodePath((String)this.getContext().getPathInContext(uri.getCanonicalPath()));
        MatchedResource<ServletHandler.MappedServlet> matchedResource = this.getServletContextHandler().getServletHandler().getMatchedServlet(decodedPathInContext);
        if (matchedResource == null) {
            return null;
        }
        ServletHandler.MappedServlet mappedServlet = (ServletHandler.MappedServlet)matchedResource.getResource();
        if (mappedServlet == null) {
            return null;
        }
        ServletChannel servletChannel = this.getServletChannel();
        ServletContextRequest servletContextRequest = this.getServletContextHandler().newServletContextRequest(servletChannel, (Request)new Request.Wrapper(request){

            public HttpURI getHttpURI() {
                return uri;
            }
        }, (Response)this._response, decodedPathInContext, matchedResource);
        servletChannel.associate(servletContextRequest);
        return servletContextRequest;
    }

    protected ServletApiRequest newServletApiRequest() {
        if (this.getHttpURI().hasViolations() && !this.getServletChannel().getServletContextHandler().getServletHandler().isDecodeAmbiguousURIs()) {
            for (UriCompliance.Violation violation : this.getHttpURI().getViolations()) {
                if (!UriCompliance.AMBIGUOUS_VIOLATIONS.contains(violation)) continue;
                return new ServletApiRequest.AmbiguousURI(this);
            }
        }
        return new ServletApiRequest(this);
    }

    protected ServletContextResponse newServletContextResponse(Response response) {
        return new ServletContextResponse(this._servletChannel, this, response);
    }

    @Override
    public ServletContextHandler getServletContextHandler() {
        return this._servletChannel.getServletContextHandler();
    }

    @Override
    public String getDecodedPathInContext() {
        return this._decodedPathInContext;
    }

    @Override
    public MatchedResource<ServletHandler.MappedServlet> getMatchedResource() {
        return this._matchedResource;
    }

    public HttpFields getTrailers() {
        return this._trailers;
    }

    void setTrailers(HttpFields trailers) {
        this._trailers = trailers;
    }

    @Override
    public ServletChannelState getState() {
        return this._servletChannel.getServletRequestState();
    }

    public ServletContextResponse getServletContextResponse() {
        return this._response;
    }

    @Override
    public ServletContextHandler.ServletScopedContext getServletContext() {
        return (ServletContextHandler.ServletScopedContext)super.getContext();
    }

    @Override
    public HttpInput getHttpInput() {
        return this._httpInput;
    }

    public HttpOutput getHttpOutput() {
        return this._response.getHttpOutput();
    }

    public void errorClose() {
        this._response.getHttpOutput().softClose();
    }

    public boolean isHead() {
        return HttpMethod.HEAD.is(this.getMethod());
    }

    @Override
    public void setQueryEncoding(String queryEncoding) {
        this._queryEncoding = Charset.forName(queryEncoding);
    }

    @Override
    public Charset getQueryEncoding() {
        return this._queryEncoding;
    }

    private Object getAttributeNotNullOrElse(String name, Supplier<Object> getter) {
        Object value = super.getAttribute(name);
        if (value == NULL_VALUE) {
            return null;
        }
        if (value != null) {
            return value;
        }
        return getter.get();
    }

    public Object getAttribute(String name) {
        return switch (name) {
            case "jakarta.servlet.request.cipher_suite" -> super.getAttribute("org.eclipse.jetty.server.cipher");
            case "jakarta.servlet.request.key_size" -> super.getAttribute("org.eclipse.jetty.server.keySize");
            case "jakarta.servlet.request.ssl_session_id" -> super.getAttribute("org.eclipse.jetty.server.sslSessionId");
            case "jakarta.servlet.request.X509Certificate" -> super.getAttribute("org.eclipse.jetty.server.peerCertificates");
            case MULTIPART_CONFIG_ELEMENT -> this.getAttributeNotNullOrElse(name, ((ServletHandler.MappedServlet)this._matchedResource.getResource()).getServletHolder()::getMultipartConfigElement);
            case "org.eclipse.jetty.server.Request.maxFormKeys" -> this.getAttributeNotNullOrElse(name, this.getServletContext().getServletContextHandler()::getMaxFormKeys);
            case "org.eclipse.jetty.server.Request.maxFormContentSize" -> this.getAttributeNotNullOrElse(name, this.getServletContext().getServletContextHandler()::getMaxFormContentSize);
            default -> super.getAttribute(name);
        };
    }

    public Object removeAttribute(String name) {
        return switch (name) {
            case "jakarta.servlet.request.cipher_suite" -> super.removeAttribute("org.eclipse.jetty.server.cipher");
            case "jakarta.servlet.request.key_size" -> super.removeAttribute("org.eclipse.jetty.server.keySize");
            case "jakarta.servlet.request.ssl_session_id" -> super.removeAttribute("org.eclipse.jetty.server.sslSessionId");
            case "jakarta.servlet.request.X509Certificate" -> super.removeAttribute("org.eclipse.jetty.server.peerCertificates");
            case MULTIPART_CONFIG_ELEMENT, "org.eclipse.jetty.server.Request.maxFormKeys", "org.eclipse.jetty.server.Request.maxFormContentSize" -> super.setAttribute(name, NULL_VALUE);
            default -> super.removeAttribute(name);
        };
    }

    public Object setAttribute(String name, Object value) {
        if (value == null) {
            return this.removeAttribute(name);
        }
        return switch (name) {
            case "jakarta.servlet.request.cipher_suite" -> super.setAttribute("org.eclipse.jetty.server.cipher", value);
            case "jakarta.servlet.request.key_size" -> super.setAttribute("org.eclipse.jetty.server.keySize", value);
            case "jakarta.servlet.request.ssl_session_id" -> super.setAttribute("org.eclipse.jetty.server.sslSessionId", value);
            case "jakarta.servlet.request.X509Certificate" -> super.setAttribute("org.eclipse.jetty.server.peerCertificates", value);
            default -> super.setAttribute(name, value);
        };
    }

    private void checkContainsNotNull(Set<String> names, String name, Supplier<Boolean> contains) {
        Object value = super.getAttribute(name);
        if (value == NULL_VALUE) {
            names.remove(name);
        } else if (value != null || contains.get().booleanValue()) {
            names.add(name);
        }
    }

    public Set<String> getAttributeNameSet() {
        HashSet<String> names = new HashSet<String>(super.getAttributeNameSet());
        if (names.contains("org.eclipse.jetty.server.cipher")) {
            names.add("jakarta.servlet.request.cipher_suite");
        }
        if (names.contains("org.eclipse.jetty.server.keySize")) {
            names.add("jakarta.servlet.request.key_size");
        }
        if (names.contains("org.eclipse.jetty.server.sslSessionId")) {
            names.add("jakarta.servlet.request.ssl_session_id");
        }
        if (names.contains("org.eclipse.jetty.server.peerCertificates")) {
            names.add("jakarta.servlet.request.X509Certificate");
        }
        this.checkContainsNotNull(names, MULTIPART_CONFIG_ELEMENT, () -> ((ServletHandler.MappedServlet)this._matchedResource.getResource()).getServletHolder().getMultipartConfigElement() != null);
        this.checkContainsNotNull(names, "org.eclipse.jetty.server.Request.maxFormKeys", () -> this.getServletContext().getServletContextHandler().getMaxFormKeys() >= 0);
        this.checkContainsNotNull(names, "org.eclipse.jetty.server.Request.maxFormContentSize", () -> (long)this.getServletContext().getServletContextHandler().getMaxFormContentSize() >= 0L);
        return names;
    }

    public ServletContextHandler.ServletScopedContext getErrorContext() {
        return this._servletChannel.getContext();
    }

    @Override
    public ServletChannelState getServletRequestState() {
        return this._servletChannel.getServletRequestState();
    }

    @Override
    public ServletChannel getServletChannel() {
        return this._servletChannel;
    }

    public ServletApiRequest getServletApiRequest() {
        return this._servletApiRequest;
    }

    public HttpServletResponse getHttpServletResponse() {
        return this._response.getServletApiResponse();
    }

    public String getServletName() {
        return ((ServletHandler.MappedServlet)this.getMatchedResource().getResource()).getServletHolder().getName();
    }

    @Override
    public List<ServletRequestAttributeListener> getRequestAttributeListeners() {
        if (this._requestAttributeListeners == null) {
            this._requestAttributeListeners = new ArrayList<ServletRequestAttributeListener>();
        }
        return this._requestAttributeListeners;
    }

    public void addEventListener(EventListener listener) {
        if (listener instanceof ServletRequestAttributeListener) {
            ServletRequestAttributeListener attributeListener = (ServletRequestAttributeListener)listener;
            if (this._requestAttributeListeners == null) {
                this._requestAttributeListeners = new ArrayList<ServletRequestAttributeListener>();
            }
            this._requestAttributeListeners.add(attributeListener);
        }
        if (listener instanceof AsyncListener) {
            throw new IllegalArgumentException(listener.getClass().toString());
        }
    }

    public void removeEventListener(EventListener listener) {
        if (this._requestAttributeListeners != null) {
            this._requestAttributeListeners.remove(listener);
        }
    }

    static boolean isNoParams(Fields fields) {
        boolean isNoParams = fields == NO_PARAMS;
        return isNoParams;
    }

    @Override
    public ManagedSession getManagedSession() {
        return this._managedSession;
    }

    public void setManagedSession(ManagedSession managedSession) {
        this._managedSession = managedSession;
    }

    @Override
    public SessionManager getSessionManager() {
        return this._sessionManager;
    }

    public void setRequestedSession(AbstractSessionManager.RequestedSession requestedSession) {
        if (this._requestedSession != null) {
            throw new IllegalStateException();
        }
        this._requestedSession = requestedSession;
        this._managedSession = requestedSession.session();
    }

    @Override
    public AbstractSessionManager.RequestedSession getRequestedSession() {
        return this._requestedSession;
    }

    public Session getSession(boolean create) {
        if (this._managedSession != null) {
            if (this._sessionManager != null && !this._managedSession.isValid()) {
                this._managedSession = null;
            } else {
                return this._managedSession;
            }
        }
        if (!create) {
            return null;
        }
        if (this._response.isCommitted()) {
            throw new IllegalStateException("Response is committed");
        }
        if (this._sessionManager == null) {
            throw new IllegalStateException("No SessionManager");
        }
        this._sessionManager.newSession((Request)this, this._requestedSession.sessionId(), this::setManagedSession);
        if (this._managedSession == null) {
            throw new IllegalStateException("Create session failed");
        }
        HttpCookie cookie = this._sessionManager.getSessionCookie(this._managedSession, this.isSecure());
        if (cookie != null) {
            Response.replaceCookie((Response)this._response, (HttpCookie)cookie);
        }
        return this._managedSession;
    }
}

