/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket;

import java.io.IOException;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.Utf8StringBuilder;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.websocket.WebSocketBuffers;
import org.eclipse.jetty.websocket.WebSocketParser;

public class WebSocketParserD06
implements WebSocketParser {
    private final WebSocketBuffers _buffers;
    private final EndPoint _endp;
    private final WebSocketParser.FrameHandler _handler;
    private final boolean _masked;
    private State _state;
    private Buffer _buffer;
    private boolean _fin;
    private byte _flags;
    private byte _opcode;
    private int _count;
    private long _length;
    private Utf8StringBuilder _utf8;
    private final byte[] _mask = new byte[4];
    private int _m;

    public WebSocketParserD06(WebSocketBuffers buffers, EndPoint endp, WebSocketParser.FrameHandler handler, boolean masked) {
        this._buffers = buffers;
        this._endp = endp;
        this._handler = handler;
        this._masked = masked;
        this._state = this._masked ? State.MASK : State.OPCODE;
    }

    public boolean isBufferEmpty() {
        return this._buffer == null || this._buffer.length() == 0;
    }

    public Buffer getBuffer() {
        return this._buffer;
    }

    public int parseNext() {
        int available;
        if (this._buffer == null) {
            this._buffer = this._buffers.getBuffer();
        }
        int total_filled = 0;
        do {
            if ((available = this._buffer.length()) < this._state.getMinSize() + (this._masked ? 4 : 0) || this._state == State.DATA && available < this._count) {
                this._buffer.compact();
                if (this._buffer.space() == 0) {
                    throw new IllegalStateException("FULL");
                }
                try {
                    int filled;
                    int n = filled = this._endp.isOpen() ? this._endp.fill(this._buffer) : -1;
                    if (filled <= 0) {
                        return total_filled;
                    }
                    total_filled += filled;
                    available = this._buffer.length();
                }
                catch (IOException e) {
                    Log.debug(e);
                    return total_filled > 0 ? total_filled : -1;
                }
            }
            block14: while (this._state != State.DATA && available-- > 0) {
                switch (this._state) {
                    case MASK: {
                        this._buffer.get(this._mask, 0, 4);
                        this._state = State.OPCODE;
                        this._m = 0;
                        continue block14;
                    }
                    case OPCODE: {
                        byte b = this._buffer.get();
                        if (this._masked) {
                            b = (byte)(b ^ this._mask[this._m++ % 4]);
                        }
                        this._opcode = (byte)(b & 0xF);
                        this._flags = (byte)(b >> 4);
                        this._fin = (this._flags & 8) != 0;
                        this._state = State.LENGTH_7;
                        continue block14;
                    }
                    case LENGTH_7: {
                        byte b = this._buffer.get();
                        if (this._masked) {
                            b = (byte)(b ^ this._mask[this._m++ % 4]);
                        }
                        switch (b) {
                            case 127: {
                                this._length = 0L;
                                this._count = 8;
                                this._state = State.LENGTH_63;
                                continue block14;
                            }
                            case 126: {
                                this._length = 0L;
                                this._count = 2;
                                this._state = State.LENGTH_16;
                                continue block14;
                            }
                        }
                        this._length = 0x7F & b;
                        this._count = (int)this._length;
                        this._state = State.DATA;
                        continue block14;
                    }
                    case LENGTH_16: {
                        byte b = this._buffer.get();
                        if (this._masked) {
                            b = (byte)(b ^ this._mask[this._m++ % 4]);
                        }
                        this._length = this._length << 8 | (long)b;
                        if (--this._count != 0) continue block14;
                        if (this._length >= (long)(this._buffer.capacity() - 4)) {
                            throw new IllegalStateException("TOO LARGE");
                        }
                        this._count = (int)this._length;
                        this._state = State.DATA;
                        continue block14;
                    }
                    case LENGTH_63: {
                        byte b = this._buffer.get();
                        if (this._masked) {
                            b = (byte)(b ^ this._mask[this._m++ % 4]);
                        }
                        this._length = this._length << 8 | (long)b;
                        if (--this._count != 0) continue block14;
                        if (this._length >= (long)(this._buffer.capacity() - 10)) {
                            throw new IllegalStateException("TOO LARGE");
                        }
                        this._count = (int)this._length;
                        this._state = State.DATA;
                        continue block14;
                    }
                }
            }
        } while (this._state != State.DATA || available < this._count);
        Buffer data = this._buffer.get(this._count);
        if (this._masked) {
            if (data.array() == null) {
                data = this._buffer.asMutableBuffer();
            }
            byte[] array = data.array();
            int end = data.putIndex();
            int i = data.getIndex();
            while (i < end) {
                int n = i++;
                array[n] = (byte)(array[n] ^ this._mask[this._m++ % 4]);
            }
        }
        this._handler.onFrame(!this._fin, this._flags, this._opcode, data);
        this._count = 0;
        State state = this._state = this._masked ? State.MASK : State.OPCODE;
        if (this._buffer.length() == 0) {
            this._buffers.returnBuffer(this._buffer);
            this._buffer = null;
        }
        return total_filled;
    }

    public void fill(Buffer buffer) {
        if (buffer != null && buffer.length() > 0) {
            if (this._buffer == null) {
                this._buffer = this._buffers.getBuffer();
            }
            this._buffer.put(buffer);
            buffer.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        MASK(0),
        OPCODE(1),
        LENGTH_7(2),
        LENGTH_16(4),
        LENGTH_63(10),
        DATA(10);

        int _minSize;

        private State(int minSize) {
            this._minSize = minSize;
        }

        int getMinSize() {
            return this._minSize;
        }
    }
}

