/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.server.Request;

public class ForceRequestHeaderValueRule
extends Rule {
    private String headerName;
    private String forcedValue;

    public String getHeaderName() {
        return this.headerName;
    }

    public void setHeaderName(String headerName) {
        this.headerName = headerName;
    }

    public String getForcedValue() {
        return this.forcedValue;
    }

    public void setForcedValue(String forcedValue) {
        this.forcedValue = forcedValue;
    }

    @Override
    public String matchAndApply(String target, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String existingValue = httpServletRequest.getHeader(this.headerName);
        if (existingValue == null) {
            return null;
        }
        if (existingValue.equals(this.forcedValue)) {
            return null;
        }
        Request baseRequest = Request.getBaseRequest(httpServletRequest);
        baseRequest.getHttpFields().remove(this.headerName);
        baseRequest.getHttpFields().add(this.headerName, this.forcedValue);
        return target;
    }
}

