/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.client;

import java.io.IOException;
import java.net.CookieStore;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.DecoratedObjectFactory;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.ShutdownThread;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketBehavior;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.api.extensions.ExtensionFactory;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.HttpClientProvider;
import org.eclipse.jetty.websocket.client.WebSocketUpgradeRequest;
import org.eclipse.jetty.websocket.client.io.ConnectionManager;
import org.eclipse.jetty.websocket.client.io.UpgradeListener;
import org.eclipse.jetty.websocket.client.masks.Masker;
import org.eclipse.jetty.websocket.client.masks.RandomMasker;
import org.eclipse.jetty.websocket.common.SessionFactory;
import org.eclipse.jetty.websocket.common.SessionTracker;
import org.eclipse.jetty.websocket.common.WebSocketSession;
import org.eclipse.jetty.websocket.common.WebSocketSessionFactory;
import org.eclipse.jetty.websocket.common.WebSocketSessionListener;
import org.eclipse.jetty.websocket.common.events.EventDriverFactory;
import org.eclipse.jetty.websocket.common.extensions.WebSocketExtensionFactory;
import org.eclipse.jetty.websocket.common.scopes.WebSocketContainerScope;

public class WebSocketClient
extends ContainerLifeCycle
implements WebSocketContainerScope {
    private static final Logger LOG = Log.getLogger(WebSocketClient.class);
    private final HttpClient httpClient;
    private final Supplier<DecoratedObjectFactory> objectFactorySupplier;
    private final WebSocketPolicy policy;
    private final WebSocketExtensionFactory extensionRegistry;
    private final SessionTracker sessionTracker = new SessionTracker();
    private final List<WebSocketSessionListener> sessionListeners = new ArrayList<WebSocketSessionListener>();
    private EventDriverFactory eventDriverFactory;
    private SessionFactory sessionFactory;
    private boolean stopAtShutdown = true;

    public WebSocketClient() {
        this(HttpClientProvider.get(null), null);
    }

    public WebSocketClient(HttpClient httpClient) {
        this(httpClient, null);
    }

    public WebSocketClient(HttpClient httpClient, DecoratedObjectFactory decoratedObjectFactory) {
        this.httpClient = Objects.requireNonNull(httpClient, "HttpClient");
        this.addBean(httpClient);
        this.addBean(this.sessionTracker);
        this.addSessionListener(this.sessionTracker);
        this.policy = WebSocketPolicy.newClientPolicy();
        DecoratedObjectFactory objectFactory = decoratedObjectFactory == null ? new DecoratedObjectFactory() : decoratedObjectFactory;
        this.objectFactorySupplier = () -> objectFactory;
        this.extensionRegistry = new WebSocketExtensionFactory(this);
        this.addBean(this.extensionRegistry);
        this.eventDriverFactory = new EventDriverFactory(this);
        this.sessionFactory = new WebSocketSessionFactory(this);
    }

    @Deprecated
    public WebSocketClient(SslContextFactory sslContextFactory) {
        this(WebSocketClient.newHttpClient(sslContextFactory, null, null), null);
    }

    @Deprecated
    public WebSocketClient(Executor executor) {
        this(WebSocketClient.newHttpClient(null, executor, null), null);
    }

    @Deprecated
    public WebSocketClient(ByteBufferPool bufferPool) {
        this(WebSocketClient.newHttpClient(null, null, bufferPool), null);
    }

    @Deprecated
    public WebSocketClient(SslContextFactory sslContextFactory, Executor executor) {
        this(WebSocketClient.newHttpClient(sslContextFactory, executor, null), null);
    }

    @Deprecated
    public WebSocketClient(WebSocketContainerScope scope) {
        this(WebSocketClient.newHttpClient(scope.getSslContextFactory(), scope.getExecutor(), scope.getBufferPool()), scope.getObjectFactory());
    }

    @Deprecated
    public WebSocketClient(WebSocketContainerScope scope, SslContextFactory sslContextFactory) {
        this(WebSocketClient.newHttpClient(sslContextFactory, scope.getExecutor(), scope.getBufferPool()), scope.getObjectFactory());
    }

    @Deprecated
    public WebSocketClient(SslContextFactory sslContextFactory, Executor executor, ByteBufferPool bufferPool) {
        this(WebSocketClient.newHttpClient(sslContextFactory, executor, bufferPool), null);
    }

    @Deprecated
    public WebSocketClient(WebSocketContainerScope scope, EventDriverFactory eventDriverFactory, SessionFactory sessionFactory) {
        this(scope, eventDriverFactory, sessionFactory, HttpClientProvider.get(scope));
    }

    public WebSocketClient(WebSocketContainerScope scope, EventDriverFactory eventDriverFactory, SessionFactory sessionFactory, HttpClient httpClient) {
        this.httpClient = httpClient == null ? HttpClientProvider.get(scope) : httpClient;
        this.addBean(this.httpClient);
        this.addBean(this.sessionTracker);
        this.addSessionListener(this.sessionTracker);
        this.policy = scope.getPolicy().delegateAs(WebSocketBehavior.CLIENT);
        this.objectFactorySupplier = scope::getObjectFactory;
        this.extensionRegistry = new WebSocketExtensionFactory(this);
        this.addBean(this.extensionRegistry);
        this.eventDriverFactory = eventDriverFactory == null ? new EventDriverFactory(this) : eventDriverFactory;
        this.sessionFactory = sessionFactory == null ? new WebSocketSessionFactory(this) : sessionFactory;
    }

    private static HttpClient newHttpClient(SslContextFactory sslContextFactory, Executor executor, ByteBufferPool bufferPool) {
        HttpClient httpClient = new HttpClient(sslContextFactory);
        httpClient.setExecutor(executor);
        httpClient.setByteBufferPool(bufferPool);
        return httpClient;
    }

    public Future<Session> connect(Object websocket, URI toUri) throws IOException {
        ClientUpgradeRequest request = new ClientUpgradeRequest(toUri);
        request.setRequestURI(toUri);
        request.setLocalEndpoint(websocket);
        return this.connect(websocket, toUri, request);
    }

    public Future<Session> connect(Object websocket, URI toUri, ClientUpgradeRequest request) throws IOException {
        return this.connect(websocket, toUri, request, null);
    }

    public Future<Session> connect(Object websocket, URI toUri, ClientUpgradeRequest request, UpgradeListener upgradeListener) throws IOException {
        if (!this.isStarted()) {
            throw new IllegalStateException(WebSocketClient.class.getSimpleName() + "@" + this.hashCode() + " is not started");
        }
        if (!toUri.isAbsolute()) {
            throw new IllegalArgumentException("WebSocket URI must be absolute");
        }
        if (StringUtil.isBlank(toUri.getScheme())) {
            throw new IllegalArgumentException("WebSocket URI must include a scheme");
        }
        String scheme = toUri.getScheme().toLowerCase(Locale.ENGLISH);
        if (!"ws".equals(scheme) && !"wss".equals(scheme)) {
            throw new IllegalArgumentException("WebSocket URI scheme only supports [ws] and [wss], not [" + scheme + "]");
        }
        if ("wss".equals(scheme) && this.httpClient.getSslContextFactory() == null) {
            throw new IllegalStateException("HttpClient has no SslContextFactory, wss:// URI's are not supported in this configuration");
        }
        request.setRequestURI(toUri);
        request.setLocalEndpoint(websocket);
        for (ExtensionConfig reqExt : request.getExtensions()) {
            if (this.extensionRegistry.isAvailable(reqExt.getName())) continue;
            throw new IllegalArgumentException("Requested extension [" + reqExt.getName() + "] is not installed");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("connect websocket {} to {}", websocket, toUri);
        }
        this.init();
        WebSocketUpgradeRequest wsReq = new WebSocketUpgradeRequest(this, this.httpClient, request);
        wsReq.timeout(request.getTimeout(), TimeUnit.MILLISECONDS);
        wsReq.setUpgradeListener(upgradeListener);
        for (Request.Listener l : this.getBeans(Request.Listener.class)) {
            wsReq.listener(l);
        }
        return wsReq.sendAsync();
    }

    public void setEventDriverFactory(EventDriverFactory eventDriverFactory) {
        this.eventDriverFactory = eventDriverFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    protected void doStart() throws Exception {
        Objects.requireNonNull(this.httpClient, "Provided HttpClient is null");
        super.doStart();
        if (!this.httpClient.isRunning()) {
            throw new IllegalStateException("HttpClient is not running (did you forget to start it?): " + this.httpClient);
        }
    }

    @Override
    protected void doStop() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Stopping {}", this);
        }
        ShutdownThread.deregister(this);
        this.sessionTracker.stop();
        this.extensionRegistry.stop();
        super.doStop();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Stopped {}", this);
        }
    }

    @Deprecated
    public boolean isDispatchIO() {
        return this.httpClient.isDispatchIO();
    }

    @Deprecated
    public long getAsyncWriteTimeout() {
        return this.getPolicy().getAsyncWriteTimeout();
    }

    public SocketAddress getBindAddress() {
        return this.httpClient.getBindAddress();
    }

    @Override
    public ByteBufferPool getBufferPool() {
        return this.httpClient.getByteBufferPool();
    }

    @Deprecated
    public ConnectionManager getConnectionManager() {
        throw new UnsupportedOperationException("ConnectionManager is no longer supported");
    }

    public long getConnectTimeout() {
        return this.httpClient.getConnectTimeout();
    }

    public CookieStore getCookieStore() {
        return this.httpClient.getCookieStore();
    }

    public EventDriverFactory getEventDriverFactory() {
        return this.eventDriverFactory;
    }

    @Override
    public Executor getExecutor() {
        return this.httpClient.getExecutor();
    }

    public ExtensionFactory getExtensionFactory() {
        return this.extensionRegistry;
    }

    @Deprecated
    public Masker getMasker() {
        return new RandomMasker();
    }

    public int getMaxBinaryMessageBufferSize() {
        return this.getPolicy().getMaxBinaryMessageBufferSize();
    }

    public long getMaxBinaryMessageSize() {
        return this.getPolicy().getMaxBinaryMessageSize();
    }

    public long getMaxIdleTimeout() {
        return this.getPolicy().getIdleTimeout();
    }

    public int getMaxTextMessageBufferSize() {
        return this.getPolicy().getMaxTextMessageBufferSize();
    }

    public long getMaxTextMessageSize() {
        return this.getPolicy().getMaxTextMessageSize();
    }

    @Override
    public DecoratedObjectFactory getObjectFactory() {
        return this.objectFactorySupplier.get();
    }

    public Set<WebSocketSession> getOpenSessions() {
        return this.sessionTracker.getSessions();
    }

    @Override
    public WebSocketPolicy getPolicy() {
        return this.policy;
    }

    public Scheduler getScheduler() {
        return this.httpClient.getScheduler();
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    @Override
    public SslContextFactory getSslContextFactory() {
        return this.httpClient.getSslContextFactory();
    }

    @Override
    public void addSessionListener(WebSocketSessionListener listener) {
        this.sessionListeners.add(listener);
    }

    @Override
    public void removeSessionListener(WebSocketSessionListener listener) {
        this.sessionListeners.remove(listener);
    }

    @Override
    public Collection<WebSocketSessionListener> getSessionListeners() {
        return this.sessionListeners;
    }

    private synchronized void init() {
        if (this.isStopAtShutdown() && !ShutdownThread.isRegistered(this)) {
            ShutdownThread.register(this);
        }
    }

    @Deprecated
    protected ConnectionManager newConnectionManager() {
        throw new UnsupportedOperationException("ConnectionManager is no longer supported");
    }

    public void setAsyncWriteTimeout(long ms) {
        this.getPolicy().setAsyncWriteTimeout(ms);
    }

    @Deprecated
    public void setBindAdddress(SocketAddress bindAddress) {
        this.setBindAddress(bindAddress);
    }

    public void setBindAddress(SocketAddress bindAddress) {
        this.httpClient.setBindAddress(bindAddress);
    }

    public void setBufferPool(ByteBufferPool bufferPool) {
        this.httpClient.setByteBufferPool(bufferPool);
    }

    public void setConnectTimeout(long ms) {
        this.httpClient.setConnectTimeout(ms);
    }

    public void setCookieStore(CookieStore cookieStore) {
        this.httpClient.setCookieStore(cookieStore);
    }

    @Deprecated
    public void setDaemon(boolean daemon) {
    }

    @Deprecated
    public void setDispatchIO(boolean dispatchIO) {
        this.httpClient.setDispatchIO(dispatchIO);
    }

    public void setExecutor(Executor executor) {
        this.httpClient.setExecutor(executor);
    }

    @Deprecated
    public void setMasker(Masker masker) {
    }

    public void setMaxBinaryMessageBufferSize(int max) {
        this.getPolicy().setMaxBinaryMessageBufferSize(max);
    }

    public void setMaxIdleTimeout(long ms) {
        this.getPolicy().setIdleTimeout(ms);
        this.httpClient.setIdleTimeout(ms);
    }

    public void setMaxTextMessageBufferSize(int max) {
        this.getPolicy().setMaxTextMessageBufferSize(max);
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public synchronized void setStopAtShutdown(boolean stop) {
        if (stop) {
            if (!this.stopAtShutdown && this.isStarted() && !ShutdownThread.isRegistered(this)) {
                ShutdownThread.register(this);
            }
        } else {
            ShutdownThread.deregister(this);
        }
        this.stopAtShutdown = stop;
    }

    public boolean isStopAtShutdown() {
        return this.stopAtShutdown;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WebSocketClient)) {
            return false;
        }
        WebSocketClient that = (WebSocketClient)o;
        return Objects.equals(this.httpClient, that.httpClient) && Objects.equals(this.policy, that.policy);
    }

    public int hashCode() {
        return Objects.hash(this.httpClient, this.policy);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("WebSocketClient@");
        sb.append(Integer.toHexString(this.hashCode()));
        sb.append("[httpClient=").append(this.httpClient);
        sb.append(",openSessions.size=");
        sb.append(this.getOpenSessions().size());
        sb.append(']');
        return sb.toString();
    }
}

