/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quickstart;

import org.eclipse.jetty.annotations.AnnotationDecorator;
import org.eclipse.jetty.annotations.ServletContainerInitializersStarter;
import org.eclipse.jetty.quickstart.QuickStartDescriptorProcessor;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.StandardDescriptorProcessor;
import org.eclipse.jetty.webapp.WebAppClassLoader;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebInfConfiguration;

public class QuickStartConfiguration
extends WebInfConfiguration {
    private static final Logger LOG = Log.getLogger(QuickStartConfiguration.class);

    @Override
    public void preConfigure(WebAppContext context) throws Exception {
        String war = context.getWar();
        if (war == null || war.length() <= 0) {
            throw new IllegalStateException("No location for webapp");
        }
        this.resolveTempDirectory(context);
        Resource webApp = context.newResource(war);
        if (webApp.isAlias()) {
            LOG.debug(webApp + " anti-aliased to " + webApp.getAlias(), new Object[0]);
            webApp = context.newResource(webApp.getAlias());
        }
        if (!webApp.exists() || !webApp.isDirectory() || webApp.toString().startsWith("jar:")) {
            throw new IllegalStateException("Webapp does not exist or is not unpacked");
        }
        context.setBaseResource(webApp);
        LOG.debug("webapp={}", webApp);
        Resource quickStartWebXml = this.getQuickStartWebXml(context);
        LOG.debug("quickStartWebXml={}", quickStartWebXml);
        context.getMetaData().setWebXml(quickStartWebXml);
    }

    public Resource getQuickStartWebXml(WebAppContext context) throws Exception {
        Resource webInf = context.getWebInf();
        if (webInf == null || !webInf.exists()) {
            throw new IllegalStateException("No WEB-INF");
        }
        LOG.debug("webinf={}", webInf);
        Resource quickStartWebXml = webInf.addPath("quickstart-web.xml");
        if (!quickStartWebXml.exists()) {
            throw new IllegalStateException("No WEB-INF/quickstart-web.xml");
        }
        return quickStartWebXml;
    }

    @Override
    public void configure(WebAppContext context) throws Exception {
        LOG.debug("configure {}", this);
        if (context.isStarted()) {
            LOG.warn("Cannot configure webapp after it is started", new Object[0]);
            return;
        }
        Resource webInf = context.getWebInf();
        if (webInf != null && webInf.isDirectory() && context.getClassLoader() instanceof WebAppClassLoader) {
            Resource lib;
            Resource classes = webInf.addPath("classes/");
            if (classes.exists()) {
                ((WebAppClassLoader)context.getClassLoader()).addClassPath(classes);
            }
            if ((lib = webInf.addPath("lib/")).exists() || lib.isDirectory()) {
                ((WebAppClassLoader)context.getClassLoader()).addJars(lib);
            }
        }
        context.getMetaData().addDescriptorProcessor(new StandardDescriptorProcessor());
        context.getMetaData().addDescriptorProcessor(new QuickStartDescriptorProcessor());
        context.getObjectFactory().addDecorator(new AnnotationDecorator(context));
        ServletContainerInitializersStarter starter = (ServletContainerInitializersStarter)context.getAttribute("org.eclipse.jetty.containerInitializerStarter");
        if (starter != null) {
            throw new IllegalStateException("ServletContainerInitializersStarter already exists");
        }
        starter = new ServletContainerInitializersStarter(context);
        context.setAttribute("org.eclipse.jetty.containerInitializerStarter", starter);
        context.addBean((Object)starter, true);
        LOG.debug("configured {}", this);
    }
}

