/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class InputStreamResponseListener
extends Response.Listener.Adapter {
    private static final Logger LOG = Log.getLogger(InputStreamResponseListener.class);
    private static final byte[] EOF = new byte[0];
    private static final byte[] CLOSED = new byte[0];
    private static final byte[] FAILURE = new byte[0];
    private final BlockingQueue<byte[]> queue = new LinkedBlockingQueue<byte[]>();
    private final AtomicLong length = new AtomicLong();
    private final CountDownLatch responseLatch = new CountDownLatch(1);
    private final CountDownLatch resultLatch = new CountDownLatch(1);
    private final AtomicReference<InputStream> stream = new AtomicReference();
    private final long maxBufferSize;
    private Response response;
    private Result result;
    private volatile Throwable failure;
    private volatile boolean closed;

    public InputStreamResponseListener() {
        this(16384L);
    }

    public InputStreamResponseListener(long maxBufferSize) {
        this.maxBufferSize = maxBufferSize;
    }

    @Override
    public void onHeaders(Response response) {
        this.response = response;
        this.responseLatch.countDown();
    }

    @Override
    public void onContent(Response response, ByteBuffer content) {
        if (!this.closed) {
            int remaining = content.remaining();
            if (remaining > 0) {
                byte[] bytes = new byte[remaining];
                content.get(bytes);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Queuing {}/{} bytes", bytes, remaining);
                }
                this.queue.offer(bytes);
                long newLength = this.length.addAndGet(remaining);
                while (newLength >= this.maxBufferSize) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Queued bytes limit {}/{} exceeded, waiting", newLength, this.maxBufferSize);
                    }
                    if (this.await()) {
                        newLength = this.length.get();
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Queued bytes limit {}/{} exceeded, woken up", newLength, this.maxBufferSize);
                        continue;
                    }
                    break;
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Queuing skipped, empty content {}", content);
            }
        } else {
            LOG.debug("Queuing skipped, stream already closed", new Object[0]);
        }
    }

    @Override
    public void onSuccess(Response response) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Queuing end of content {}{}", EOF, "");
        }
        this.queue.offer(EOF);
        this.signal();
    }

    @Override
    public void onFailure(Response response, Throwable failure) {
        this.fail(failure);
        this.signal();
    }

    @Override
    public void onComplete(Result result) {
        if (result.isFailed() && this.failure == null) {
            this.fail(result.getFailure());
        }
        this.result = result;
        this.resultLatch.countDown();
        this.signal();
    }

    private void fail(Throwable failure) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Queuing failure {} {}", FAILURE, failure);
        }
        this.queue.offer(FAILURE);
        this.failure = failure;
        this.responseLatch.countDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean await() {
        try {
            InputStreamResponseListener inputStreamResponseListener = this;
            synchronized (inputStreamResponseListener) {
                while (this.length.get() >= this.maxBufferSize && this.failure == null && !this.closed) {
                    this.wait();
                }
                return this.failure == null && !this.closed;
            }
        }
        catch (InterruptedException x) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void signal() {
        InputStreamResponseListener inputStreamResponseListener = this;
        synchronized (inputStreamResponseListener) {
            this.notifyAll();
        }
    }

    public Response get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException, ExecutionException {
        boolean expired;
        boolean bl = expired = !this.responseLatch.await(timeout, unit);
        if (expired) {
            throw new TimeoutException();
        }
        if (this.failure != null) {
            throw new ExecutionException(this.failure);
        }
        return this.response;
    }

    public Result await(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        boolean expired;
        boolean bl = expired = !this.resultLatch.await(timeout, unit);
        if (expired) {
            throw new TimeoutException();
        }
        return this.result;
    }

    public InputStream getInputStream() {
        Input result = new Input();
        if (this.stream.compareAndSet(null, result)) {
            return result;
        }
        return IO.getClosedStream();
    }

    private class Input
    extends InputStream {
        private byte[] bytes;
        private int index;

        private Input() {
        }

        @Override
        public int read() throws IOException {
            while (true) {
                if (this.bytes == EOF) {
                    this.index = -1;
                    return -1;
                }
                if (this.bytes == FAILURE) {
                    throw this.failure();
                }
                if (this.bytes == CLOSED) {
                    if (this.index < 0) {
                        return -1;
                    }
                    throw new AsynchronousCloseException();
                }
                if (this.bytes != null) {
                    int result = this.bytes[this.index] & 0xFF;
                    if (++this.index == this.bytes.length) {
                        InputStreamResponseListener.this.length.addAndGet(-this.index);
                        this.bytes = null;
                        this.index = 0;
                        InputStreamResponseListener.this.signal();
                    }
                    return result;
                }
                this.bytes = this.take();
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Dequeued {}/{} bytes", this.bytes, this.bytes.length);
            }
        }

        private IOException failure() {
            if (InputStreamResponseListener.this.failure instanceof IOException) {
                return (IOException)InputStreamResponseListener.this.failure;
            }
            return new IOException(InputStreamResponseListener.this.failure);
        }

        private byte[] take() throws IOException {
            try {
                return (byte[])InputStreamResponseListener.this.queue.take();
            }
            catch (InterruptedException x) {
                throw new InterruptedIOException();
            }
        }

        @Override
        public void close() throws IOException {
            if (!InputStreamResponseListener.this.closed) {
                super.close();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Queuing close {}{}", CLOSED, "");
                }
                InputStreamResponseListener.this.queue.offer(CLOSED);
                InputStreamResponseListener.this.closed = true;
                InputStreamResponseListener.this.signal();
            }
        }
    }
}

