/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.plus.jaas.spi;

import java.sql.Connection;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.sql.DataSource;
import org.eclipse.jetty.plus.jaas.spi.AbstractDatabaseLoginModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceLoginModule
extends AbstractDatabaseLoginModule {
    private String dbJNDIName;
    private DataSource dataSource;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        try {
            super.initialize(subject, callbackHandler, sharedState, options);
            this.dbJNDIName = (String)options.get("dbJNDIName");
            InitialContext ic = new InitialContext();
            this.dataSource = (DataSource)ic.lookup("java:comp/env/" + this.dbJNDIName);
        }
        catch (NamingException e) {
            throw new IllegalStateException(e.toString());
        }
    }

    @Override
    public Connection getConnection() throws Exception {
        return this.dataSource.getConnection();
    }
}

