/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.cm.internal;

import java.util.LinkedList;

public class SerializedTaskQueue {
    private static final int MAX_WAIT = 5000;
    private LinkedList tasks = new LinkedList();
    private Thread thread;
    private String queueName;

    public SerializedTaskQueue(String queueName) {
        this.queueName = queueName;
    }

    public synchronized void put(Runnable task) {
        this.tasks.add(task);
        if (this.thread == null) {
            this.thread = new Thread(this.queueName){

                public void run() {
                    Runnable task = SerializedTaskQueue.this.nextTask(5000);
                    while (task != null) {
                        task.run();
                        task = SerializedTaskQueue.this.nextTask(5000);
                    }
                }
            };
            this.thread.start();
        } else {
            this.notify();
        }
    }

    synchronized Runnable nextTask(int maxWait) {
        if (this.tasks.isEmpty()) {
            try {
                this.wait(maxWait);
            }
            catch (InterruptedException interruptedException) {}
            if (this.tasks.isEmpty()) {
                this.thread = null;
                return null;
            }
        }
        return (Runnable)this.tasks.removeFirst();
    }
}

