/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.cm.internal;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.TreeSet;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationPlugin;
import org.osgi.util.tracker.ServiceTracker;

public class PluginManager {
    private ServiceReference configAdminReference;
    private PluginTracker pluginTracker;
    static /* synthetic */ Class class$0;

    public PluginManager(BundleContext context) {
        this.pluginTracker = new PluginTracker(this, context);
    }

    public synchronized void start(ServiceReference reference) {
        this.configAdminReference = reference;
        this.pluginTracker.open();
    }

    public synchronized void stop() {
        this.pluginTracker.close();
        this.configAdminReference = null;
    }

    public synchronized void modifyConfiguration(Dictionary properties) {
        if (this.configAdminReference == null || properties == null) {
            return;
        }
        ServiceReference[] references = this.pluginTracker.getServiceReferences();
        int i = 0;
        while (i < references.length) {
            block7: {
                ConfigurationPlugin plugin;
                block6: {
                    String[] pids = (String[])references[i].getProperty("cm.target");
                    if (pids == null) break block6;
                    String pid = (String)properties.get("service.pid");
                    if (!Arrays.asList(pids).contains(pid)) break block7;
                }
                if ((plugin = (ConfigurationPlugin)this.pluginTracker.getService(references[i])) != null) {
                    plugin.modifyConfiguration(this.configAdminReference, properties);
                }
            }
            ++i;
        }
    }

    private class PluginTracker
    extends ServiceTracker {
        final Integer ZERO;
        private TreeSet serviceReferences;
        final /* synthetic */ PluginManager this$0;

        public PluginTracker(PluginManager pluginManager, BundleContext context) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.osgi.service.cm.ConfigurationPlugin");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            super(context, clazz.getName(), null);
            this.this$0 = pluginManager;
            this.ZERO = new Integer(0);
            this.serviceReferences = new TreeSet(new Comparator(this){
                final /* synthetic */ PluginTracker this$1;
                {
                    this.this$1 = pluginTracker;
                }

                public int compare(Object o1, Object o2) {
                    return this.getRank((ServiceReference)o1).compareTo(this.getRank((ServiceReference)o2));
                }

                private Integer getRank(ServiceReference ref) {
                    Object ranking = ref.getProperty("service.cmRanking");
                    if (ranking == null || !(ranking instanceof Integer)) {
                        return this.this$1.ZERO;
                    }
                    return (Integer)ranking;
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ServiceReference[] getServiceReferences() {
            TreeSet treeSet = this.serviceReferences;
            synchronized (treeSet) {
                return this.serviceReferences.toArray(new ServiceReference[0]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object addingService(ServiceReference reference) {
            TreeSet treeSet = this.serviceReferences;
            synchronized (treeSet) {
                this.serviceReferences.add(reference);
            }
            return super.addingService(reference);
        }

        public void modifiedService(ServiceReference reference, Object service) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removedService(ServiceReference reference, Object service) {
            TreeSet treeSet = this.serviceReferences;
            synchronized (treeSet) {
                this.serviceReferences.remove(reference);
            }
            super.removedService(reference, service);
        }
    }
}

