/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.cm.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.equinox.cm.internal.LogTracker;
import org.eclipse.equinox.cm.internal.SerializedTaskQueue;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;
import org.osgi.util.tracker.ServiceTracker;

public class EventDispatcher {
    ServiceTracker tracker;
    private SerializedTaskQueue queue = new SerializedTaskQueue("ConfigurationListener Event Queue");
    private ServiceReference configAdminReference;
    private List pendingEvents = new ArrayList();
    private LogTracker logTracker;
    static /* synthetic */ Class class$0;

    public EventDispatcher(BundleContext context, LogTracker logTracker) {
        this.logTracker = logTracker;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.cm.ConfigurationListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.tracker = new ServiceTracker(context, clazz.getName(), null);
    }

    public synchronized void start(ServiceReference reference) {
        this.configAdminReference = reference;
        this.tracker.open();
        Iterator it = this.pendingEvents.iterator();
        while (it.hasNext()) {
            PendingEvent event = (PendingEvent)it.next();
            this.configurationEvent(event.toConfigurationEvent(this.configAdminReference));
        }
        this.pendingEvents.clear();
    }

    public synchronized void stop() {
        this.tracker.close();
        this.configAdminReference = null;
    }

    public synchronized void dispatchEvent(int type, String factoryPid, String pid) {
        if (this.configAdminReference != null) {
            this.configurationEvent(new ConfigurationEvent(this.configAdminReference, type, factoryPid, pid));
        } else {
            this.pendingEvents.add(new PendingEvent(type, factoryPid, pid));
        }
    }

    private void configurationEvent(final ConfigurationEvent event) {
        ServiceReference[] refs = this.tracker.getServiceReferences();
        if (refs == null) {
            return;
        }
        int i = 0;
        while (i < refs.length) {
            final ServiceReference ref = refs[i];
            this.queue.put(new Runnable(){

                public void run() {
                    ConfigurationListener listener = (ConfigurationListener)EventDispatcher.this.tracker.getService(ref);
                    if (listener != null) {
                        try {
                            listener.configurationEvent(event);
                        }
                        catch (Throwable t) {
                            EventDispatcher.this.logTracker.log(1, t.getMessage(), t);
                        }
                    }
                }
            });
            ++i;
        }
    }

    public class PendingEvent {
        private int type;
        private String factoryPid;
        private String pid;

        public PendingEvent(int type, String factoryPid, String pid) {
            this.type = type;
            this.factoryPid = factoryPid;
            this.pid = pid;
        }

        public ConfigurationEvent toConfigurationEvent(ServiceReference configAdminReference) {
            return new ConfigurationEvent(configAdminReference, this.type, this.factoryPid, this.pid);
        }
    }
}

