/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.cm.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.equinox.cm.internal.ConfigurationDictionary;
import org.eclipse.equinox.cm.internal.EventDispatcher;
import org.eclipse.equinox.cm.internal.LogTracker;
import org.eclipse.equinox.cm.internal.PluginManager;
import org.eclipse.equinox.cm.internal.SerializedTaskQueue;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ConfigurationPermission;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.util.tracker.ServiceTracker;

public class ConfigurationAdminFactory
implements ServiceFactory,
BundleListener {
    private Permission configurationPermission = new ConfigurationPermission("*", "configure");
    EventDispatcher eventDispatcher;
    PluginManager pluginManager;
    LogTracker logTracker;
    ManagedServiceTracker managedServiceTracker;
    ManagedServiceFactoryTracker managedServiceFactoryTracker;
    ConfigurationStore configurationStore;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ConfigurationAdminFactory(BundleContext context, LogTracker logTracker) {
        this.logTracker = logTracker;
        this.configurationStore = new ConfigurationStore(context);
        this.eventDispatcher = new EventDispatcher(context, logTracker);
        this.pluginManager = new PluginManager(context);
        this.managedServiceTracker = new ManagedServiceTracker(this, context);
        this.managedServiceFactoryTracker = new ManagedServiceFactoryTracker(this, context);
    }

    public void start(ServiceReference reference) {
        this.eventDispatcher.start(reference);
        this.pluginManager.start(reference);
        this.managedServiceTracker.open();
        this.managedServiceFactoryTracker.open();
    }

    public void stop() {
        this.managedServiceTracker.close();
        this.managedServiceFactoryTracker.close();
        this.eventDispatcher.stop();
        this.pluginManager.stop();
    }

    public Object getService(Bundle bundle, ServiceRegistration registration) {
        return new ConfigurationAdminImpl(bundle);
    }

    public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 16) {
            this.configurationStore.unbindConfigurations(event.getBundle());
        }
    }

    public void checkConfigurationPermission() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(this.configurationPermission);
        }
    }

    class ConfigurationAdminImpl
    implements ConfigurationAdmin {
        private Bundle bundle;

        public ConfigurationAdminImpl(Bundle bundle) {
            this.bundle = bundle;
        }

        public Configuration createFactoryConfiguration(String factoryPid) throws IOException {
            return ConfigurationAdminFactory.this.configurationStore.createFactoryConfiguration(factoryPid, this.bundle.getLocation());
        }

        public Configuration createFactoryConfiguration(String factoryPid, String location) throws IOException {
            ConfigurationAdminFactory.this.checkConfigurationPermission();
            return ConfigurationAdminFactory.this.configurationStore.createFactoryConfiguration(factoryPid, location);
        }

        public Configuration getConfiguration(String pid) throws IOException {
            Configuration config = ConfigurationAdminFactory.this.configurationStore.getConfiguration(pid, this.bundle.getLocation());
            if (!config.getBundleLocation().equals(this.bundle.getLocation())) {
                ConfigurationAdminFactory.this.checkConfigurationPermission();
            }
            return config;
        }

        public Configuration getConfiguration(String pid, String location) throws IOException {
            ConfigurationAdminFactory.this.checkConfigurationPermission();
            return ConfigurationAdminFactory.this.configurationStore.getConfiguration(pid, location);
        }

        public Configuration[] listConfigurations(String filterString) throws IOException, InvalidSyntaxException {
            if (filterString == null) {
                filterString = "(service.pid=*)";
            }
            try {
                ConfigurationAdminFactory.this.checkConfigurationPermission();
            }
            catch (SecurityException securityException) {
                filterString = "(&(service.bundleLocation=" + this.bundle.getLocation() + ")" + filterString + ")";
            }
            return ConfigurationAdminFactory.this.configurationStore.listConfigurations(FrameworkUtil.createFilter((String)filterString));
        }
    }

    class ConfigurationImpl
    implements Configuration {
        private String bundleLocation;
        private String factoryPid;
        private String pid;
        private ConfigurationDictionary dictionary;
        private boolean deleted = false;
        private Bundle boundBundle;
        private int lockedCount = 0;
        private Thread lockHolder = null;

        public ConfigurationImpl(String factoryPid, String pid, String bundleLocation) {
            this.factoryPid = factoryPid;
            this.pid = pid;
            this.bundleLocation = bundleLocation;
        }

        public ConfigurationImpl(Dictionary dictionary) {
            this.pid = (String)dictionary.get("service.pid");
            this.factoryPid = (String)dictionary.get("service.factoryPid");
            this.bundleLocation = (String)dictionary.get("service.bundleLocation");
            this.updateDictionary(dictionary);
        }

        /*
         * Exception decompiling
         */
        protected synchronized void lock() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        protected synchronized void unlock() {
            Thread current = Thread.currentThread();
            if (this.lockHolder != current) {
                throw new IllegalStateException("Thread not lock owner");
            }
            --this.lockedCount;
            if (this.lockedCount == 0) {
                this.lockHolder = null;
                this.notify();
            }
        }

        protected synchronized void checkLocked() {
            Thread current = Thread.currentThread();
            if (this.lockHolder != current) {
                throw new IllegalStateException("Thread not lock owner");
            }
        }

        protected boolean bind(Bundle bundle) {
            try {
                this.lock();
                if (this.boundBundle == null && (this.bundleLocation == null || this.bundleLocation.equals(bundle.getLocation()))) {
                    this.boundBundle = bundle;
                }
                boolean bl = this.boundBundle == bundle;
                return bl;
            }
            finally {
                this.unlock();
            }
        }

        protected void unbind(Bundle bundle) {
            try {
                this.lock();
                if (this.boundBundle == bundle) {
                    this.boundBundle = null;
                }
            }
            finally {
                this.unlock();
            }
        }

        public void delete() throws IOException {
            try {
                this.lock();
                this.checkDeleted();
                this.deleted = true;
                if (this.factoryPid != null) {
                    ConfigurationAdminFactory.this.managedServiceFactoryTracker.notifyDeleted(this);
                } else {
                    ConfigurationAdminFactory.this.managedServiceTracker.notifyDeleted(this);
                }
                ConfigurationAdminFactory.this.eventDispatcher.dispatchEvent(2, this.factoryPid, this.pid);
            }
            finally {
                this.unlock();
            }
            ConfigurationAdminFactory.this.configurationStore.removeConfiguration(this.pid);
        }

        private void checkDeleted() {
            if (this.deleted) {
                throw new IllegalStateException("deleted");
            }
        }

        public String getBundleLocation() {
            try {
                this.lock();
                this.checkDeleted();
                if (this.bundleLocation != null) {
                    String string = this.bundleLocation;
                    return string;
                }
                if (this.boundBundle != null) {
                    String string = this.boundBundle.getLocation();
                    return string;
                }
                return null;
            }
            finally {
                this.unlock();
            }
        }

        protected String getFactoryPid(boolean checkDeleted) {
            try {
                this.lock();
                if (checkDeleted) {
                    this.checkDeleted();
                }
                String string = this.factoryPid;
                return string;
            }
            finally {
                this.unlock();
            }
        }

        public String getFactoryPid() {
            return this.getFactoryPid(true);
        }

        protected String getPid(boolean checkDeleted) {
            try {
                this.lock();
                if (checkDeleted) {
                    this.checkDeleted();
                }
                String string = this.pid;
                return string;
            }
            finally {
                this.unlock();
            }
        }

        public String getPid() {
            return this.getPid(true);
        }

        public Dictionary getProperties() {
            try {
                this.lock();
                this.checkDeleted();
                if (this.dictionary == null) {
                    return null;
                }
                ConfigurationDictionary copy = this.dictionary.copy();
                ((Dictionary)copy).put("service.pid", this.pid);
                if (this.factoryPid != null) {
                    ((Dictionary)copy).put("service.factoryPid", this.factoryPid);
                }
                ConfigurationDictionary configurationDictionary = copy;
                return configurationDictionary;
            }
            finally {
                this.unlock();
            }
        }

        protected Dictionary getAllProperties() {
            try {
                this.lock();
                if (this.deleted) {
                    return null;
                }
                Dictionary copy = this.getProperties();
                if (copy != null && this.bundleLocation != null) {
                    copy.put("service.bundleLocation", this.getBundleLocation());
                }
                Dictionary dictionary = copy;
                return dictionary;
            }
            finally {
                this.unlock();
            }
        }

        public void setBundleLocation(String bundleLocation) {
            try {
                this.lock();
                this.checkDeleted();
                ConfigurationAdminFactory.this.checkConfigurationPermission();
                this.bundleLocation = bundleLocation;
            }
            finally {
                this.unlock();
            }
        }

        public void update() throws IOException {
            try {
                this.lock();
                this.checkDeleted();
                if (this.dictionary == null) {
                    this.dictionary = new ConfigurationDictionary();
                }
                ConfigurationAdminFactory.this.configurationStore.saveConfiguration(this.pid, this);
                if (this.factoryPid != null) {
                    ConfigurationAdminFactory.this.managedServiceFactoryTracker.notifyUpdated(this);
                } else {
                    ConfigurationAdminFactory.this.managedServiceTracker.notifyUpdated(this);
                }
            }
            finally {
                this.unlock();
            }
        }

        public void update(Dictionary properties) throws IOException {
            try {
                this.lock();
                this.checkDeleted();
                this.updateDictionary(properties);
                ConfigurationAdminFactory.this.configurationStore.saveConfiguration(this.pid, this);
                if (this.factoryPid != null) {
                    ConfigurationAdminFactory.this.managedServiceFactoryTracker.notifyUpdated(this);
                } else {
                    ConfigurationAdminFactory.this.managedServiceTracker.notifyUpdated(this);
                }
                ConfigurationAdminFactory.this.eventDispatcher.dispatchEvent(1, this.factoryPid, this.pid);
            }
            finally {
                this.unlock();
            }
        }

        private void updateDictionary(Dictionary properties) {
            ConfigurationDictionary newDictionary = new ConfigurationDictionary();
            Enumeration keys = properties.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                if (newDictionary.get(key) == null) {
                    newDictionary.put(key, properties.get(key));
                    continue;
                }
                throw new IllegalArgumentException(key + " is already present or is a case variant.");
            }
            newDictionary.remove("service.pid");
            newDictionary.remove("service.factoryPid");
            newDictionary.remove("service.bundleLocation");
            this.dictionary = newDictionary;
        }

        public boolean equals(Object obj) {
            return this.pid.equals(((Configuration)obj).getPid());
        }

        public int hashCode() {
            return this.pid.hashCode();
        }

        protected boolean isDeleted() {
            try {
                this.lock();
                boolean bl = this.deleted;
                return bl;
            }
            finally {
                this.unlock();
            }
        }
    }

    class ConfigurationStore {
        private Map configurations = new HashMap();
        private int createdPidCount = 0;
        private File store;

        public ConfigurationStore(BundleContext context) {
            this.store = context.getDataFile("store");
            if (this.store == null) {
                return;
            }
            this.store.mkdir();
            File[] configurationFiles = this.store.listFiles();
            int i = 0;
            while (i < configurationFiles.length) {
                block18: {
                    ObjectInputStream ois;
                    block20: {
                        ois = null;
                        try {
                            ois = new ObjectInputStream(new FileInputStream(configurationFiles[i]));
                            Dictionary dictionary = (Dictionary)ois.readObject();
                            ConfigurationImpl config = new ConfigurationImpl(dictionary);
                            this.configurations.put(config.getPid(), config);
                        }
                        catch (IOException e) {
                            ConfigurationAdminFactory.this.logTracker.log(1, e.getMessage());
                            if (ois != null) {
                                try {
                                    ois.close();
                                }
                                catch (IOException iOException) {}
                            }
                            ois = null;
                            break block18;
                        }
                        catch (ClassNotFoundException e) {
                            block19: {
                                try {
                                    ConfigurationAdminFactory.this.logTracker.log(1, e.getMessage());
                                    if (ois == null) break block19;
                                }
                                catch (Throwable throwable) {
                                    if (ois != null) {
                                        try {
                                            ois.close();
                                        }
                                        catch (IOException iOException) {}
                                    }
                                    ois = null;
                                    throw throwable;
                                }
                                try {
                                    ois.close();
                                }
                                catch (IOException iOException) {}
                            }
                            ois = null;
                            break block18;
                        }
                        if (ois == null) break block20;
                        try {
                            ois.close();
                        }
                        catch (IOException iOException) {}
                    }
                    ois = null;
                }
                ++i;
            }
        }

        public void saveConfiguration(String pid, ConfigurationImpl config) throws IOException {
            if (this.store == null) {
                return;
            }
            config.checkLocked();
            File configFile = new File(this.store, pid);
            ObjectOutputStream oos = null;
            try {
                configFile.createNewFile();
                oos = new ObjectOutputStream(new FileOutputStream(configFile));
                oos.writeObject(config.getAllProperties());
            }
            catch (Throwable throwable) {
                if (oos != null) {
                    try {
                        oos.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException iOException) {}
            }
        }

        public synchronized void removeConfiguration(String pid) {
            this.configurations.remove(pid);
            if (this.store == null) {
                return;
            }
            File configFile = new File(this.store, pid);
            configFile.delete();
        }

        public synchronized Configuration getConfiguration(String pid, String location) {
            Configuration config = (Configuration)this.configurations.get(pid);
            if (config == null) {
                config = new ConfigurationImpl(null, pid, location);
                this.configurations.put(pid, config);
            }
            return config;
        }

        public synchronized Configuration createFactoryConfiguration(String factoryPid, String location) {
            String pid = String.valueOf(factoryPid) + "-" + new Date().getTime() + "-" + this.createdPidCount++;
            ConfigurationImpl config = new ConfigurationImpl(factoryPid, pid, location);
            this.configurations.put(pid, config);
            return config;
        }

        public synchronized ConfigurationImpl findConfiguration(String pid) {
            return (ConfigurationImpl)this.configurations.get(pid);
        }

        public synchronized ConfigurationImpl[] getFactoryConfigurations(String factoryPid) {
            ArrayList<ConfigurationImpl> resultList = new ArrayList<ConfigurationImpl>();
            Iterator it = this.configurations.values().iterator();
            while (it.hasNext()) {
                ConfigurationImpl config = (ConfigurationImpl)it.next();
                String otherFactoryPid = config.getFactoryPid();
                if (otherFactoryPid == null || !otherFactoryPid.equals(factoryPid)) continue;
                resultList.add(config);
            }
            return resultList.toArray(new ConfigurationImpl[0]);
        }

        public synchronized Configuration[] listConfigurations(Filter filter) {
            ArrayList<ConfigurationImpl> resultList = new ArrayList<ConfigurationImpl>();
            Iterator it = this.configurations.values().iterator();
            while (it.hasNext()) {
                ConfigurationImpl config = (ConfigurationImpl)it.next();
                Dictionary properties = config.getAllProperties();
                if (properties == null || !filter.match(properties)) continue;
                resultList.add(config);
            }
            int size = resultList.size();
            return size == 0 ? null : resultList.toArray(new Configuration[size]);
        }

        public synchronized void unbindConfigurations(Bundle bundle) {
            Iterator it = this.configurations.values().iterator();
            while (it.hasNext()) {
                ConfigurationImpl config = (ConfigurationImpl)it.next();
                config.unbind(bundle);
            }
        }
    }

    class ManagedServiceFactoryTracker
    extends ServiceTracker {
        private Map managedServiceFactories;
        private Map managedServiceFactoryReferences;
        private SerializedTaskQueue queue;
        final /* synthetic */ ConfigurationAdminFactory this$0;

        public ManagedServiceFactoryTracker(ConfigurationAdminFactory configurationAdminFactory, BundleContext context) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.osgi.service.cm.ManagedServiceFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            super(context, clazz.getName(), null);
            this.this$0 = configurationAdminFactory;
            this.managedServiceFactories = new HashMap();
            this.managedServiceFactoryReferences = new HashMap();
            this.queue = new SerializedTaskQueue("ManagedServiceFactory Update Queue");
        }

        protected void notifyDeleted(ConfigurationImpl config) {
            config.checkLocked();
            String factoryPid = config.getFactoryPid(false);
            ServiceReference reference = (ServiceReference)this.managedServiceFactoryReferences.get(factoryPid);
            if (reference != null && config.bind(reference.getBundle())) {
                this.asynchDeleted((ManagedServiceFactory)this.managedServiceFactories.get(factoryPid), config.getPid(false));
            }
        }

        protected void notifyUpdated(ConfigurationImpl config) {
            config.checkLocked();
            String factoryPid = config.getFactoryPid();
            ServiceReference reference = (ServiceReference)this.managedServiceFactoryReferences.get(factoryPid);
            if (reference != null && config.bind(reference.getBundle())) {
                Dictionary properties = config.getProperties();
                this.this$0.pluginManager.modifyConfiguration(properties);
                this.asynchUpdated((ManagedServiceFactory)this.managedServiceFactories.get(factoryPid), config.getPid(), properties);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public Object addingService(ServiceReference reference) {
            factoryPid = (String)reference.getProperty("service.pid");
            if (factoryPid == null) {
                return null;
            }
            var3_3 = this.this$0.configurationStore;
            synchronized (var3_3) {
                configs = this.this$0.configurationStore.getFactoryConfigurations(factoryPid);
                try {
                    i = 0;
                    while (i < configs.length) {
                        configs[i].lock();
                        ++i;
                    }
                    if (this.trackManagedServiceFactory(factoryPid, reference)) {
                        i = 0;
                        while (i < configs.length) {
                            if (!configs[i].isDeleted()) {
                                if (configs[i].bind(reference.getBundle())) {
                                    properties = configs[i].getProperties();
                                    this.this$0.pluginManager.modifyConfiguration(properties);
                                    this.asynchUpdated((ManagedServiceFactory)this.managedServiceFactories.get(factoryPid), configs[i].getPid(), properties);
                                } else {
                                    this.this$0.logTracker.log(2, "Configuration for service.pid=" + configs[i].getPid() + " could not be bound to " + reference.getBundle().getLocation());
                                }
                            }
                            ++i;
                        }
                    }
                }
                finally {
                    i = 0;
                    if (true) ** GOTO lbl36
                }
                {
                }
                do {
                    configs[i].unlock();
                    ++i;
lbl36:
                    // 2 sources

                } while (i < configs.length);
                return this.managedServiceFactories.get(factoryPid);
            }
        }

        public void modifiedService(ServiceReference reference, Object service) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void removedService(ServiceReference reference, Object service) {
            factoryPid = (String)reference.getProperty("service.pid");
            var4_4 = this.this$0.configurationStore;
            synchronized (var4_4) {
                configs = this.this$0.configurationStore.getFactoryConfigurations(factoryPid);
                try {
                    i = 0;
                    while (i < configs.length) {
                        configs[i].lock();
                        ++i;
                    }
                    this.untrackManagedServiceFactory(factoryPid, reference);
                }
                finally {
                    i = 0;
                    ** while (i < configs.length)
                }
lbl-1000:
                // 1 sources

                {
                    configs[i].unlock();
                    ++i;
                    continue;
                }
lbl20:
                // 1 sources

            }
        }

        private boolean trackManagedServiceFactory(String factoryPid, ServiceReference reference) {
            ManagedServiceFactory service = (ManagedServiceFactory)this.context.getService(reference);
            if (service == null) {
                return false;
            }
            if (this.managedServiceFactoryReferences.containsKey(factoryPid)) {
                LogTracker logTracker = this.this$0.logTracker;
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.osgi.service.cm.ManagedServiceFactory");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logTracker.log(2, String.valueOf(clazz.getName()) + " already registered for " + "service.pid" + "=" + factoryPid);
                this.context.ungetService(reference);
                return false;
            }
            this.managedServiceFactoryReferences.put(factoryPid, reference);
            this.managedServiceFactories.put(factoryPid, service);
            return true;
        }

        private void untrackManagedServiceFactory(String factoryPid, ServiceReference reference) {
            this.managedServiceFactoryReferences.remove(factoryPid);
            this.managedServiceFactories.remove(factoryPid);
            this.context.ungetService(reference);
        }

        private void asynchDeleted(ManagedServiceFactory service, String pid) {
            this.queue.put(new Runnable(this, service, pid){
                final /* synthetic */ ManagedServiceFactoryTracker this$1;
                private final /* synthetic */ ManagedServiceFactory val$service;
                private final /* synthetic */ String val$pid;
                {
                    this.this$1 = managedServiceFactoryTracker;
                    this.val$service = managedServiceFactory;
                    this.val$pid = string;
                }

                public void run() {
                    try {
                        this.val$service.deleted(this.val$pid);
                    }
                    catch (Throwable t) {
                        ManagedServiceFactoryTracker.access$0((ManagedServiceFactoryTracker)this.this$1).logTracker.log(1, t.getMessage(), t);
                    }
                }
            });
        }

        private void asynchUpdated(ManagedServiceFactory service, String pid, Dictionary properties) {
            this.queue.put(new Runnable(this, service, pid, properties){
                final /* synthetic */ ManagedServiceFactoryTracker this$1;
                private final /* synthetic */ ManagedServiceFactory val$service;
                private final /* synthetic */ String val$pid;
                private final /* synthetic */ Dictionary val$properties;
                {
                    this.this$1 = managedServiceFactoryTracker;
                    this.val$service = managedServiceFactory;
                    this.val$pid = string;
                    this.val$properties = dictionary;
                }

                public void run() {
                    try {
                        this.val$service.updated(this.val$pid, this.val$properties);
                    }
                    catch (ConfigurationException e) {
                        Throwable cause = e.getCause();
                        ManagedServiceFactoryTracker.access$0((ManagedServiceFactoryTracker)this.this$1).logTracker.log(1, e.getMessage(), cause != null ? cause : e);
                    }
                    catch (Throwable t) {
                        ManagedServiceFactoryTracker.access$0((ManagedServiceFactoryTracker)this.this$1).logTracker.log(1, t.getMessage(), t);
                    }
                }
            });
        }

        static /* synthetic */ ConfigurationAdminFactory access$0(ManagedServiceFactoryTracker managedServiceFactoryTracker) {
            return managedServiceFactoryTracker.this$0;
        }
    }

    class ManagedServiceTracker
    extends ServiceTracker {
        private Map managedServices;
        private Map managedServiceReferences;
        private SerializedTaskQueue queue;
        final /* synthetic */ ConfigurationAdminFactory this$0;

        public ManagedServiceTracker(ConfigurationAdminFactory configurationAdminFactory, BundleContext context) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.osgi.service.cm.ManagedService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            super(context, clazz.getName(), null);
            this.this$0 = configurationAdminFactory;
            this.managedServices = new HashMap();
            this.managedServiceReferences = new HashMap();
            this.queue = new SerializedTaskQueue("ManagedService Update Queue");
        }

        protected void notifyDeleted(ConfigurationImpl config) {
            config.checkLocked();
            String pid = config.getPid(false);
            ServiceReference reference = (ServiceReference)this.managedServiceReferences.get(pid);
            if (reference != null && config.bind(reference.getBundle())) {
                this.asynchUpdated((ManagedService)this.managedServices.get(pid), null);
            }
        }

        protected void notifyUpdated(ConfigurationImpl config) {
            config.checkLocked();
            String pid = config.getPid();
            ServiceReference reference = (ServiceReference)this.managedServiceReferences.get(pid);
            if (reference != null && config.bind(reference.getBundle())) {
                Dictionary properties = config.getProperties();
                this.this$0.pluginManager.modifyConfiguration(properties);
                this.asynchUpdated((ManagedService)this.managedServices.get(pid), properties);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object addingService(ServiceReference reference) {
            String pid = (String)reference.getProperty("service.pid");
            if (pid == null) {
                return null;
            }
            ConfigurationStore configurationStore = this.this$0.configurationStore;
            synchronized (configurationStore) {
                block17: {
                    ConfigurationImpl config = this.this$0.configurationStore.findConfiguration(pid);
                    if (config == null && this.trackManagedService(pid, reference)) {
                        this.asynchUpdated((ManagedService)this.managedServices.get(pid), null);
                    } else {
                        try {
                            config.lock();
                            if (!this.trackManagedService(pid, reference)) break block17;
                            if (config.getFactoryPid() != null) {
                                LogTracker logTracker = this.this$0.logTracker;
                                StringBuffer stringBuffer = new StringBuffer("Configuration for service.pid=").append(pid).append(" should only be used by a ");
                                Class<?> clazz = class$1;
                                if (clazz == null) {
                                    try {
                                        clazz = class$1 = Class.forName("org.osgi.service.cm.ManagedServiceFactory");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                logTracker.log(2, stringBuffer.append(clazz.getName()).toString());
                                break block17;
                            }
                            if (config.isDeleted()) {
                                this.asynchUpdated((ManagedService)this.managedServices.get(pid), null);
                            } else if (config.bind(reference.getBundle())) {
                                Dictionary properties = config.getProperties();
                                this.this$0.pluginManager.modifyConfiguration(properties);
                                this.asynchUpdated((ManagedService)this.managedServices.get(pid), properties);
                            } else {
                                this.this$0.logTracker.log(2, "Configuration for service.pid=" + pid + " could not be bound to " + reference.getBundle().getLocation());
                            }
                        }
                        finally {
                            config.unlock();
                        }
                    }
                }
                return this.managedServices.get(pid);
            }
        }

        public void modifiedService(ServiceReference reference, Object service) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removedService(ServiceReference reference, Object service) {
            String pid = (String)reference.getProperty("service.pid");
            ConfigurationStore configurationStore = this.this$0.configurationStore;
            synchronized (configurationStore) {
                ConfigurationImpl config = this.this$0.configurationStore.findConfiguration(pid);
                if (config == null) {
                    this.untrackManagedService(pid, reference);
                } else {
                    try {
                        config.lock();
                        this.untrackManagedService(pid, reference);
                    }
                    finally {
                        config.unlock();
                    }
                }
            }
        }

        private boolean trackManagedService(String pid, ServiceReference reference) {
            ManagedService service = (ManagedService)this.context.getService(reference);
            if (service == null) {
                return false;
            }
            if (this.managedServiceReferences.containsKey(pid)) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.osgi.service.cm.ManagedService");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                String message = String.valueOf(clazz.getName()) + " already registered for " + "service.pid" + "=" + pid;
                this.this$0.logTracker.log(2, message);
                this.context.ungetService(reference);
                return false;
            }
            this.managedServiceReferences.put(pid, reference);
            this.managedServices.put(pid, service);
            return true;
        }

        private void untrackManagedService(String pid, ServiceReference reference) {
            this.managedServiceReferences.remove(pid);
            this.managedServices.remove(pid);
            this.context.ungetService(reference);
        }

        private void asynchUpdated(ManagedService service, Dictionary properties) {
            this.queue.put(new Runnable(this, service, properties){
                final /* synthetic */ ManagedServiceTracker this$1;
                private final /* synthetic */ ManagedService val$service;
                private final /* synthetic */ Dictionary val$properties;
                {
                    this.this$1 = managedServiceTracker;
                    this.val$service = managedService;
                    this.val$properties = dictionary;
                }

                public void run() {
                    try {
                        this.val$service.updated(this.val$properties);
                    }
                    catch (ConfigurationException e) {
                        Throwable cause = e.getCause();
                        ManagedServiceTracker.access$0((ManagedServiceTracker)this.this$1).logTracker.log(1, e.getMessage(), cause != null ? cause : e);
                    }
                    catch (Throwable t) {
                        ManagedServiceTracker.access$0((ManagedServiceTracker)this.this$1).logTracker.log(1, t.getMessage(), t);
                    }
                }
            });
        }

        static /* synthetic */ ConfigurationAdminFactory access$0(ManagedServiceTracker managedServiceTracker) {
            return managedServiceTracker.this$0;
        }
    }
}

