/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.strategy.immutable;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import net.jcip.annotations.Immutable;
import org.eclipse.collections.api.block.HashingStrategy;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.EmptyIterator;
import org.eclipse.collections.impl.factory.HashingStrategySets;
import org.eclipse.collections.impl.set.immutable.AbstractImmutableSet;
import org.eclipse.collections.impl.set.strategy.immutable.ImmutableSetWithHashingStrategySerializationProxy;

@Immutable
final class ImmutableEmptySetWithHashingStrategy<T>
extends AbstractImmutableSet<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final HashingStrategy<? super T> hashingStrategy;

    ImmutableEmptySetWithHashingStrategy(HashingStrategy<? super T> hashingStrategy) {
        this.hashingStrategy = hashingStrategy;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        return other instanceof Set && ((Collection)other).isEmpty();
    }

    @Override
    public int hashCode() {
        return 0;
    }

    @Override
    public ImmutableSet<T> newWith(T element) {
        return HashingStrategySets.immutable.with(this.hashingStrategy, new Object[]{element});
    }

    @Override
    public ImmutableSet<T> newWithAll(Iterable<? extends T> elements) {
        return HashingStrategySets.immutable.withAll(this.hashingStrategy, elements);
    }

    @Override
    public ImmutableSet<T> newWithout(T element) {
        return this;
    }

    @Override
    public ImmutableSet<T> newWithoutAll(Iterable<? extends T> elements) {
        return this;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean contains(Object object) {
        return false;
    }

    public void each(Procedure<? super T> procedure) {
    }

    @Override
    public void forEachWithIndex(ObjectIntProcedure<? super T> objectIntProcedure) {
    }

    @Override
    public <P> void forEachWith(Procedure2<? super T, ? super P> procedure, P parameter) {
    }

    @Override
    public Iterator<T> iterator() {
        return EmptyIterator.getInstance();
    }

    @Override
    public T min(Comparator<? super T> comparator) {
        throw new NoSuchElementException();
    }

    @Override
    public T max(Comparator<? super T> comparator) {
        throw new NoSuchElementException();
    }

    @Override
    public T min() {
        throw new NoSuchElementException();
    }

    @Override
    public T max() {
        throw new NoSuchElementException();
    }

    @Override
    public <V extends Comparable<? super V>> T minBy(Function<? super T, ? extends V> function) {
        throw new NoSuchElementException();
    }

    @Override
    public <V extends Comparable<? super V>> T maxBy(Function<? super T, ? extends V> function) {
        throw new NoSuchElementException();
    }

    @Override
    public <S, R extends Collection<Pair<T, S>>> R zip(Iterable<S> that, R target) {
        return target;
    }

    @Override
    public <R extends Collection<Pair<T, Integer>>> R zipWithIndex(R target) {
        return target;
    }

    public T getFirst() {
        return null;
    }

    public T getLast() {
        return null;
    }

    public T getOnly() {
        throw new IllegalStateException("Size must be 1 but was " + this.size());
    }

    private Object writeReplace() {
        return new ImmutableSetWithHashingStrategySerializationProxy<T>(this, this.hashingStrategy);
    }
}

